/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.ConstraintTestBase;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NodeConstraintTest
extends ConstraintTestBase<WriteTestSupport> {
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }

    LabelSchemaDescriptor schemaDescriptor(int tokenId, int ... propertyIds) {
        return SchemaDescriptors.forLabel((int)tokenId, (int[])propertyIds);
    }

    @Override
    ConstraintDescriptor uniqueConstraintDescriptor(int tokenId, int ... propertyIds) {
        return ConstraintDescriptorFactory.uniqueForLabel((int)tokenId, (int[])propertyIds);
    }

    @Override
    ConstraintDefinition createConstraint(Schema schema, String entityToken, String propertyKey) {
        return schema.constraintFor(Label.label((String)entityToken)).assertPropertyIsUnique(propertyKey).create();
    }

    @Override
    int entityTokenId(TokenWrite tokenWrite, String entityToken) throws KernelException {
        return tokenWrite.labelGetOrCreateForName(entityToken);
    }

    @Override
    Iterator<ConstraintDescriptor> getConstraintsByEntityToken(SchemaRead schemaRead, int entityTokenId) {
        return schemaRead.constraintsGetForLabel(entityTokenId);
    }

    @Test
    void shouldCheckUniquenessWhenAddingLabel() throws Exception {
        int label;
        long nodeNotConflicting;
        long nodeConflicting;
        this.addConstraints("FOO", "prop");
        try (Transaction tx = graphDb.beginTx();){
            Node conflict = tx.createNode();
            conflict.setProperty("prop", (Object)1337);
            nodeConflicting = conflict.getId();
            Node ok = tx.createNode();
            ok.setProperty("prop", (Object)42);
            nodeNotConflicting = ok.getId();
            Node existing = tx.createNode();
            existing.addLabel(Label.label((String)"FOO"));
            existing.setProperty("prop", (Object)1337);
            tx.commit();
        }
        try (KernelTransaction tx = NodeConstraintTest.beginTransaction();){
            label = tx.tokenWrite().labelGetOrCreateForName("FOO");
            Assertions.assertTrue((boolean)tx.dataWrite().nodeAddLabel(nodeNotConflicting, label));
            Assertions.assertThrows(ConstraintValidationException.class, () -> tx.dataWrite().nodeAddLabel(nodeConflicting, label));
            tx.commit();
        }
        tx = NodeConstraintTest.beginTransaction();
        try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.cursorContext());){
            tx.dataRead().singleNode(nodeNotConflicting, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            Assertions.assertTrue((boolean)nodeCursor.labels().contains(label));
            tx.dataRead().singleNode(nodeConflicting, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            Assertions.assertFalse((boolean)nodeCursor.labels().contains(label));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldCheckUniquenessWhenAddingProperties() throws Exception {
        int property;
        long nodeNotConflicting;
        long nodeConflicting;
        this.addConstraints("FOO", "prop");
        try (Transaction tx = graphDb.beginTx();){
            Node conflict = tx.createNode();
            conflict.addLabel(Label.label((String)"FOO"));
            nodeConflicting = conflict.getId();
            Node ok = tx.createNode();
            ok.addLabel(Label.label((String)"BAR"));
            nodeNotConflicting = ok.getId();
            Node existing = tx.createNode();
            existing.addLabel(Label.label((String)"FOO"));
            existing.setProperty("prop", (Object)1337);
            tx.commit();
        }
        try (KernelTransaction tx = NodeConstraintTest.beginTransaction();){
            property = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            tx.dataWrite().nodeSetProperty(nodeNotConflicting, property, (Value)Values.intValue((int)1337));
            Assertions.assertThrows(ConstraintValidationException.class, () -> tx.dataWrite().nodeSetProperty(nodeConflicting, property, (Value)Values.intValue((int)1337)));
            tx.commit();
        }
        tx = NodeConstraintTest.beginTransaction();
        try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.cursorContext());
             PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
            tx.dataRead().singleNode(nodeNotConflicting, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor, PropertySelection.selection((int)property));
            Assertions.assertTrue((boolean)propertyCursor.next());
            tx.dataRead().singleNode(nodeConflicting, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor, PropertySelection.selection((int)property));
            Assertions.assertFalse((boolean)propertyCursor.next());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

