/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.backup;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.commons.io.FilenameUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@DbmsExtension
@ExtendWith(value={RandomExtension.class})
public class IndexBackupIT {
    private static final String PROPERTY_PREFIX = "property";
    private static final int NUMBER_OF_INDEXES = 10;
    @Inject
    private RandomSupport random;
    @Inject
    private GraphDatabaseAPI database;
    private CheckPointer checkPointer;
    private IndexingService indexingService;
    private FileSystemAbstraction fileSystem;

    @Test
    void snapshotFilesDeletedWhenSnapshotReleased() throws IOException {
        Label label = Label.label((String)"testLabel");
        this.prepareDatabase(label);
        ResourceIterator firstCheckpointSnapshot = this.indexingService.snapshotIndexFiles();
        this.generateData(label);
        ResourceIterator secondCheckpointSnapshot = this.indexingService.snapshotIndexFiles();
        this.generateData(label);
        ResourceIterator thirdCheckpointSnapshot = this.indexingService.snapshotIndexFiles();
        Set<String> firstSnapshotFileNames = IndexBackupIT.getFileNames((ResourceIterator<Path>)firstCheckpointSnapshot);
        Set<String> secondSnapshotFileNames = IndexBackupIT.getFileNames((ResourceIterator<Path>)secondCheckpointSnapshot);
        Set<String> thirdSnapshotFileNames = IndexBackupIT.getFileNames((ResourceIterator<Path>)thirdCheckpointSnapshot);
        this.generateData(label);
        IndexBackupIT.forceCheckpoint(this.checkPointer);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstSnapshotFileNames.stream().map(x$0 -> Path.of(x$0, new String[0])).allMatch(file5 -> this.fileSystem.fileExists(file5)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondSnapshotFileNames.stream().map(x$0 -> Path.of(x$0, new String[0])).allMatch(file4 -> this.fileSystem.fileExists(file4)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)thirdSnapshotFileNames.stream().map(x$0 -> Path.of(x$0, new String[0])).allMatch(file3 -> this.fileSystem.fileExists(file3)));
        firstCheckpointSnapshot.close();
        secondCheckpointSnapshot.close();
        thirdCheckpointSnapshot.close();
        this.generateData(label);
        IndexBackupIT.forceCheckpoint(this.checkPointer);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)firstSnapshotFileNames.stream().map(x$0 -> Path.of(x$0, new String[0])).anyMatch(file2 -> this.fileSystem.fileExists(file2)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondSnapshotFileNames.stream().map(x$0 -> Path.of(x$0, new String[0])).anyMatch(file1 -> this.fileSystem.fileExists(file1)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)thirdSnapshotFileNames.stream().map(x$0 -> Path.of(x$0, new String[0])).anyMatch(file -> this.fileSystem.fileExists(file)));
    }

    private static void compareSnapshotFiles(Set<String> firstSnapshotFileNames, Set<String> secondSnapshotFileNames, FileSystemAbstraction fileSystem) {
        ((IterableAssert)Assertions.assertThat(firstSnapshotFileNames).as(String.format("Should have %d modified index segment files. Snapshot segment files are: %s", 10, firstSnapshotFileNames), new Object[0])).hasSize(10);
        for (String fileName : firstSnapshotFileNames) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)secondSnapshotFileNames.contains(fileName), (String)("Snapshot segments fileset should not have files from another snapshot set." + IndexBackupIT.describeFileSets(firstSnapshotFileNames, secondSnapshotFileNames)));
            String path = FilenameUtils.getFullPath((String)fileName);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)secondSnapshotFileNames.stream().anyMatch(name -> name.startsWith(path)), (String)("Snapshot should contain files for index in path: " + path + "." + IndexBackupIT.describeFileSets(firstSnapshotFileNames, secondSnapshotFileNames)));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)fileSystem.fileExists(Path.of(fileName, new String[0])), (String)String.format("Snapshot segment file '%s' should exist.", fileName));
        }
    }

    private void removeOldNodes(LongStream idRange) {
        try (Transaction transaction = this.database.beginTx();){
            idRange.mapToObj(arg_0 -> ((Transaction)transaction).getNodeById(arg_0)).forEach(Node::delete);
            transaction.commit();
        }
    }

    private void updateOldNodes(LongStream idRange) {
        try (Transaction transaction = this.database.beginTx();){
            List<Node> nodes = idRange.mapToObj(arg_0 -> ((Transaction)transaction).getNodeById(arg_0)).collect(Collectors.toList());
            for (int i = 0; i < 10; ++i) {
                String propertyName = PROPERTY_PREFIX + i;
                nodes.forEach(node -> node.setProperty(propertyName, (Object)this.random.nextString()));
            }
            transaction.commit();
        }
    }

    private static String describeFileSets(Set<String> firstFileSet, Set<String> secondFileSet) {
        return "First snapshot files are: " + firstFileSet + System.lineSeparator() + "second snapshot files are: " + secondFileSet;
    }

    private static Set<String> getFileNames(ResourceIterator<Path> files) {
        return files.stream().map(Path::toAbsolutePath).map(Path::toString).filter(IndexBackupIT::segmentsFilePredicate).collect(Collectors.toSet());
    }

    private static void forceCheckpoint(CheckPointer checkPointer) throws IOException {
        checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("testForcedCheckpoint"));
    }

    private void prepareDatabase(Label label) {
        this.generateData(label);
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 10; ++i) {
                transaction.schema().indexFor(label).on(PROPERTY_PREFIX + i).withIndexType(IndexType.TEXT).create();
            }
            transaction.commit();
        }
        try (Transaction tx = this.database.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
        }
        this.checkPointer = this.resolveDependency(CheckPointer.class);
        this.indexingService = this.resolveDependency(IndexingService.class);
        this.fileSystem = this.resolveDependency(FileSystemAbstraction.class);
    }

    private void generateData(Label label) {
        for (int i = 0; i < 100; ++i) {
            this.testNodeCreationTransaction(label, i);
        }
    }

    private void testNodeCreationTransaction(Label label, int i) {
        try (Transaction transaction = this.database.beginTx();){
            Node node = transaction.createNode(new Label[]{label});
            node.setProperty(PROPERTY_PREFIX + i, (Object)("" + i));
            transaction.commit();
        }
    }

    private <T> T resolveDependency(Class<T> clazz) {
        return (T)this.getDatabaseResolver().resolveDependency(clazz);
    }

    private DependencyResolver getDatabaseResolver() {
        return this.database.getDependencyResolver();
    }

    private static boolean segmentsFilePredicate(String fileName) {
        return FilenameUtils.getName((String)fileName).startsWith("segments");
    }

    @Nested
    @DbmsExtension
    class LuceneIndexSnapshots {
        LuceneIndexSnapshots() {
        }

        @Test
        void concurrentLuceneIndexSnapshotUseDifferentSnapshots() throws Exception {
            Label label = Label.label((String)"testLabel");
            IndexBackupIT.this.prepareDatabase(label);
            IndexBackupIT.forceCheckpoint(IndexBackupIT.this.checkPointer);
            ResourceIterator firstCheckpointSnapshot = IndexBackupIT.this.indexingService.snapshotIndexFiles();
            IndexBackupIT.this.generateData(label);
            IndexBackupIT.this.removeOldNodes(LongStream.range(1L, 20L));
            IndexBackupIT.this.updateOldNodes(LongStream.range(30L, 40L));
            IndexBackupIT.forceCheckpoint(IndexBackupIT.this.checkPointer);
            ResourceIterator secondCheckpointSnapshot = IndexBackupIT.this.indexingService.snapshotIndexFiles();
            IndexBackupIT.this.generateData(label);
            IndexBackupIT.this.removeOldNodes(LongStream.range(50L, 60L));
            IndexBackupIT.this.updateOldNodes(LongStream.range(70L, 80L));
            IndexBackupIT.forceCheckpoint(IndexBackupIT.this.checkPointer);
            ResourceIterator thirdCheckpointSnapshot = IndexBackupIT.this.indexingService.snapshotIndexFiles();
            Set<String> firstSnapshotFileNames = IndexBackupIT.getFileNames((ResourceIterator<Path>)firstCheckpointSnapshot);
            Set<String> secondSnapshotFileNames = IndexBackupIT.getFileNames((ResourceIterator<Path>)secondCheckpointSnapshot);
            Set<String> thirdSnapshotFileNames = IndexBackupIT.getFileNames((ResourceIterator<Path>)thirdCheckpointSnapshot);
            IndexBackupIT.compareSnapshotFiles(firstSnapshotFileNames, secondSnapshotFileNames, IndexBackupIT.this.fileSystem);
            IndexBackupIT.compareSnapshotFiles(secondSnapshotFileNames, thirdSnapshotFileNames, IndexBackupIT.this.fileSystem);
            IndexBackupIT.compareSnapshotFiles(thirdSnapshotFileNames, firstSnapshotFileNames, IndexBackupIT.this.fileSystem);
            firstCheckpointSnapshot.close();
            secondCheckpointSnapshot.close();
            thirdCheckpointSnapshot.close();
        }
    }
}

