/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTestSupport;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
public class FulltextIndexMoreDataTest
extends FulltextProceduresTestSupport {
    public static final int ZEBRAS = 100000;
    @Inject
    private RandomSupport random;
    private String topEntity;

    private void setUp(FulltextProceduresTestSupport.EntityUtil entityUtil, boolean before, boolean after) {
        this.createIndexAndWait(entityUtil);
        if (before) {
            this.createSomeZebras(entityUtil);
        }
        try (Transaction tx = this.db.beginTx();){
            this.topEntity = entityUtil.createEntityWithProperty(tx, "zebra zebra zebra zebra donkey");
            tx.commit();
        }
        if (after) {
            this.createSomeZebras(entityUtil);
        }
    }

    private void createSomeZebras(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 100000; ++i) {
                entityUtil.createEntityWithProperty(tx, "zebra donkey");
            }
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canCollectAllHitsWithTopZebraInTheMiddle(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        List<Object> list;
        ResourceIterator<Entity> iterator;
        this.setUp(entityUtil, true, true);
        try (Transaction tx = this.db.beginTx();){
            iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{}");
            try {
                list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, 200000);
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit:1}");
            try {
                list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, 0);
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            int limit = this.random.nextInt(1, 100000);
            try (ResourceIterator<Entity> iterator2 = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit: " + limit + "}");){
                List<Entity> list2 = iterator2.stream().collect(Collectors.toList());
                this.assertSearchResults(list2, limit - 1);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canCollectAllHitsWithTopZebraInTheBeginning(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        List<Object> list;
        ResourceIterator<Entity> iterator;
        this.setUp(entityUtil, false, true);
        try (Transaction tx = this.db.beginTx();){
            iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{}");
            try {
                list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, 100000);
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit:1}");
            try {
                list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, 0);
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            int limit = this.random.nextInt(1, 100000);
            try (ResourceIterator<Entity> iterator2 = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit: " + limit + "}");){
                List<Entity> list2 = iterator2.stream().collect(Collectors.toList());
                this.assertSearchResults(list2, limit - 1);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canCollectAllHitsWithTopZebraAtTheEnd(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        List<Object> list;
        ResourceIterator<Entity> iterator;
        this.setUp(entityUtil, true, false);
        try (Transaction tx = this.db.beginTx();){
            iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{}");
            try {
                list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, 100000);
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit:1}");
            try {
                list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, 0);
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            int limit = this.random.nextInt(1, 100000);
            try (ResourceIterator<Entity> iterator2 = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit: " + limit + "}");){
                List<Entity> list2 = iterator2.stream().collect(Collectors.toList());
                this.assertSearchResults(list2, limit - 1);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void assertSearchResults(List<Entity> list, int extraZebras) {
        Assertions.assertThat(list).hasSize(1 + extraZebras);
        Assertions.assertThat((String)list.get(0).getElementId()).isEqualTo(this.topEntity);
        Assertions.assertThat((Iterable)list.stream().map(Entity::getElementId).collect(Collectors.toSet())).hasSize(list.size());
    }
}

