/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTestSupport;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class FulltextPartitionedIndexSkipAndLimitTest
extends FulltextProceduresTestSupport {
    public static final int ZEBRAS = 24;
    @Inject
    private RandomSupport random;
    private String topEntity;
    private int totalEntities;

    FulltextPartitionedIndexSkipAndLimitTest() {
    }

    @Override
    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        super.configure(builder);
        builder.setConfig(GraphDatabaseInternalSettings.lucene_max_partition_size, (Object)10);
    }

    private void setUp(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            int before = this.random.nextInt(1, 24);
            for (int i = 0; i < before; ++i) {
                entityUtil.createEntityWithProperty(tx, "zebra donkey");
            }
            this.topEntity = entityUtil.createEntityWithProperty(tx, "zebra zebra zebra zebra donkey");
            int after = this.random.nextInt(1, 24);
            for (int i = 0; i < after; ++i) {
                entityUtil.createEntityWithProperty(tx, "zebra donkey");
            }
            this.totalEntities = before + after + 1;
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canCollectAllHitsWithPartitionedIndex(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            try (ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{}");){
                List<Entity> list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, this.totalEntities - 1);
            }
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canFindTopHitInPartitionedIndex(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            try (ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit:1}");){
                List<Entity> list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, 0);
            }
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canCollectTopHitsWithPartitionedIndex(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            int limit = this.random.nextInt(1, this.totalEntities + 1);
            try (ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit: " + limit + "}");){
                List<Entity> list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, limit - 1);
            }
            tx.commit();
        }
    }

    private void assertSearchResults(List<Entity> list, int extraZebras) {
        Assertions.assertThat(list).hasSize(1 + extraZebras);
        Assertions.assertThat((String)list.get(0).getElementId()).isEqualTo(this.topEntity);
        Assertions.assertThat((Iterable)list.stream().map(Entity::getElementId).collect(Collectors.toSet())).hasSize(list.size());
    }
}

