/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class BigPropertyIndexValidationIT {
    @Inject
    private GraphDatabaseService db;
    private Label LABEL;
    private String longString;
    private String propertyKey;

    BigPropertyIndexValidationIT() {
    }

    @BeforeEach
    void setup() {
        this.LABEL = Label.label((String)"LABEL");
        char[] chars = new char[32768];
        Arrays.fill(chars, 'c');
        this.longString = new String(chars);
        this.propertyKey = "name";
    }

    @Test
    void shouldFailTransactionThatIndexesLargePropertyDuringNodeCreation() {
        BigPropertyIndexValidationIT.createIndex(this.db, this.LABEL, this.propertyKey);
        org.junit.jupiter.api.Assertions.assertThrows(TransactionFailureException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.execute("CREATE (n:" + this.LABEL + " {name: \"" + this.longString + "\"})"));
                tx.commit();
            }
            tx = this.db.beginTx();
            try (ResourceIterable allNodes = tx.getAllNodes();){
                Assertions.assertThat((Iterable)allNodes).hasSize(0);
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        });
    }

    @Test
    void shouldFailTransactionThatIndexesLargePropertyAfterNodeCreation() {
        BigPropertyIndexValidationIT.createIndex(this.db, this.LABEL, this.propertyKey);
        org.junit.jupiter.api.Assertions.assertThrows(TransactionFailureException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute("CREATE (n:" + this.LABEL + ")");
                org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.execute("match (n:" + this.LABEL + ")set n.name= \"" + this.longString + "\""));
                tx.commit();
            }
            tx = this.db.beginTx();
            try (ResourceIterable allNodes = tx.getAllNodes();){
                Assertions.assertThat((Iterable)allNodes).hasSize(0);
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        });
    }

    @Test
    void shouldFailTransactionThatIndexesLargePropertyOnLabelAdd() {
        BigPropertyIndexValidationIT.createIndex(this.db, this.LABEL, this.propertyKey);
        org.junit.jupiter.api.Assertions.assertThrows(TransactionFailureException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                String otherLabel = "SomethingElse";
                tx.execute("CREATE (n:" + otherLabel + " {name: \"" + this.longString + "\"})");
                org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.execute("match (n:" + otherLabel + ")set n:" + this.LABEL));
                tx.commit();
            }
            tx = this.db.beginTx();
            try (ResourceIterable allNodes = tx.getAllNodes();){
                Assertions.assertThat((Iterable)allNodes).hasSize(0);
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        });
    }

    private static void createIndex(GraphDatabaseService gds, Label label, String propKey) {
        try (Transaction tx = gds.beginTx();){
            tx.schema().indexFor(label).on(propKey).create();
            tx.commit();
        }
        tx = gds.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

