/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTestSupport;

class FulltextIndexTextArrayTest
extends FulltextProceduresTestSupport {
    FulltextIndexTextArrayTest() {
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void shouldFindIndexedTextArray(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        String id;
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            id = entityUtil.createEntityWithProperty(tx, Iterators.array((Object[])new String[]{"foo", "bar"}));
            tx.commit();
        }
        this.assertEntityFound(entityUtil, id, "foo");
        this.assertEntityFound(entityUtil, id, "bar");
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void shouldFindIndexedTextArraySingleElement(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        String id;
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            id = entityUtil.createEntityWithProperty(tx, Iterators.array((Object[])new String[]{"foo"}));
            tx.commit();
        }
        this.assertEntityFound(entityUtil, id, "foo");
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void shouldFindIndexedTextArrayWithEmptyElement(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        String id;
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            id = entityUtil.createEntityWithProperty(tx, Iterators.array((Object[])new String[]{"foo", "bar", ""}));
            tx.commit();
        }
        this.assertEntityFound(entityUtil, id, "foo");
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void testEmptyArray(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            entityUtil.createEntityWithProperty(tx, new String[0]);
            tx.commit();
        }
        this.assertNothingFound(entityUtil, "*");
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void shouldFindIndexedTextArrayReferencingProperty(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        String id;
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            id = entityUtil.createEntityWithProperty(tx, Iterators.array((Object[])new String[]{"foo", "bar"}));
            tx.commit();
        }
        this.assertEntityFound(entityUtil, id, "prop:bar");
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void shouldFindIndexedCharArray(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        String id;
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            id = entityUtil.createEntityWithProperty(tx, Iterators.array((Object[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}));
            tx.commit();
        }
        this.assertEntityFound(entityUtil, id, "a");
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void shouldFindInCompositeIndex(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        String id;
        this.createCompositeIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            id = entityUtil.createEntityWithProperties(tx, "fred", Iterators.array((Object[])new String[]{"foo", "bar"}));
            tx.commit();
        }
        this.assertEntityFound(entityUtil, id, "prop2:bar");
    }

    private void assertEntityFound(FulltextProceduresTestSupport.EntityUtil entityUtil, String id, String query) {
        try (Transaction tx = this.db.beginTx();
             ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, query, "{}");){
            Assertions.assertThat((String)((Entity)iterator.next()).getElementId()).isEqualTo(id);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
            tx.commit();
        }
    }

    private void assertNothingFound(FulltextProceduresTestSupport.EntityUtil entityUtil, String query) {
        try (Transaction tx = this.db.beginTx();
             ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, query, "{}");){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
            tx.commit();
        }
    }
}

