/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
@DbmsExtension
class CompositeStringLengthValidationIT {
    private static final Label LABEL = TestLabels.LABEL_ONE;
    private static final String KEY = "key";
    private static final String KEY2 = "key2";
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private PageCache pageCache;
    @Inject
    private RandomSupport random;
    private int firstSlotLength;
    private int secondSlotLength;

    CompositeStringLengthValidationIT() {
    }

    @BeforeEach
    void calculateSlotSizes() {
        int totalSpace = TreeNodeDynamicSize.keyValueSizeCapFromPageSize((int)this.pageCache.pageSize()) - 8;
        int perSlotOverhead = 3;
        int firstSlotSpace = totalSpace / 2;
        int secondSlotSpace = totalSpace - firstSlotSpace;
        this.firstSlotLength = firstSlotSpace - perSlotOverhead;
        this.secondSlotLength = secondSlotSpace - perSlotOverhead;
    }

    @Test
    void shouldHandleCompositeSizesCloseToTheLimit() throws KernelException {
        Node node;
        String firstSlot = this.random.nextAlphaNumericString(this.firstSlotLength, this.firstSlotLength);
        String secondSlot = this.random.nextAlphaNumericString(this.secondSlotLength, this.secondSlotLength);
        IndexDescriptor index = this.createIndex(KEY, KEY2);
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty(KEY, (Object)firstSlot);
            node.setProperty(KEY2, (Object)secondSlot);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            int propertyKeyId1 = ktx.tokenRead().propertyKey(KEY);
            int propertyKeyId2 = ktx.tokenRead().propertyKey(KEY2);
            try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                IndexReadSession indexReadSession = ktx.dataRead().indexReadSession(index);
                ktx.dataRead().nodeIndexSeek(ktx.queryContext(), indexReadSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)propertyKeyId1, (Object)firstSlot), PropertyIndexQuery.exact((int)propertyKeyId2, (Object)secondSlot)});
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)node.getId(), (long)cursor.nodeReference());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldFailBeforeCommitOnCompositeSizesLargerThanLimit() {
        String firstSlot = this.random.nextAlphaNumericString(this.firstSlotLength + 1, this.firstSlotLength + 1);
        String secondSlot = this.random.nextAlphaNumericString(this.secondSlotLength, this.secondSlotLength);
        this.createIndex(KEY, KEY2);
        IllegalArgumentException e = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty(KEY, (Object)firstSlot);
                node.setProperty(KEY2, (Object)secondSlot);
                tx.commit();
            }
        });
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Property value is too large to index, please see index documentation for limitations."});
    }

    private IndexDescriptor createIndex(String ... keys) {
        IndexDefinition indexDefinition;
        try (Transaction tx = this.db.beginTx();){
            IndexCreator indexCreator = tx.schema().indexFor(LABEL);
            for (String key : keys) {
                indexCreator = indexCreator.on(key);
            }
            indexDefinition = indexCreator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(30L, TimeUnit.SECONDS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        return ((IndexDefinitionImpl)indexDefinition).getIndexReference();
    }
}

