/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.exceptions.schema.RepeatedLabelInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedRelationshipTypeInSchemaException;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

public class IndexCreateIT
extends KernelIntegrationTest {
    private static final IndexCreator INDEX_CREATOR = (schemaWrite, schema, provider, name) -> schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema).withIndexProvider(schemaWrite.indexProviderByName(provider)).withName(name));
    private static final IndexCreator UNIQUE_CONSTRAINT_CREATOR = (schemaWrite, schema, provider, name) -> schemaWrite.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)schemaWrite.indexProviderByName(provider)).withName(name));

    protected TestDatabaseManagementServiceBuilder configure(TestDatabaseManagementServiceBuilder databaseManagementServiceBuilder) {
        return super.configure(databaseManagementServiceBuilder.setConfig(GraphDatabaseInternalSettings.rel_unique_constraints, (Object)true));
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldCreateIndexWithSpecificExistingProviderName(EntityType entityType) throws KernelException {
        this.shouldCreateWithSpecificExistingProviderName(INDEX_CREATOR, entityType);
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldCreateUniquePropertyConstraintWithSpecificExistingProviderName(EntityType entityType) throws KernelException {
        this.shouldCreateWithSpecificExistingProviderName(UNIQUE_CONSTRAINT_CREATOR, entityType);
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldFailCreateIndexWithNonExistentProviderName(EntityType entityType) throws KernelException {
        this.shouldFailWithNonExistentProviderName(INDEX_CREATOR, entityType);
    }

    @ParameterizedTest
    @EnumSource(value=EntityType.class)
    void shouldFailCreateUniquePropertyConstraintWithNonExistentProviderName(EntityType entityType) throws KernelException {
        this.shouldFailWithNonExistentProviderName(UNIQUE_CONSTRAINT_CREATOR, entityType);
    }

    @Test
    void shouldFailCreateIndexWithDuplicateLabels() throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int labelId = tokenWrite.labelGetOrCreateForName("Label");
        int propId = tokenWrite.propertyKeyGetOrCreateForName("property");
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        FulltextSchemaDescriptor descriptor = SchemaDescriptors.fulltext((org.neo4j.common.EntityType)org.neo4j.common.EntityType.NODE, (int[])new int[]{labelId, labelId}, (int[])new int[]{propId});
        Assertions.assertThrows(RepeatedLabelInSchemaException.class, () -> schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)descriptor)));
    }

    @Test
    void shouldFailCreateIndexWithDuplicateRelationshipTypes() throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int relTypeId = tokenWrite.relationshipTypeGetOrCreateForName("RELATIONSHIP");
        int propId = tokenWrite.propertyKeyGetOrCreateForName("property");
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        FulltextSchemaDescriptor descriptor = SchemaDescriptors.fulltext((org.neo4j.common.EntityType)org.neo4j.common.EntityType.RELATIONSHIP, (int[])new int[]{relTypeId, relTypeId}, (int[])new int[]{propId});
        Assertions.assertThrows(RepeatedRelationshipTypeInSchemaException.class, () -> schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)descriptor)));
    }

    @Test
    void shouldFailCreateIndexWithDuplicateProperties() throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int labelId = tokenWrite.labelGetOrCreateForName("Label");
        int propId = tokenWrite.propertyKeyGetOrCreateForName("property");
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        FulltextSchemaDescriptor descriptor = SchemaDescriptors.fulltext((org.neo4j.common.EntityType)org.neo4j.common.EntityType.NODE, (int[])new int[]{labelId}, (int[])new int[]{propId, propId});
        Assertions.assertThrows(RepeatedPropertyInSchemaException.class, () -> schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)descriptor)));
    }

    protected void shouldFailWithNonExistentProviderName(IndexCreator creator, EntityType entityType) throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int entityTokenId = entityType.entityTokenGetOrCreate(tokenWrite);
        int propId = tokenWrite.propertyKeyGetOrCreateForName("property");
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        Assertions.assertThrows(IndexProviderNotFoundException.class, () -> creator.create(schemaWrite, entityType.createSchemaDescriptor(entityTokenId, propId), "something-completely-different", "index name"));
    }

    protected void shouldCreateWithSpecificExistingProviderName(IndexCreator creator, EntityType entityType) throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int entityTokenId = entityType.entityTokenGetOrCreate(tokenWrite);
        int propId = tokenWrite.propertyKeyGetOrCreateForName("property");
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        SchemaDescriptor descriptor = entityType.createSchemaDescriptor(entityTokenId, propId);
        String provider = RangeIndexProvider.DESCRIPTOR.name();
        String indexName = "index-0";
        creator.create(schemaWrite, descriptor, provider, indexName);
        IndexDescriptor index = this.transaction.kernelTransaction().schemaRead().indexGetForName(indexName);
        this.commit();
        Assertions.assertEquals((Object)provider, (Object)this.indexingService.getIndexProxy(index).getDescriptor().getIndexProvider().name());
    }

    protected static interface IndexCreator {
        public void create(SchemaWrite var1, SchemaDescriptor var2, String var3, String var4) throws KernelException;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum EntityType implements EntityControl
    {
        NODE{

            @Override
            public int entityTokenGetOrCreate(TokenWrite tokenWrite) throws KernelException {
                return tokenWrite.labelGetOrCreateForName("Label0");
            }

            @Override
            public SchemaDescriptor createSchemaDescriptor(int entityToken, int propertyKey) {
                return SchemaDescriptors.forLabel((int)entityToken, (int[])new int[]{propertyKey});
            }
        }
        ,
        RELATIONSHIP{

            @Override
            public int entityTokenGetOrCreate(TokenWrite tokenWrite) throws KernelException {
                return tokenWrite.relationshipTypeGetOrCreateForName("Type0");
            }

            @Override
            public SchemaDescriptor createSchemaDescriptor(int entityToken, int propertyKey) {
                return SchemaDescriptors.forRelType((int)entityToken, (int[])new int[]{propertyKey});
            }
        };

    }

    static interface EntityControl {
        public int entityTokenGetOrCreate(TokenWrite var1) throws KernelException;

        public SchemaDescriptor createSchemaDescriptor(int var1, int var2);
    }
}

