/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.RangeIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.tracking.TrackingIndexExtensionFactory;
import org.neo4j.kernel.impl.index.schema.tracking.TrackingReadersIndexAccessor;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class UniqueIndexSeekIT {
    private static final String NODE_CONSTRAINT_NAME = "uniqueNodeConstraint";
    private static final String RELATIONSHIP_CONSTRAINT_NAME = "uniqueRelationshipConstraint";
    @Inject
    private TestDirectory directory;
    private DatabaseManagementService managementService;

    UniqueIndexSeekIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void nodeUniqueIndexSeekDoNotLeakIndexReaders() throws KernelException {
        TrackingIndexExtensionFactory indexExtensionFactory = new TrackingIndexExtensionFactory((AbstractIndexProviderFactory<?>)new RangeIndexProviderFactory());
        GraphDatabaseAPI database = this.createDatabase(indexExtensionFactory);
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        Config config = (Config)dependencyResolver.resolveDependency(Config.class);
        try {
            Label label = Label.label((String)"spaceship");
            String nameProperty = "name";
            UniqueIndexSeekIT.createNodeUniqueConstraint(database, label, nameProperty);
            UniqueIndexSeekIT.generateRandomData(database, label, nameProperty);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)((Object)indexExtensionFactory.getIndexProvider((String)config.get(GraphDatabaseSettings.initial_default_database))));
            Assertions.assertThat((long)TrackingReadersIndexAccessor.numberOfClosedReaders()).isGreaterThan(0L);
            Assertions.assertThat((long)TrackingReadersIndexAccessor.numberOfOpenReaders()).isGreaterThan(0L);
            Assertions.assertThat((long)TrackingReadersIndexAccessor.numberOfClosedReaders()).isCloseTo(TrackingReadersIndexAccessor.numberOfOpenReaders(), Assertions.within((Long)1L));
            UniqueIndexSeekIT.lockNodeUsingUniqueIndexSeek(database, nameProperty);
            Assertions.assertThat((long)TrackingReadersIndexAccessor.numberOfClosedReaders()).isCloseTo(TrackingReadersIndexAccessor.numberOfOpenReaders(), Assertions.within((Long)1L));
        }
        finally {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void relationshipUniqueIndexSeekDoNotLeakIndexReaders() throws KernelException {
        TrackingIndexExtensionFactory indexExtensionFactory = new TrackingIndexExtensionFactory((AbstractIndexProviderFactory<?>)new RangeIndexProviderFactory());
        GraphDatabaseAPI database = this.createDatabase(indexExtensionFactory);
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        Config config = (Config)dependencyResolver.resolveDependency(Config.class);
        try {
            RelationshipType type = RelationshipType.withName((String)"spaceship");
            String nameProperty = "name";
            UniqueIndexSeekIT.createRelationshipUniqueConstraint(database, type, nameProperty);
            UniqueIndexSeekIT.generateRandomData(database, type, nameProperty);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)((Object)indexExtensionFactory.getIndexProvider((String)config.get(GraphDatabaseSettings.initial_default_database))));
            Assertions.assertThat((long)TrackingReadersIndexAccessor.numberOfClosedReaders()).isGreaterThan(0L);
            Assertions.assertThat((long)TrackingReadersIndexAccessor.numberOfOpenReaders()).isGreaterThan(0L);
            Assertions.assertThat((long)TrackingReadersIndexAccessor.numberOfClosedReaders()).isCloseTo(TrackingReadersIndexAccessor.numberOfOpenReaders(), Assertions.within((Long)1L));
            UniqueIndexSeekIT.lockRelationshipUsingUniqueIndexSeek(database, nameProperty);
            Assertions.assertThat((long)TrackingReadersIndexAccessor.numberOfClosedReaders()).isCloseTo(TrackingReadersIndexAccessor.numberOfOpenReaders(), Assertions.within((Long)1L));
        }
        finally {
            this.managementService.shutdown();
        }
    }

    private GraphDatabaseAPI createDatabase(TrackingIndexExtensionFactory indexExtensionFactory) {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).addExtension((ExtensionFactory)indexExtensionFactory).setConfig(GraphDatabaseInternalSettings.rel_unique_constraints, (Object)true).build();
        return (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private static void lockNodeUsingUniqueIndexSeek(GraphDatabaseAPI database, String nameProperty) throws KernelException {
        try (Transaction transaction = database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            TokenRead tokenRead = kernelTransaction.tokenRead();
            Read dataRead = kernelTransaction.dataRead();
            int propertyId = tokenRead.propertyKey(nameProperty);
            IndexDescriptor indexReference = kernelTransaction.schemaRead().indexGetForName(NODE_CONSTRAINT_NAME);
            try (NodeValueIndexCursor cursor = kernelTransaction.cursors().allocateNodeValueIndexCursor(kernelTransaction.cursorContext(), kernelTransaction.memoryTracker());){
                dataRead.lockingNodeUniqueIndexSeek(indexReference, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.ExactPredicate.exact((int)propertyId, (Object)"value")});
            }
            transaction.commit();
        }
    }

    private static void lockRelationshipUsingUniqueIndexSeek(GraphDatabaseAPI database, String nameProperty) throws KernelException {
        try (Transaction transaction = database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            TokenRead tokenRead = kernelTransaction.tokenRead();
            Read dataRead = kernelTransaction.dataRead();
            int propertyId = tokenRead.propertyKey(nameProperty);
            IndexDescriptor indexReference = kernelTransaction.schemaRead().indexGetForName(RELATIONSHIP_CONSTRAINT_NAME);
            try (RelationshipValueIndexCursor cursor = kernelTransaction.cursors().allocateRelationshipValueIndexCursor(kernelTransaction.cursorContext(), kernelTransaction.memoryTracker());){
                dataRead.lockingRelationshipUniqueIndexSeek(indexReference, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.ExactPredicate.exact((int)propertyId, (Object)"value")});
            }
            transaction.commit();
        }
    }

    private static void generateRandomData(GraphDatabaseAPI database, Label label, String nameProperty) {
        try (Transaction transaction = database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node node = transaction.createNode(new Label[]{label});
                node.setProperty(nameProperty, (Object)("PlanetExpress" + i));
            }
            transaction.commit();
        }
    }

    private static void generateRandomData(GraphDatabaseAPI database, RelationshipType type, String nameProperty) {
        try (Transaction transaction = database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Relationship r = transaction.createNode().createRelationshipTo(transaction.createNode(), type);
                r.setProperty(nameProperty, (Object)("PlanetExpress" + i));
            }
            transaction.commit();
        }
    }

    private static void createNodeUniqueConstraint(GraphDatabaseAPI database, Label label, String nameProperty) throws KernelException {
        try (TransactionImpl transaction = (TransactionImpl)database.beginTx();){
            IndexingTestUtil.createNodePropUniqueConstraintWithSpecifiedProvider((TransactionImpl)transaction, (IndexProviderDescriptor)TrackingIndexExtensionFactory.DESCRIPTOR, (Label)label, (String)nameProperty, (String)NODE_CONSTRAINT_NAME);
            transaction.commit();
        }
        transaction = database.beginTx();
        try {
            transaction.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private static void createRelationshipUniqueConstraint(GraphDatabaseAPI database, RelationshipType type, String nameProperty) throws KernelException {
        try (TransactionImpl transaction = (TransactionImpl)database.beginTx();){
            IndexingTestUtil.createRelPropUniqueConstraintWithSpecifiedProvider((TransactionImpl)transaction, (IndexProviderDescriptor)TrackingIndexExtensionFactory.DESCRIPTOR, (RelationshipType)type, (String)nameProperty, (String)RELATIONSHIP_CONSTRAINT_NAME);
            transaction.commit();
        }
        transaction = database.beginTx();
        try {
            transaction.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }
}

