/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.index.IndexUsageStats;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
public class IndexUsageStatsNotEnabledIT {
    @Inject
    private GraphDatabaseAPI db;

    @Disabled(value="Enable once index usage feature is hidden behind kernel version and we dont throw exception anymore")
    @Test
    void assertDefaultValuesWhenIndexUsageFeatureNonAvailable() throws IndexNotFoundKernelException {
        String indexName = "index";
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(Label.label((String)"Label")).on("prop").withName(indexName).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.triggerReportUsageStatistics();
        tx = this.db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        try {
            KernelTransaction ktx = tx.kernelTransaction();
            IndexDescriptor index = ktx.schemaRead().indexGetForName(indexName);
            IndexUsageStats stats = ktx.schemaRead().indexUsageStats(index);
            Assertions.assertThat((long)stats.trackedSince()).isEqualTo(0L);
            Assertions.assertThat((long)stats.lastRead()).isEqualTo(0L);
            Assertions.assertThat((long)stats.readCount()).isEqualTo(0L);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void triggerReportUsageStatistics() {
        ((IndexingService)this.db.getDependencyResolver().resolveDependency(IndexingService.class)).reportUsageStatistics();
    }
}

