/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.ConstraintTestBase;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class RelationshipConstraintTest
extends ConstraintTestBase<WriteTestSupport> {
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport(){

            protected TestDatabaseManagementServiceBuilder configure(TestDatabaseManagementServiceBuilder builder) {
                return super.configure(builder.setConfig(GraphDatabaseInternalSettings.rel_unique_constraints, (Object)true));
            }
        };
    }

    @Override
    SchemaDescriptor schemaDescriptor(int tokenId, int ... propertyIds) {
        return SchemaDescriptors.forRelType((int)tokenId, (int[])propertyIds);
    }

    @Override
    ConstraintDescriptor uniqueConstraintDescriptor(int tokenId, int ... propertyIds) {
        return ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schemaDescriptor(tokenId, propertyIds));
    }

    @Override
    ConstraintDefinition createConstraint(Schema schema, String entityToken, String propertyKey) {
        return schema.constraintFor(RelationshipType.withName((String)entityToken)).assertPropertyIsUnique(propertyKey).create();
    }

    @Override
    int entityTokenId(TokenWrite tokenWrite, String entityToken) throws KernelException {
        return tokenWrite.relationshipTypeGetOrCreateForName(entityToken);
    }

    @Override
    Iterator<ConstraintDescriptor> getConstraintsByEntityToken(SchemaRead schemaRead, int entityTokenId) {
        return schemaRead.constraintsGetForRelationshipType(entityTokenId);
    }

    @Test
    void shouldCheckUniquenessWhenAddingProperties() throws Exception {
        int property;
        long notConflicting;
        long conflicting;
        this.addConstraints("FOO", "prop");
        try (Transaction tx = this.graphDb.beginTx();){
            Node node = tx.createNode();
            RelationshipType type = RelationshipType.withName((String)"FOO");
            Relationship conflict = node.createRelationshipTo(node, type);
            conflicting = conflict.getId();
            Node node2 = tx.createNode();
            Relationship ok = node.createRelationshipTo(node2, RelationshipType.withName((String)"BAR"));
            notConflicting = ok.getId();
            Relationship existing = node.createRelationshipTo(node2, type);
            existing.setProperty("prop", (Object)1337);
            tx.commit();
        }
        try (KernelTransaction tx = this.beginTransaction();){
            property = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            tx.dataWrite().relationshipSetProperty(notConflicting, property, (Value)Values.intValue((int)1337));
            Assertions.assertThrows(ConstraintValidationException.class, () -> tx.dataWrite().relationshipSetProperty(conflicting, property, (Value)Values.intValue((int)1337)));
            tx.commit();
        }
        tx = this.beginTransaction();
        try (RelationshipScanCursor relCursor = tx.cursors().allocateRelationshipScanCursor(tx.cursorContext());
             PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
            tx.dataRead().singleRelationship(notConflicting, relCursor);
            Assertions.assertTrue((boolean)relCursor.next());
            relCursor.properties(propertyCursor, PropertySelection.selection((int)property));
            Assertions.assertTrue((boolean)propertyCursor.next());
            Assertions.assertEquals((Object)propertyCursor.propertyValue(), (Object)Values.intValue((int)1337));
            tx.dataRead().singleRelationship(conflicting, relCursor);
            Assertions.assertTrue((boolean)relCursor.next());
            relCursor.properties(propertyCursor, PropertySelection.selection((int)property));
            Assertions.assertFalse((boolean)propertyCursor.next());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

