/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.schema;

import java.io.UncheckedIOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.common.EntityType;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.impl.schema.TextIndexProvider;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexProvider;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexStoreViewFactory;
import org.neo4j.kernel.impl.transaction.state.storeview.NodeStoreScan;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.LockService;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ReadableStorageEngine;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.time.Clocks;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ImpermanentDbmsExtension
public class MultiIndexPopulationConcurrentUpdatesIT {
    private static final String NAME_PROPERTY = "name";
    private static final String COUNTRY_LABEL = "country";
    private static final String COLOR_LABEL = "color";
    private static final String CAR_LABEL = "car";
    @Inject
    private GraphDatabaseAPI db;
    private IndexDescriptor[] rules;
    private StorageEngine storageEngine;
    private SchemaCache schemaCache;
    private IndexingService indexService;
    private int propertyId;
    private Map<String, Integer> labelsNameIdMap;
    private Map<Integer, String> labelsIdNameMap;
    private Node country1;
    private Node country2;
    private Node color1;
    private Node color2;
    private Node car1;
    private Node car2;
    private Node[] otherNodes;

    @AfterEach
    void tearDown() throws Throwable {
        if (this.indexService != null) {
            this.indexService.shutdown();
        }
    }

    @BeforeEach
    void setUp() {
        this.prepareDb();
        this.labelsNameIdMap = this.getLabelsNameIdMap();
        this.labelsIdNameMap = this.labelsNameIdMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.propertyId = this.getPropertyId();
        this.storageEngine = (StorageEngine)this.db.getDependencyResolver().resolveDependency(StorageEngine.class);
    }

    private static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{RangeIndexProvider.DESCRIPTOR, IndexType.RANGE}), Arguments.of((Object[])new Object[]{TextIndexProvider.DESCRIPTOR, IndexType.TEXT}), Arguments.of((Object[])new Object[]{TrigramIndexProvider.DESCRIPTOR, IndexType.TEXT}));
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void applyConcurrentDeletesToPopulatedIndex(IndexProviderDescriptor provider, IndexType indexType) throws Throwable {
        ArrayList<EntityUpdates> updates = new ArrayList<EntityUpdates>(2);
        updates.add(EntityUpdates.forEntity((long)this.country1.getId(), (boolean)false).withTokens(this.id(COUNTRY_LABEL)).removed(this.propertyId, Values.of((Object)"Sweden")).build());
        updates.add(EntityUpdates.forEntity((long)this.color2.getId(), (boolean)false).withTokens(this.id(COLOR_LABEL)).removed(this.propertyId, Values.of((Object)"green")).build());
        this.launchCustomIndexPopulation(provider, indexType, this.labelsNameIdMap, this.propertyId, new UpdateGenerator(updates));
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        try (Transaction tx = this.db.beginTx();){
            Integer countryLabelId = this.labelsNameIdMap.get(COUNTRY_LABEL);
            Integer colorLabelId = this.labelsNameIdMap.get(COLOR_LABEL);
            try (ValueIndexReader indexReader = this.getIndexReader(this.propertyId, countryLabelId);){
                ((AbstractLongAssert)Assertions.assertThat((long)indexReader.countIndexedEntities(0L, CursorContext.NULL_CONTEXT, new int[]{this.propertyId}, new Value[]{Values.of((Object)"Sweden")})).as("Should be removed by concurrent remove.", new Object[0])).isEqualTo(0L);
            }
            indexReader = this.getIndexReader(this.propertyId, colorLabelId);
            try {
                ((AbstractLongAssert)Assertions.assertThat((long)indexReader.countIndexedEntities(3L, CursorContext.NULL_CONTEXT, new int[]{this.propertyId}, new Value[]{Values.of((Object)"green")})).as("Should be removed by concurrent remove.", new Object[0])).isEqualTo(0L);
            }
            finally {
                if (indexReader != null) {
                    indexReader.close();
                }
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void applyConcurrentAddsToPopulatedIndex(IndexProviderDescriptor provider, IndexType indexType) throws Throwable {
        ArrayList<EntityUpdates> updates = new ArrayList<EntityUpdates>(2);
        updates.add(EntityUpdates.forEntity((long)this.otherNodes[0].getId(), (boolean)false).withTokens(this.id(COUNTRY_LABEL)).added(this.propertyId, Values.of((Object)"Denmark")).build());
        updates.add(EntityUpdates.forEntity((long)this.otherNodes[1].getId(), (boolean)false).withTokens(this.id(CAR_LABEL)).added(this.propertyId, Values.of((Object)"BMW")).build());
        this.launchCustomIndexPopulation(provider, indexType, this.labelsNameIdMap, this.propertyId, new UpdateGenerator(updates));
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        try (Transaction tx = this.db.beginTx();){
            Integer countryLabelId = this.labelsNameIdMap.get(COUNTRY_LABEL);
            Integer carLabelId = this.labelsNameIdMap.get(CAR_LABEL);
            try (ValueIndexReader indexReader = this.getIndexReader(this.propertyId, countryLabelId);){
                ((AbstractLongAssert)Assertions.assertThat((long)indexReader.countIndexedEntities(this.otherNodes[0].getId(), CursorContext.NULL_CONTEXT, new int[]{this.propertyId}, new Value[]{Values.of((Object)"Denmark")})).as("Should be added by concurrent add.", new Object[0])).isEqualTo(1L);
            }
            indexReader = this.getIndexReader(this.propertyId, carLabelId);
            try {
                ((AbstractLongAssert)Assertions.assertThat((long)indexReader.countIndexedEntities(this.otherNodes[1].getId(), CursorContext.NULL_CONTEXT, new int[]{this.propertyId}, new Value[]{Values.of((Object)"BMW")})).as("Should be added by concurrent add.", new Object[0])).isEqualTo(1L);
            }
            finally {
                if (indexReader != null) {
                    indexReader.close();
                }
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void applyConcurrentChangesToPopulatedIndex(IndexProviderDescriptor provider, IndexType indexType) throws Throwable {
        ArrayList<EntityUpdates> updates = new ArrayList<EntityUpdates>(2);
        updates.add(EntityUpdates.forEntity((long)this.color2.getId(), (boolean)false).withTokens(this.id(COLOR_LABEL)).changed(this.propertyId, Values.of((Object)"green"), Values.of((Object)"pink")).build());
        updates.add(EntityUpdates.forEntity((long)this.car2.getId(), (boolean)false).withTokens(this.id(CAR_LABEL)).changed(this.propertyId, Values.of((Object)"Ford"), Values.of((Object)"SAAB")).build());
        this.launchCustomIndexPopulation(provider, indexType, this.labelsNameIdMap, this.propertyId, new UpdateGenerator(updates));
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        try (Transaction tx = this.db.beginTx();){
            Integer colorLabelId = this.labelsNameIdMap.get(COLOR_LABEL);
            Integer carLabelId = this.labelsNameIdMap.get(CAR_LABEL);
            try (ValueIndexReader indexReader = this.getIndexReader(this.propertyId, colorLabelId);){
                ((AbstractLongAssert)Assertions.assertThat((long)indexReader.countIndexedEntities(this.color2.getId(), CursorContext.NULL_CONTEXT, new int[]{this.propertyId}, new Value[]{Values.of((Object)"green")})).as(String.format("Should be deleted by concurrent change. Reader is: %s, ", indexReader), new Object[0])).isEqualTo(0L);
            }
            indexReader = this.getIndexReader(this.propertyId, colorLabelId);
            try {
                ((AbstractLongAssert)Assertions.assertThat((long)indexReader.countIndexedEntities(this.color2.getId(), CursorContext.NULL_CONTEXT, new int[]{this.propertyId}, new Value[]{Values.of((Object)"pink")})).as("Should be updated by concurrent change.", new Object[0])).isEqualTo(1L);
            }
            finally {
                if (indexReader != null) {
                    indexReader.close();
                }
            }
            indexReader = this.getIndexReader(this.propertyId, carLabelId);
            try {
                ((AbstractLongAssert)Assertions.assertThat((long)indexReader.countIndexedEntities(this.car2.getId(), CursorContext.NULL_CONTEXT, new int[]{this.propertyId}, new Value[]{Values.of((Object)"SAAB")})).as("Should be added by concurrent change.", new Object[0])).isEqualTo(1L);
            }
            finally {
                if (indexReader != null) {
                    indexReader.close();
                }
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void dropOneOfTheIndexesWhilePopulationIsOngoingDoesInfluenceOtherPopulators(IndexProviderDescriptor provider, IndexType indexType) throws Throwable {
        this.launchCustomIndexPopulation(provider, indexType, this.labelsNameIdMap, this.propertyId, new IndexDropAction(this.labelsNameIdMap.get(COLOR_LABEL)));
        this.labelsNameIdMap.remove(COLOR_LABEL);
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        this.checkIndexIsOnline(this.labelsNameIdMap.get(CAR_LABEL));
        this.checkIndexIsOnline(this.labelsNameIdMap.get(COUNTRY_LABEL));
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void indexDroppedDuringPopulationDoesNotExist(IndexProviderDescriptor provider, IndexType indexType) throws Throwable {
        Integer labelToDropId = this.labelsNameIdMap.get(COLOR_LABEL);
        this.launchCustomIndexPopulation(provider, indexType, this.labelsNameIdMap, this.propertyId, new IndexDropAction(labelToDropId));
        this.labelsNameIdMap.remove(COLOR_LABEL);
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        org.junit.jupiter.api.Assertions.assertThrows(IndexNotFoundKernelException.class, () -> {
            Iterator iterator = this.schemaCache.indexesForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelToDropId, (int[])new int[]{this.propertyId}));
            while (iterator.hasNext()) {
                IndexDescriptor index = (IndexDescriptor)iterator.next();
                this.indexService.getIndexProxy(index);
            }
        });
    }

    private void checkIndexIsOnline(int labelId) throws IndexNotFoundKernelException {
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{this.propertyId});
        IndexDescriptor index = (IndexDescriptor)Iterators.single((Iterator)this.schemaCache.indexesForSchema((SchemaDescriptor)schema));
        IndexProxy indexProxy = this.indexService.getIndexProxy(index);
        org.junit.jupiter.api.Assertions.assertSame((Object)InternalIndexState.ONLINE, (Object)indexProxy.getState());
    }

    private long[] id(String label) {
        return new long[]{this.labelsNameIdMap.get(label).intValue()};
    }

    private ValueIndexReader getIndexReader(int propertyId, Integer countryLabelId) throws IndexNotFoundKernelException {
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)countryLabelId, (int[])new int[]{propertyId});
        IndexDescriptor index = (IndexDescriptor)Iterators.single((Iterator)this.schemaCache.indexesForSchema((SchemaDescriptor)schema));
        return this.indexService.getIndexProxy(index).newValueReader();
    }

    private void launchCustomIndexPopulation(IndexProviderDescriptor provider, IndexType indexType, Map<String, Integer> labelNameIdMap, int propertyId, Runnable customAction) throws Throwable {
        StorageEngine storageEngine = this.getStorageEngine();
        try (Transaction transaction = this.db.beginTx();){
            Config config = Config.defaults();
            KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
            JobScheduler scheduler = this.getJobScheduler();
            NullLogProvider nullLogProvider = NullLogProvider.getInstance();
            IndexStoreViewFactory indexStoreViewFactory = (IndexStoreViewFactory)Mockito.mock(IndexStoreViewFactory.class);
            Mockito.when((Object)indexStoreViewFactory.createTokenIndexStoreView((IndexingService.IndexProxyProvider)ArgumentMatchers.any())).thenAnswer(invocation -> this.dynamicIndexStoreViewWrapper(customAction, storageEngine, (IndexingService.IndexProxyProvider)invocation.getArgument(0), config, scheduler));
            IndexProviderMap providerMap = this.getIndexProviderMap();
            this.indexService = IndexingServiceFactory.createIndexingService((ReadableStorageEngine)storageEngine, (Config)config, (JobScheduler)scheduler, (IndexProviderMap)providerMap, (IndexStoreViewFactory)indexStoreViewFactory, (TokenNameLookup)ktx.tokenRead(), (Iterable)Database.initialSchemaRulesLoader((StorageEngine)storageEngine), (InternalLogProvider)nullLogProvider, (IndexMonitor)IndexMonitor.NO_MONITOR, (SchemaState)this.getSchemaState(), (IndexStatisticsStore)((IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class)), (CursorContextFactory)new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY), (MemoryTracker)EmptyMemoryTracker.INSTANCE, (String)"", (DatabaseReadOnlyChecker)DatabaseReadOnlyChecker.writable(), (Clock)Clocks.nanoClock());
            this.indexService.start();
            this.rules = this.createIndexRules(provider, indexType, labelNameIdMap, propertyId);
            this.schemaCache = new SchemaCache((ConstraintRuleAccessor)new StandardConstraintSemantics(), (IndexConfigCompleter)providerMap, storageEngine.indexingBehaviour());
            this.schemaCache.load(Iterables.iterable((Object[])this.rules));
            this.indexService.createIndexes(Subject.AUTH_DISABLED, this.rules);
            transaction.commit();
        }
    }

    private DynamicIndexStoreView dynamicIndexStoreViewWrapper(Runnable customAction, StorageEngine storageEngine, IndexingService.IndexProxyProvider indexProxies, Config config, JobScheduler scheduler) {
        LockService lockService = LockService.NO_LOCK_SERVICE;
        Locks locks = Locks.NO_LOCKS;
        FullScanStoreView fullScanStoreView = new FullScanStoreView(lockService, (ReadableStorageEngine)storageEngine, Config.defaults(), scheduler);
        return new DynamicIndexStoreViewWrapper(fullScanStoreView, indexProxies, lockService, locks, storageEngine, customAction, config, scheduler);
    }

    private void waitAndActivateIndexes(Map<String, Integer> labelsIds, int propertyId) throws IndexNotFoundKernelException, IndexPopulationFailedKernelException, InterruptedException, IndexActivationFailedKernelException {
        try (Transaction tx = this.db.beginTx();){
            for (int labelId : labelsIds.values()) {
                this.waitIndexOnline(this.indexService, propertyId, labelId);
            }
        }
    }

    private int getPropertyId() {
        try (Transaction tx = this.db.beginTx();){
            int n = MultiIndexPopulationConcurrentUpdatesIT.getPropertyIdByName(tx, NAME_PROPERTY);
            return n;
        }
    }

    private Map<String, Integer> getLabelsNameIdMap() {
        try (Transaction tx = this.db.beginTx();){
            Map<String, Integer> map = MultiIndexPopulationConcurrentUpdatesIT.getLabelIdsByName(tx, COUNTRY_LABEL, COLOR_LABEL, CAR_LABEL);
            return map;
        }
    }

    private void waitIndexOnline(IndexingService indexService, int propertyId, int labelId) throws IndexNotFoundKernelException, IndexPopulationFailedKernelException, InterruptedException, IndexActivationFailedKernelException {
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyId});
        IndexDescriptor index = (IndexDescriptor)Iterators.single((Iterator)this.schemaCache.indexesForSchema((SchemaDescriptor)schema));
        IndexProxy indexProxy = indexService.getIndexProxy(index);
        indexProxy.awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
        while (indexProxy.getState() != InternalIndexState.ONLINE) {
            Thread.sleep(10L);
        }
        indexProxy.activate();
    }

    private IndexDescriptor[] createIndexRules(IndexProviderDescriptor provider, IndexType indexType, Map<String, Integer> labelNameIdMap, int propertyId) {
        IndexProviderMap indexProviderMap = this.getIndexProviderMap();
        IndexProvider indexProvider = indexProviderMap.lookup(provider.name());
        IndexProviderDescriptor providerDescriptor = indexProvider.getProviderDescriptor();
        ArrayList<IndexDescriptor> list = new ArrayList<IndexDescriptor>();
        for (Integer labelId : labelNameIdMap.values()) {
            LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyId});
            IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)providerDescriptor).withIndexType(indexType).withName("index_" + labelId).materialise((long)labelId.intValue());
            index = indexProvider.completeConfiguration(index, this.storageEngine.indexingBehaviour());
            list.add(index);
        }
        return list.toArray(new IndexDescriptor[0]);
    }

    private static Map<String, Integer> getLabelIdsByName(Transaction tx, String ... names) {
        HashMap<String, Integer> labelNameIdMap = new HashMap<String, Integer>();
        KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
        TokenRead tokenRead = ktx.tokenRead();
        for (String name : names) {
            labelNameIdMap.put(name, tokenRead.nodeLabel(name));
        }
        return labelNameIdMap;
    }

    private static int getPropertyIdByName(Transaction tx, String name) {
        KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
        return ktx.tokenRead().propertyKey(name);
    }

    private void prepareDb() {
        Label countryLabel = Label.label((String)COUNTRY_LABEL);
        Label color = Label.label((String)COLOR_LABEL);
        Label car = Label.label((String)CAR_LABEL);
        try (Transaction transaction = this.db.beginTx();){
            this.country1 = MultiIndexPopulationConcurrentUpdatesIT.createNamedLabeledNode(transaction, countryLabel, "Sweden");
            this.country2 = MultiIndexPopulationConcurrentUpdatesIT.createNamedLabeledNode(transaction, countryLabel, "USA");
            this.color1 = MultiIndexPopulationConcurrentUpdatesIT.createNamedLabeledNode(transaction, color, "red");
            this.color2 = MultiIndexPopulationConcurrentUpdatesIT.createNamedLabeledNode(transaction, color, "green");
            this.car1 = MultiIndexPopulationConcurrentUpdatesIT.createNamedLabeledNode(transaction, car, "Volvo");
            this.car2 = MultiIndexPopulationConcurrentUpdatesIT.createNamedLabeledNode(transaction, car, "Ford");
            this.otherNodes = new Node[250];
            for (int i = 0; i < 250; ++i) {
                this.otherNodes[i] = transaction.createNode();
            }
            transaction.commit();
        }
    }

    private static Node createNamedLabeledNode(Transaction tx, Label label, String name) {
        Node node = tx.createNode(new Label[]{label});
        node.setProperty(NAME_PROPERTY, (Object)name);
        return node;
    }

    private StorageEngine getStorageEngine() {
        return (StorageEngine)this.db.getDependencyResolver().resolveDependency(StorageEngine.class);
    }

    private SchemaState getSchemaState() {
        return (SchemaState)this.db.getDependencyResolver().resolveDependency(SchemaState.class);
    }

    private IndexProviderMap getIndexProviderMap() {
        return (IndexProviderMap)this.db.getDependencyResolver().resolveDependency(IndexProviderMap.class);
    }

    private JobScheduler getJobScheduler() {
        return (JobScheduler)this.db.getDependencyResolver().resolveDependency(JobScheduler.class);
    }

    private class UpdateGenerator
    implements Runnable {
        private final Iterable<EntityUpdates> updates;

        UpdateGenerator(Iterable<EntityUpdates> updates) {
            this.updates = updates;
        }

        @Override
        public void run() {
            for (EntityUpdates update : this.updates) {
                Transaction transaction = MultiIndexPopulationConcurrentUpdatesIT.this.db.beginTx();
                try {
                    Node node = transaction.getNodeById(update.getEntityId());
                    for (int labelId : MultiIndexPopulationConcurrentUpdatesIT.this.labelsNameIdMap.values()) {
                        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{MultiIndexPopulationConcurrentUpdatesIT.this.propertyId});
                        block18: for (IndexEntryUpdate indexUpdate : update.valueUpdatesForIndexKeys(Collections.singleton(() -> schema))) {
                            ValueIndexEntryUpdate valueUpdate = (ValueIndexEntryUpdate)indexUpdate;
                            switch (valueUpdate.updateMode()) {
                                case CHANGED: 
                                case ADDED: {
                                    node.addLabel(Label.label((String)MultiIndexPopulationConcurrentUpdatesIT.this.labelsIdNameMap.get(schema.getLabelId())));
                                    node.setProperty(MultiIndexPopulationConcurrentUpdatesIT.NAME_PROPERTY, valueUpdate.values()[0].asObject());
                                    continue block18;
                                }
                                case REMOVED: {
                                    node.addLabel(Label.label((String)MultiIndexPopulationConcurrentUpdatesIT.this.labelsIdNameMap.get(schema.getLabelId())));
                                    node.delete();
                                    continue block18;
                                }
                            }
                            throw new IllegalArgumentException(valueUpdate.updateMode().name());
                        }
                    }
                    transaction.commit();
                }
                finally {
                    if (transaction == null) continue;
                    transaction.close();
                }
            }
            try (StorageReader reader = MultiIndexPopulationConcurrentUpdatesIT.this.storageEngine.newReader();){
                for (EntityUpdates update : this.updates) {
                    Set relatedIndexes = MultiIndexPopulationConcurrentUpdatesIT.this.schemaCache.getValueIndexesRelatedTo(update.entityTokensChanged(), update.entityTokensUnchanged(), update.propertiesChanged(), false, EntityType.NODE);
                    Iterable entryUpdates = update.valueUpdatesForIndexKeys((Iterable)relatedIndexes, reader, EntityType.NODE, CursorContext.NULL_CONTEXT, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                    MultiIndexPopulationConcurrentUpdatesIT.this.indexService.applyUpdates(entryUpdates, CursorContext.NULL_CONTEXT, false);
                }
            }
            catch (UncheckedIOException | KernelException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class IndexDropAction
    implements Runnable {
        private final int labelIdToDropIndexFor;

        private IndexDropAction(int labelIdToDropIndexFor) {
            this.labelIdToDropIndexFor = labelIdToDropIndexFor;
        }

        @Override
        public void run() {
            LabelSchemaDescriptor descriptor = SchemaDescriptors.forLabel((int)this.labelIdToDropIndexFor, (int[])new int[]{MultiIndexPopulationConcurrentUpdatesIT.this.propertyId});
            IndexDescriptor rule = this.findRuleForLabel(descriptor);
            MultiIndexPopulationConcurrentUpdatesIT.this.indexService.dropIndex(rule);
        }

        private IndexDescriptor findRuleForLabel(LabelSchemaDescriptor schemaDescriptor) {
            for (IndexDescriptor rule : MultiIndexPopulationConcurrentUpdatesIT.this.rules) {
                if (!rule.schema().equals(schemaDescriptor)) continue;
                return rule;
            }
            return null;
        }
    }

    private static class DynamicIndexStoreViewWrapper
    extends DynamicIndexStoreView {
        private final Runnable customAction;
        private final JobScheduler jobScheduler;

        DynamicIndexStoreViewWrapper(FullScanStoreView fullScanStoreView, IndexingService.IndexProxyProvider indexProxies, LockService lockService, Locks locks, StorageEngine storageEngine, Runnable customAction, Config config, JobScheduler jobScheduler) {
            super(fullScanStoreView, locks, lockService, config, indexProxies, (ReadableStorageEngine)storageEngine, (InternalLogProvider)NullLogProvider.getInstance());
            this.customAction = customAction;
            this.jobScheduler = jobScheduler;
        }

        public StoreScan visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, PropertyScanConsumer propertyScanConsumer, TokenScanConsumer labelScanConsumer, boolean forceStoreScan, boolean parallelWrite, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
            StoreScan storeScan = super.visitNodes(labelIds, propertyKeyIdFilter, propertyScanConsumer, labelScanConsumer, forceStoreScan, parallelWrite, contextFactory, memoryTracker);
            return new LabelViewNodeStoreWrapper(this.storageEngine.newReader(), arg_0 -> ((ReadableStorageEngine)this.storageEngine).createStorageCursors(arg_0), this.lockService, null, propertyScanConsumer, labelIds, propertyKeyIdFilter, (NodeStoreScan)storeScan, this.customAction, this.jobScheduler);
        }
    }

    private static class DelegatingEntityIdIterator
    implements EntityIdIterator {
        private final Runnable customAction;
        private final EntityIdIterator delegate;

        DelegatingEntityIdIterator(EntityIdIterator delegate, Runnable customAction) {
            this.delegate = delegate;
            this.customAction = customAction;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public long next() {
            long value = this.delegate.next();
            if (!this.hasNext()) {
                this.customAction.run();
            }
            return value;
        }

        public void close() {
            this.delegate.close();
        }

        public void invalidateCache() {
            this.delegate.invalidateCache();
        }
    }

    private static class LabelViewNodeStoreWrapper
    extends NodeStoreScan {
        private final NodeStoreScan delegate;
        private final Runnable customAction;

        LabelViewNodeStoreWrapper(StorageReader storageReader, Function<CursorContext, StoreCursors> storeCursorsFactory, LockService locks, TokenScanConsumer labelScanConsumer, PropertyScanConsumer propertyUpdatesConsumer, int[] labelIds, IntPredicate propertyKeyIdFilter, NodeStoreScan delegate, Runnable customAction, JobScheduler jobScheduler) {
            super(Config.defaults(), storageReader, storeCursorsFactory, locks, labelScanConsumer, propertyUpdatesConsumer, labelIds, propertyKeyIdFilter, false, jobScheduler, new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.delegate = delegate;
            this.customAction = customAction;
        }

        public EntityIdIterator getEntityIdIterator(CursorContext cursorContext, StoreCursors storeCursors) {
            EntityIdIterator originalIterator = this.delegate.getEntityIdIterator(cursorContext, storeCursors);
            return new DelegatingEntityIdIterator(originalIterator, this.customAction);
        }
    }
}

