/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.TestInfo;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;
import org.neo4j.test.utils.TestDirectory;

public class Neo4jWithSocket {
    static final String NEO4J_WITH_SOCKET = "org.neo4j.bolt.transport.Neo4jWithSocket";
    private Consumer<Map<Setting<?>, Object>> configure;
    private final TestDirectory testDirectory;
    private TestDatabaseManagementServiceBuilder graphDatabaseFactory;
    private GraphDatabaseService gdb;
    private Path workingDirectory;
    private ConnectorPortRegister connectorRegister;
    private DatabaseManagementService managementService;
    private Path listenFile;
    private Config config;

    public Neo4jWithSocket(TestDatabaseManagementServiceBuilder graphDatabaseFactory, TestDirectory testDirectory, Consumer<Map<Setting<?>, Object>> configure) {
        this.testDirectory = testDirectory;
        this.graphDatabaseFactory = graphDatabaseFactory;
        this.configure = configure;
    }

    public FileSystemAbstraction getFileSystem() {
        return this.testDirectory.getFileSystem();
    }

    public DatabaseManagementService getManagementService() {
        return this.managementService;
    }

    public void setConfigure(Consumer<Map<Setting<?>, Object>> configure) {
        this.configure = configure;
    }

    public void setGraphDatabaseFactory(TestDatabaseManagementServiceBuilder graphDatabaseFactory) {
        this.graphDatabaseFactory = graphDatabaseFactory;
    }

    public void init(TestInfo testInfo) throws IOException {
        String testName = ((Method)testInfo.getTestMethod().get()).getName();
        this.workingDirectory = this.testDirectory.directory(testName);
        this.listenFile = Path.of("/tmp", testName);
        this.ensureDatabase(settings -> {});
    }

    public HostnamePort lookupConnector(ConnectorType connectorType) {
        return this.connectorRegister.getLocalAddress(connectorType);
    }

    public HostnamePort lookupDefaultConnector() {
        return this.connectorRegister.getLocalAddress(ConnectorType.BOLT);
    }

    public void shutdownDatabase() {
        try {
            if (this.managementService != null) {
                this.managementService.shutdown();
            }
        }
        finally {
            this.connectorRegister = null;
            this.gdb = null;
            this.managementService = null;
        }
    }

    public void ensureDatabase(Consumer<Map<Setting<?>, Object>> overrideSettingsFunction) {
        if (this.gdb != null) {
            return;
        }
        Map<Setting<?>, Object> settings = this.configure(overrideSettingsFunction);
        Path storeDir = this.workingDirectory.resolve("storeDir");
        this.installSelfSignedCertificateIfEncryptionEnabled(settings);
        String databaseName = (String)settings.get(GraphDatabaseSettings.initial_default_database);
        if (databaseName == null) {
            databaseName = "neo4j";
        }
        this.managementService = this.graphDatabaseFactory.setFileSystem(this.testDirectory.getFileSystem()).setDatabaseRootDirectory(storeDir).setConfig((Map)settings).build();
        this.gdb = this.managementService.database(databaseName);
        this.connectorRegister = (ConnectorPortRegister)((GraphDatabaseAPI)this.gdb).getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
        this.config = (Config)((GraphDatabaseAPI)this.gdb).getDependencyResolver().resolveDependency(Config.class);
    }

    private void installSelfSignedCertificateIfEncryptionEnabled(Map<Setting<?>, Object> settings) {
        Object encryptionLevel = settings.get(BoltConnector.encryption_level);
        if (encryptionLevel != BoltConnector.EncryptionLevel.DISABLED) {
            Path certificates = this.workingDirectory.resolve("certificates");
            SelfSignedCertificateFactory.create((FileSystemAbstraction)this.getFileSystem(), (Path)certificates);
            settings.put(SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT).enabled, Boolean.TRUE);
            settings.put(SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT).base_directory, certificates);
        }
        SslPolicyConfig clusterConfig = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.CLUSTER);
        if (settings.containsKey(clusterConfig.enabled)) {
            Path clusterCertificates = this.workingDirectory.resolve("cluster-cert");
            SelfSignedCertificateFactory.create((FileSystemAbstraction)this.getFileSystem(), (Path)clusterCertificates);
            settings.put(SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.CLUSTER).enabled, Boolean.TRUE);
            settings.put(SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.CLUSTER).base_directory, clusterCertificates);
        }
    }

    private Map<Setting<?>, Object> configure(Consumer<Map<Setting<?>, Object>> overrideSettingsFunction) {
        HashMap settings = new HashMap();
        settings.put(GraphDatabaseSettings.auth_enabled, false);
        settings.put(BoltConnector.enabled, true);
        settings.put(BoltConnector.listen_address, new SocketAddress("localhost", 0));
        settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.DISABLED);
        if (!SystemUtils.IS_OS_WINDOWS) {
            settings.put(BoltConnectorInternalSettings.enable_loopback_auth, true);
            settings.put(BoltConnectorInternalSettings.unsupported_loopback_listen_file, this.listenFile);
            settings.put(BoltConnectorInternalSettings.unsupported_loopback_delete, true);
        }
        settings.put(BoltConnectorInternalSettings.enable_local_connector, true);
        this.configure.accept(settings);
        overrideSettingsFunction.accept(settings);
        return settings;
    }

    public static Consumer<Map<Setting<?>, Object>> withOptionalBoltEncryption() {
        return settings -> settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
    }

    public GraphDatabaseService graphDatabaseService() {
        return this.gdb;
    }

    public Path lookupUnixConnector() {
        return this.listenFile;
    }

    public String lookupLocalConnector() {
        return (String)this.config.get(BoltConnectorInternalSettings.local_channel_address);
    }
}

