/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Scanner;
import org.junit.jupiter.api.Assertions;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.PortUtils;

public class MetricEndpoints {
    public static String getPrometheusResponse(GraphDatabaseService database) throws Exception {
        HostnamePort connectorAddress = PortUtils.getConnectorAddress((GraphDatabaseAPI)((GraphDatabaseAPI)database), (ConnectorType)ConnectorType.PROMETHEUS);
        return MetricEndpoints.getPrometheusResponse(connectorAddress);
    }

    public static String getPrometheusResponse(HostnamePort connectorAddress) throws Exception {
        String url = "http://" + String.valueOf(connectorAddress) + "/metrics";
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder(URI.create(url)).build();
            String result = client.send(request, HttpResponse.BodyHandlers.ofString()).body();
            Scanner s = new Scanner(result).useDelimiter("\\A");
            try {
                Assertions.assertTrue((boolean)s.hasNext());
                String string = s.next();
                if (s != null) {
                    s.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }
}

