/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.utils.TestDirectory;

@DbmsExtension
class DbmsExtensionInjectionTest {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DatabaseManagementService dbms;
    @Inject
    private GraphDatabaseService db;
    @Inject
    private GraphDatabaseAPI dbApi;
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private DatabaseLayout databaseLayout;

    DbmsExtensionInjectionTest() {
    }

    @Test
    void shouldInject() {
        Assertions.assertNotNull((Object)this.fs);
        Assertions.assertNotNull((Object)this.testDirectory);
        Assertions.assertNotNull((Object)this.dbms);
        Assertions.assertNotNull((Object)this.db);
        Assertions.assertNotNull((Object)this.dbApi);
        Assertions.assertNotNull((Object)this.neo4jLayout);
        Assertions.assertNotNull((Object)this.databaseLayout);
        Assertions.assertEquals((Object)this.testDirectory.getFileSystem(), (Object)this.fs);
        Assertions.assertInstanceOf(DefaultFileSystemAbstraction.class, (Object)this.fs);
        Assertions.assertSame((Object)this.db, (Object)this.dbApi);
        Assertions.assertEquals((Object)this.testDirectory.homePath(), (Object)this.neo4jLayout.homeDirectory());
        Assertions.assertEquals((Object)this.db.databaseName(), (Object)this.databaseLayout.getDatabaseName());
        Assertions.assertEquals((Object)this.databaseLayout.getNeo4jLayout(), (Object)this.neo4jLayout);
    }

    @Nested
    class NestedTest {
        NestedTest() {
        }

        @Test
        void injectedFieldsShouldBeAvailableForNestedTests() {
            DbmsExtensionInjectionTest.this.shouldInject();
        }
    }
}

