/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.AdminTool;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.io.fs.FileSystemAbstraction;
import picocli.CommandLine;

public class CommandTestUtils {
    public static CapturingExecutionContext withSuppressedOutput(Path homeDir, Path confDir, FileSystemAbstraction fs, ThrowingConsumer<CapturingExecutionContext, Throwable> command) {
        CapturingExecutionContext executionContext = CommandTestUtils.capturingExecutionContext(homeDir, confDir, fs);
        try {
            command.accept((Object)executionContext);
            return executionContext;
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("%nCaptured System.out:%n%s%nCaptured System.err:%n%s", executionContext.outAsString(), executionContext.errAsString()), e);
        }
    }

    public static CapturingExecutionContext runCommandWithSuppressedOutput(Path homeDir, Path confDir, FileSystemAbstraction fs, Function<ExecutionContext, AbstractCommand> command, String ... args) {
        return CommandTestUtils.withSuppressedOutput(homeDir, confDir, fs, (ThrowingConsumer<CapturingExecutionContext, Throwable>)((ThrowingConsumer)ctx -> {
            AbstractCommand cmd = (AbstractCommand)command.apply((ExecutionContext)ctx);
            CommandLine.populateCommand((Object)cmd, (String[])args);
            cmd.execute();
        }));
    }

    public static CapturingExecutionContext callWithSuppressedOutput(ExecutionContext ctx, TestCallable callable) {
        CapturingExecutionContext executionContext = CommandTestUtils.capturingExecutionContext(ctx.homeDir(), ctx.confDir(), ctx.fs());
        try {
            callable.call(executionContext);
            return executionContext;
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("%nCaptured System.out:%n%s%nCaptured System.err:%n%s", executionContext.outAsString(), executionContext.errAsString()), e);
        }
    }

    public static CapturingExecutionContext runAdminToolWithSuppressedOutput(Path homeDir, Path confDir, FileSystemAbstraction fs, String ... args) {
        return CommandTestUtils.withSuppressedOutput(homeDir, confDir, fs, (ThrowingConsumer<CapturingExecutionContext, Throwable>)((ThrowingConsumer)ctx -> AdminTool.execute((ExecutionContext)ctx, (String[])args)));
    }

    public static CapturingExecutionContext capturingExecutionContext(Path homeDir, Path confDir, FileSystemAbstraction fs) {
        ByteArrayOutputStream rawOut = new ByteArrayOutputStream();
        ByteArrayOutputStream rawErr = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(rawOut);
        PrintStream err = new PrintStream(rawErr);
        return new CapturingExecutionContext(homeDir, confDir, rawOut, rawErr, out, err, fs);
    }

    public static Path latestFileInDirectory(FileSystemAbstraction fs, Path path) throws IOException {
        List<Path> list = CommandTestUtils.filesByTime(fs, path);
        if (list.isEmpty()) {
            return null;
        }
        return list.getLast();
    }

    public static String escapedPath(String path) throws URISyntaxException {
        return new URI(null, null, path, null).getRawPath();
    }

    public static long containCount(Stream<String> lines, String substring) {
        return lines.filter(s -> s.contains(substring)).count();
    }

    private static List<Path> filesByTime(FileSystemAbstraction fs, Path path) throws IOException {
        List<Path> files = Arrays.asList(fs.listFiles(path));
        files.sort((o1, o2) -> {
            try {
                return (int)(fs.lastModifiedTime(o1) - fs.lastModifiedTime(o2));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return files;
    }

    public static class CapturingExecutionContext
    extends ExecutionContext {
        private final ByteArrayOutputStream rawOut;
        private final ByteArrayOutputStream rawErr;

        CapturingExecutionContext(Path homePath, Path confPath, ByteArrayOutputStream rawOut, ByteArrayOutputStream rawErr, PrintStream out, PrintStream err, FileSystemAbstraction fs) {
            super(homePath, confPath, out, err, fs);
            this.rawOut = rawOut;
            this.rawErr = rawErr;
        }

        public String outAsString() {
            this.out().flush();
            return this.rawOut.toString();
        }

        public String errAsString() {
            this.err().flush();
            return this.rawErr.toString();
        }
    }

    @FunctionalInterface
    public static interface TestCallable {
        public void call(CapturingExecutionContext var1) throws Exception;
    }
}

