/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.integration;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.time.Clock;
import java.util.HashMap;
import java.util.LinkedList;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.BoltStateMachineFactoryImpl;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.BasicAuthentication;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.udc.UsageData;

public class SessionRule
implements TestRule {
    private GraphDatabaseAPI gdb;
    private BoltStateMachineFactoryImpl boltFactory;
    private LinkedList<BoltStateMachine> runningMachines = new LinkedList();
    private boolean authEnabled;

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                HashMap config = new HashMap();
                config.put(GraphDatabaseSettings.auth_enabled, Boolean.toString(SessionRule.this.authEnabled));
                SessionRule.this.gdb = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase(config);
                DependencyResolver resolver = SessionRule.this.gdb.getDependencyResolver();
                DatabaseManager databaseManager = (DatabaseManager)resolver.resolveDependency(DatabaseManager.class);
                Authentication authentication = SessionRule.authentication((AuthManager)resolver.resolveDependency(AuthManager.class), (UserManagerSupplier)resolver.resolveDependency(UserManagerSupplier.class));
                SessionRule.this.boltFactory = new BoltStateMachineFactoryImpl(databaseManager, new UsageData(null), (AvailabilityGuard)resolver.resolveDependency(AvailabilityGuard.class), authentication, Clock.systemUTC(), Config.defaults(), (LogService)NullLogService.getInstance());
                try {
                    base.evaluate();
                }
                finally {
                    try {
                        if (SessionRule.this.runningMachines != null) {
                            SessionRule.this.runningMachines.forEach(BoltStateMachine::close);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    SessionRule.this.gdb.shutdown();
                }
            }
        };
    }

    private static Authentication authentication(AuthManager authManager, UserManagerSupplier userManagerSupplier) {
        return new BasicAuthentication(authManager, userManagerSupplier);
    }

    BoltStateMachine newMachine(BoltChannel boltChannel) {
        return this.newMachine(1L, boltChannel);
    }

    public BoltStateMachine newMachine(long version, BoltChannel boltChannel) {
        if (this.boltFactory == null) {
            throw new IllegalStateException("Cannot access test environment before test is running.");
        }
        BoltStateMachine machine = this.boltFactory.newStateMachine(version, boltChannel);
        this.runningMachines.add(machine);
        return machine;
    }

    SessionRule withAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
        return this;
    }

    public URL putTmpFile(String prefix, String suffix, String contents) throws IOException {
        File tmpFile = File.createTempFile(prefix, suffix, null);
        tmpFile.deleteOnExit();
        try (PrintWriter out = new PrintWriter(tmpFile);){
            out.println(contents);
        }
        return tmpFile.toURI().toURL();
    }

    public GraphDatabaseAPI graph() {
        return this.gdb;
    }

    public long lastClosedTxId() {
        return ((TransactionIdStore)this.gdb.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
    }
}

