/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.platform.commons.support.AnnotationSupport;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectorySupportExtension;
import org.neo4j.test.rule.TestDirectory;

public class DbmsSupportExtension
implements AfterEachCallback,
BeforeEachCallback {
    protected static final String DBMS = "service";
    private static final ExtensionContext.Namespace DBMS_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"org", "neo4j", "dbms"});

    public void beforeEach(ExtensionContext context) {
        TestInstances testInstances = context.getRequiredTestInstances();
        TestDirectory testDir = this.getTestDirectory(context);
        TestConfiguration configuration = DbmsSupportExtension.getConfigurationFromAnnotations(context);
        TestDatabaseManagementServiceBuilder builder = new TestDatabaseManagementServiceBuilder(testDir.homeDir()).setFileSystem(testDir.getFileSystem());
        for (Object testInstance : testInstances.getAllInstances()) {
            DbmsSupportExtension.maybeInvokeCallback(testInstance, builder, configuration.configurationCallback);
        }
        DatabaseManagementService dbms = builder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)dbms.database(configuration.injectableDatabase);
        ExtensionContext.Store store = DbmsSupportExtension.getStore(context);
        store.put((Object)DBMS, (Object)dbms);
        for (Object testInstance : testInstances.getAllInstances()) {
            DbmsSupportExtension.injectInstance(testInstance, dbms, DatabaseManagementService.class);
            DbmsSupportExtension.injectInstance(testInstance, db, GraphDatabaseService.class);
            DbmsSupportExtension.injectInstance(testInstance, db, GraphDatabaseAPI.class);
        }
    }

    public void afterEach(ExtensionContext context) {
        DatabaseManagementService dbms = (DatabaseManagementService)DbmsSupportExtension.getStore(context).remove((Object)DBMS, DatabaseManagementService.class);
        dbms.shutdown();
    }

    protected static <T> void injectInstance(Object testInstance, T instance, Class<T> clazz) {
        Class<?> testClass = testInstance.getClass();
        do {
            Arrays.stream(testClass.getDeclaredFields()).filter(field -> AnnotationSupport.isAnnotated((AnnotatedElement)field, Inject.class)).filter(field -> field.getType() == clazz).forEach(field -> DbmsSupportExtension.setField(testInstance, field, instance));
        } while ((testClass = testClass.getSuperclass()) != null);
    }

    private static void setField(Object testInstance, Field field, Object db) {
        field.setAccessible(true);
        try {
            field.set(testInstance, db);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected TestDirectory getTestDirectory(ExtensionContext context) {
        TestDirectory testDir = (TestDirectory)context.getStore(TestDirectorySupportExtension.TEST_DIRECTORY_NAMESPACE).get((Object)"testDirectory", TestDirectory.class);
        if (testDir == null) {
            throw new IllegalStateException(TestDirectorySupportExtension.class.getSimpleName() + " not in scope, make sure to add it before the " + this.getClass().getSimpleName());
        }
        return testDir;
    }

    protected static void maybeInvokeCallback(Object testInstance, TestDatabaseManagementServiceBuilder builder, String callback) {
        if (callback == null || callback.isEmpty()) {
            return;
        }
        for (Method method : DbmsSupportExtension.getAllMethods(testInstance.getClass())) {
            if (!method.getName().equals(callback)) continue;
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalArgumentException("The method '" + callback + "', must return void.");
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(TestDatabaseManagementServiceBuilder.class)) {
                throw new IllegalArgumentException("The method '" + callback + "', must take one parameter that is assignable from " + TestDatabaseManagementServiceBuilder.class.getSimpleName() + ".");
            }
            if (method.getAnnotation(ExtensionCallback.class) == null) {
                throw new IllegalArgumentException("The method '" + callback + "', must be annotated with " + ExtensionCallback.class.getSimpleName() + ".");
            }
            method.setAccessible(true);
            try {
                method.invoke(testInstance, new Object[]{builder});
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The method '" + callback + "' is not accessible.", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("The method '" + callback + "' threw an exception.", e);
            }
            return;
        }
        throw new IllegalArgumentException("The method with name '" + callback + "' can not be found.");
    }

    private static Iterable<? extends Method> getAllMethods(Class clazz) {
        ArrayList methods = new ArrayList();
        Collections.addAll(methods, clazz.getDeclaredMethods());
        List classes = ClassUtils.getAllSuperclasses((Class)clazz);
        for (Class aClass : classes) {
            Collections.addAll(methods, aClass.getDeclaredMethods());
        }
        return methods;
    }

    protected static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(DBMS_NAMESPACE);
    }

    private static TestConfiguration getConfigurationFromAnnotations(ExtensionContext context) {
        Class testClass;
        ArrayList<DbmsExtension> dbmsExtensions = new ArrayList<DbmsExtension>();
        ArrayList<ImpermanentDbmsExtension> impermanentDbmsExtensions = new ArrayList<ImpermanentDbmsExtension>();
        Method requiredTestMethod = context.getRequiredTestMethod();
        DbmsExtension dbmsExtension = requiredTestMethod.getAnnotation(DbmsExtension.class);
        ImpermanentDbmsExtension impermanentDbmsExtension = requiredTestMethod.getAnnotation(ImpermanentDbmsExtension.class);
        if (dbmsExtension != null) {
            dbmsExtensions.add(dbmsExtension);
        }
        if (impermanentDbmsExtension != null) {
            impermanentDbmsExtensions.add(impermanentDbmsExtension);
        }
        if ((dbmsExtension = (testClass = context.getRequiredTestClass()).getAnnotation(DbmsExtension.class)) != null) {
            dbmsExtensions.add(dbmsExtension);
        }
        if ((impermanentDbmsExtension = testClass.getAnnotation(ImpermanentDbmsExtension.class)) != null) {
            impermanentDbmsExtensions.add(impermanentDbmsExtension);
        }
        if (!dbmsExtensions.isEmpty() && !impermanentDbmsExtensions.isEmpty()) {
            throw new IllegalArgumentException(String.format("Mix of %s and %s found, this is not supported", DbmsExtension.class.getSimpleName(), ImpermanentDbmsExtension.class.getSimpleName()));
        }
        if (!dbmsExtensions.isEmpty()) {
            dbmsExtension = (DbmsExtension)dbmsExtensions.get(0);
            return new TestConfiguration(dbmsExtension.injectableDatabase(), dbmsExtension.configurationCallback());
        }
        if (!impermanentDbmsExtensions.isEmpty()) {
            impermanentDbmsExtension = (ImpermanentDbmsExtension)impermanentDbmsExtensions.get(0);
            return new TestConfiguration(impermanentDbmsExtension.injectableDatabase(), impermanentDbmsExtension.configurationCallback());
        }
        return new TestConfiguration("neo4j", null);
    }

    private static class TestConfiguration {
        private final String injectableDatabase;
        private final String configurationCallback;

        private TestConfiguration(String injectableDatabase, String configurationCallback) {
            this.injectableDatabase = injectableDatabase;
            this.configurationCallback = configurationCallback;
        }
    }
}

