/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.snapshot;

import java.io.PrintStream;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.function.Predicates;
import org.neo4j.kernel.impl.context.TransactionVersionContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.TransactionIdStore;

public class TestVersionContext
extends TransactionVersionContext {
    private boolean wrongLastClosedTxId = true;
    private int additionalAttempts;
    private boolean stayDirty;
    private Exception lastMarkAsDirtyCall;
    private Exception additionalAttemptsCall;
    private volatile Predicate<Thread> threadFilter = Predicates.alwaysTrue();

    private TestVersionContext(LongSupplier transactionIdSupplier) {
        super(transactionIdSupplier);
    }

    public long lastClosedTransactionId() {
        return this.wrongLastClosedTxId ? 1L : super.lastClosedTransactionId();
    }

    public void markAsDirty() {
        if (!this.threadFilter.test(Thread.currentThread())) {
            return;
        }
        super.markAsDirty();
        if (!this.stayDirty) {
            this.wrongLastClosedTxId = false;
        }
        this.lastMarkAsDirtyCall = new Exception("markAsDirty");
    }

    public boolean isDirty() {
        boolean dirty = super.isDirty();
        if (dirty) {
            ++this.additionalAttempts;
            this.additionalAttemptsCall = new Exception("isDirty");
        }
        return dirty;
    }

    public void printDirtyCalls(PrintStream printStream) {
        if (this.lastMarkAsDirtyCall != null) {
            this.lastMarkAsDirtyCall.printStackTrace(printStream);
        } else {
            printStream.println("No last markAsDirty call");
        }
        if (this.additionalAttemptsCall != null) {
            this.additionalAttemptsCall.printStackTrace(printStream);
        } else {
            printStream.println("No additionalAttempts call");
        }
    }

    public int getAdditionalAttempts() {
        return this.additionalAttempts;
    }

    public void setWrongLastClosedTxId(boolean wrongLastClosedTxId) {
        this.wrongLastClosedTxId = wrongLastClosedTxId;
    }

    public void stayDirty(boolean stayDirty) {
        this.stayDirty = stayDirty;
    }

    public void onlyCareAboutCurrentThread() {
        Thread threadToFilterOn = Thread.currentThread();
        this.threadFilter = t -> t.equals(threadToFilterOn);
    }

    public static TestVersionContext testCursorContext(DatabaseManagementService managementService, String databaseName) {
        TransactionIdStore transactionIdStore = TestVersionContext.getTransactionIdStore(managementService, databaseName);
        return new TestVersionContext(() -> ((TransactionIdStore)transactionIdStore).getLastClosedTransactionId());
    }

    private static TransactionIdStore getTransactionIdStore(DatabaseManagementService managementService, String databaseName) {
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)managementService.database(databaseName)).getDependencyResolver();
        return (TransactionIdStore)dependencyResolver.resolveDependency(TransactionIdStore.class);
    }
}

