/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocolVersion;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.dbapi.impl.BoltKernelDatabaseManagementServiceProvider;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.runtime.statemachine.impl.BoltStateMachineFactoryImpl;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.BasicAuthentication;
import org.neo4j.bolt.txtracking.DefaultReconciledTransactionTracker;
import org.neo4j.bolt.txtracking.ReconciledTransactionTracker;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public class SessionExtension
implements BeforeEachCallback,
AfterEachCallback {
    private final Supplier<TestDatabaseManagementServiceBuilder> builderFactory;
    private GraphDatabaseAPI gdb;
    private BoltStateMachineFactoryImpl boltFactory;
    private List<BoltStateMachine> runningMachines = new ArrayList<BoltStateMachine>();
    private DatabaseManagementService managementService;
    private boolean authEnabled;

    public SessionExtension() {
        this(TestDatabaseManagementServiceBuilder::new);
    }

    public SessionExtension(Supplier<TestDatabaseManagementServiceBuilder> builderFactory) {
        this.builderFactory = builderFactory;
    }

    public BoltStateMachine newMachine(BoltProtocolVersion version, BoltChannel boltChannel) {
        this.assertTestStarted();
        BoltStateMachine machine = this.boltFactory.newStateMachine(version, boltChannel);
        this.runningMachines.add(machine);
        return machine;
    }

    public DatabaseManagementService managementService() {
        this.assertTestStarted();
        return this.managementService;
    }

    public String defaultDatabaseName() {
        this.assertTestStarted();
        DependencyResolver resolver = this.gdb.getDependencyResolver();
        Config config = (Config)resolver.resolveDependency(Config.class);
        return (String)config.get(GraphDatabaseSettings.default_database);
    }

    public DatabaseIdRepository databaseIdRepository() {
        this.assertTestStarted();
        DependencyResolver resolver = this.gdb.getDependencyResolver();
        DatabaseManager databaseManager = (DatabaseManager)resolver.resolveDependency(DatabaseManager.class);
        return databaseManager.databaseIdRepository();
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.managementService = this.builderFactory.get().impermanent().setConfig(GraphDatabaseSettings.auth_enabled, (Object)this.authEnabled).build();
        this.gdb = (GraphDatabaseAPI)this.managementService.database("neo4j");
        DependencyResolver resolver = this.gdb.getDependencyResolver();
        Authentication authentication = SessionExtension.authentication((AuthManager)resolver.resolveDependency(AuthManager.class));
        Config config = (Config)resolver.resolveDependency(Config.class);
        SystemNanoClock clock = Clocks.nanoClock();
        DefaultReconciledTransactionTracker reconciledTxTracker = new DefaultReconciledTransactionTracker((LogService)NullLogService.getInstance());
        BoltKernelDatabaseManagementServiceProvider databaseManagementService = new BoltKernelDatabaseManagementServiceProvider(this.managementService, (ReconciledTransactionTracker)reconciledTxTracker, new Monitors(), clock, Duration.ofSeconds(30L));
        this.boltFactory = new BoltStateMachineFactoryImpl((BoltGraphDatabaseManagementServiceSPI)databaseManagementService, authentication, clock, config, (LogService)NullLogService.getInstance());
    }

    public void afterEach(ExtensionContext extensionContext) {
        try {
            if (this.runningMachines != null) {
                IOUtils.closeAll(this.runningMachines);
                this.runningMachines.clear();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.managementService.shutdown();
    }

    private void assertTestStarted() {
        if (this.boltFactory == null || this.gdb == null) {
            throw new IllegalStateException("Cannot access test environment before test is running.");
        }
    }

    private static Authentication authentication(AuthManager authManager) {
        return new BasicAuthentication(authManager);
    }

    public long lastClosedTxId() {
        return ((TransactionIdStore)this.gdb.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
    }

    public URL putTmpFile(String prefix, String suffix, String contents) throws IOException {
        File tmpFile = File.createTempFile(prefix, suffix, null);
        tmpFile.deleteOnExit();
        try (PrintWriter out = new PrintWriter(tmpFile, StandardCharsets.UTF_8);){
            out.println(contents);
        }
        return tmpFile.toURI().toURL();
    }

    public SessionExtension withAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
        return this;
    }
}

