/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.rule.TestDirectory;

@DbmsExtension
class DbmsExtensionInjectionTest {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DatabaseManagementService dbms;
    @Inject
    private GraphDatabaseService db;
    @Inject
    private GraphDatabaseAPI dbApi;

    DbmsExtensionInjectionTest() {
    }

    @Test
    void shouldInject() {
        Assertions.assertNotNull((Object)this.fs);
        Assertions.assertNotNull((Object)this.testDirectory);
        Assertions.assertNotNull((Object)this.dbms);
        Assertions.assertNotNull((Object)this.db);
        Assertions.assertNotNull((Object)this.dbApi);
        Assertions.assertEquals((Object)this.testDirectory.getFileSystem(), (Object)this.fs);
        Assertions.assertTrue((boolean)(this.fs instanceof DefaultFileSystemAbstraction));
        Assertions.assertSame((Object)this.db, (Object)this.dbApi);
    }

    @Nested
    class NestedTest {
        NestedTest() {
        }

        @Test
        void injectedFieldsShouldBeAvailableForNestedTests() {
            DbmsExtensionInjectionTest.this.shouldInject();
        }
    }
}

