/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class TestImpermanentGraphDatabase {
    private GraphDatabaseService db;
    private DatabaseManagementService managementService;

    TestImpermanentGraphDatabase() {
    }

    @BeforeEach
    void createDb() {
        this.managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        this.db = this.managementService.database("neo4j");
    }

    @AfterEach
    void tearDown() {
        this.managementService.shutdown();
    }

    @Test
    void shouldKeepDataBetweenStartAndShutdown() {
        this.createNode();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)this.nodeCount(), (String)"Expected one new node");
    }

    @Test
    void dataShouldNotSurviveShutdown() {
        this.createNode();
        this.managementService.shutdown();
        this.createDb();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.nodeCount(), (String)"Should not see anything.");
    }

    @Test
    void shouldRemoveAllData() {
        try (Transaction tx = this.db.beginTx();){
            RelationshipType relationshipType = RelationshipType.withName((String)"R");
            Node n1 = tx.createNode();
            Node n2 = tx.createNode();
            Node n3 = tx.createNode();
            n1.createRelationshipTo(n2, relationshipType);
            n2.createRelationshipTo(n1, relationshipType);
            n3.createRelationshipTo(n1, relationshipType);
            tx.commit();
        }
        TestImpermanentGraphDatabase.cleanDatabaseContent(this.db);
        Assertions.assertThat((long)this.nodeCount()).isZero();
    }

    private static void cleanDatabaseContent(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.getAllRelationships().forEach(Relationship::delete);
            tx.getAllNodes().forEach(Node::delete);
            tx.commit();
        }
    }

    private long nodeCount() {
        try (Transaction transaction = this.db.beginTx();){
            long l = Iterables.count((Iterable)transaction.getAllNodes());
            return l;
        }
    }

    private void createNode() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            tx.commit();
        }
    }
}

