/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configureGlobal")
class DbmsExtensionConfigurationTest {
    @Inject
    private DatabaseManagementService dbms;

    DbmsExtensionConfigurationTest() {
    }

    @ExtensionCallback
    static void configureGlobal(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.default_database, (Object)"global");
    }

    @ExtensionCallback
    static void configureLocal(DatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.default_database, (Object)"local");
    }

    @Test
    void globalConfig() {
        this.dbms.database("global");
    }

    @Test
    @DbmsExtension(configurationCallback="configureLocal")
    void localConfig() {
        this.dbms.database("local");
    }

    @Test
    @DbmsExtension
    void defaultConfig() {
        this.dbms.database("neo4j");
    }
}

