/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.testkit.engine.EngineTestKit;
import org.junit.platform.testkit.engine.EventConditions;
import org.junit.platform.testkit.engine.Events;
import org.junit.platform.testkit.engine.TestExecutionResultConditions;
import org.neo4j.test.extension.dbms.DbmsExtensionCheckCallbackSignature;
import org.neo4j.test.extension.dbms.DbmsExtensionEnforceAnnotations;
import org.neo4j.test.extension.dbms.DbmsExtensionMixImpermanent;

class DbmsExtensionTest {
    DbmsExtensionTest() {
    }

    @Test
    void enforceAnnotation() {
        Events testEvents = EngineTestKit.engine((String)"junit-jupiter").selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(DbmsExtensionEnforceAnnotations.class)}).execute().testEvents();
        testEvents.assertThatEvents().haveExactly(1, EventConditions.event((Condition[])new Condition[]{EventConditions.finishedWithFailure((Condition[])new Condition[]{TestExecutionResultConditions.instanceOf(IllegalArgumentException.class), TestExecutionResultConditions.message(message -> message.contains("must be annotated"))})}));
    }

    @Test
    void checkCallbackSignature() {
        Events testEvents = EngineTestKit.engine((String)"junit-jupiter").selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(DbmsExtensionCheckCallbackSignature.class)}).execute().testEvents();
        testEvents.assertThatEvents().haveExactly(1, EventConditions.event((Condition[])new Condition[]{EventConditions.finishedWithFailure((Condition[])new Condition[]{TestExecutionResultConditions.instanceOf(IllegalArgumentException.class), TestExecutionResultConditions.message(message -> message.contains("must return void"))})}));
        testEvents.assertThatEvents().haveExactly(1, EventConditions.event((Condition[])new Condition[]{EventConditions.finishedWithFailure((Condition[])new Condition[]{TestExecutionResultConditions.instanceOf(IllegalArgumentException.class), TestExecutionResultConditions.message(message -> message.contains("must take one parameter that is assignable from"))})}));
        testEvents.assertThatEvents().haveExactly(1, EventConditions.event((Condition[])new Condition[]{EventConditions.finishedWithFailure((Condition[])new Condition[]{TestExecutionResultConditions.instanceOf(IllegalArgumentException.class), TestExecutionResultConditions.message(message -> message.contains("cannot be found."))})}));
    }

    @Test
    void mixImpermanent() {
        Events testEvents = EngineTestKit.engine((String)"junit-jupiter").selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(DbmsExtensionMixImpermanent.class)}).execute().testEvents();
        testEvents.assertThatEvents().haveExactly(1, EventConditions.event((Condition[])new Condition[]{EventConditions.finishedWithFailure((Condition[])new Condition[]{TestExecutionResultConditions.instanceOf(ExtensionContextException.class)})}));
    }
}

