/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilderImplementation;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.database.NoOpSystemGraphInitializer;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.procedure.LazyProcedures;
import org.neo4j.test.TestDatabaseManagementServiceFactory;
import org.neo4j.test.TestNeo4jDatabaseManagementServiceBuilder;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.util.Preconditions;

public class TestDatabaseManagementServiceBuilder
extends DatabaseManagementServiceBuilderImplementation
implements TestNeo4jDatabaseManagementServiceBuilder {
    private static final Path EPHEMERAL_PATH = Path.of("/target/test data/neo4j", new String[0]);
    protected FileSystemAbstraction fileSystem;
    protected InternalLogProvider internalLogProvider;
    protected SystemNanoClock clock;
    protected Config fromConfig;
    protected boolean noOpSystemGraphInitializer;
    private boolean lazyProcedures = true;

    public TestDatabaseManagementServiceBuilder() {
        super(null);
    }

    public TestDatabaseManagementServiceBuilder(Path homeDirectory) {
        super(homeDirectory);
    }

    public TestDatabaseManagementServiceBuilder(Neo4jLayout layout) {
        super(layout.homeDirectory());
        this.setConfig(GraphDatabaseInternalSettings.databases_root_path, layout.databasesDirectory());
        this.setConfig(GraphDatabaseSettings.transaction_logs_root_path, layout.transactionLogsRootDirectory());
        this.setConfig(BoltConnector.thread_pool_max_size, (Object)2000);
    }

    public TestDatabaseManagementServiceBuilder(DatabaseLayout layout) {
        this(layout.getNeo4jLayout());
        this.setConfig(GraphDatabaseSettings.initial_default_database, layout.getDatabaseName());
    }

    public DatabaseManagementService build() {
        return this.build0();
    }

    protected DatabaseManagementService build0() {
        Object object = this.fileSystem = this.fileSystem != null ? this.fileSystem : new DefaultFileSystemAbstraction();
        if (this.homeDirectory == null) {
            if (this.fileSystem.isPersistent()) {
                throw new RuntimeException("You have to specify a home directory or use an impermanent filesystem.");
            }
            this.homeDirectory = EPHEMERAL_PATH;
        }
        Config cfg = this.config.set(GraphDatabaseSettings.neo4j_home, (Object)this.homeDirectory.toAbsolutePath()).fromConfig(this.fromConfig).build();
        DependencyResolver originalDependencies = this.dependencies;
        if (this.noOpSystemGraphInitializer) {
            this.dependencies = NoOpSystemGraphInitializer.noOpSystemGraphInitializer(this.dependencies, cfg);
        }
        if (this.lazyProcedures) {
            Dependencies dependencyWrapper = new Dependencies(this.dependencies);
            dependencyWrapper.satisfyDependency((Object)new LazyProcedures());
            this.dependencies = dependencyWrapper;
        }
        DatabaseManagementService dbms = this.newDatabaseManagementService(cfg, this.databaseDependencies());
        this.dependencies = originalDependencies;
        return dbms;
    }

    protected DatabaseManagementService newDatabaseManagementService(Config config, ExternalDependencies dependencies) {
        TestDatabaseManagementServiceFactory factory = new TestDatabaseManagementServiceFactory(this.getDbmsInfo(config), this.getEditionFactory(config), this.fileSystem, this.clock, this.internalLogProvider);
        return factory.build(this.augmentConfig(config), (ExternalDependencies)GraphDatabaseDependencies.newDependencies((ExternalDependencies)dependencies));
    }

    protected Config augmentConfig(Config config) {
        Config.Builder builder = Config.newBuilder().fromConfig(config).setDefault(GraphDatabaseSettings.pagecache_memory, (Object)ByteUnit.mebiBytes((long)8L)).setDefault(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.kibiBytes((long)128L)).setDefault(BoltConnector.enabled, (Object)Boolean.FALSE).setDefault(GraphDatabaseInternalSettings.dump_diagnostics, (Object)false).setDefault(GraphDatabaseInternalSettings.track_tx_statement_close, (Object)true).setDefault(GraphDatabaseInternalSettings.trace_tx_statements, (Object)true).setDefault(GraphDatabaseInternalSettings.track_cursor_close, (Object)true).setDefault(GraphDatabaseInternalSettings.netty_server_shutdown_quiet_period, (Object)0).setDefault(GraphDatabaseInternalSettings.netty_server_shutdown_timeout, (Object)Duration.ofSeconds(3L)).setDefault(GraphDatabaseInternalSettings.additional_lock_verification, (Object)true).setDefault(GraphDatabaseInternalSettings.lock_manager_verbose_deadlocks, (Object)true).setDefault(GraphDatabaseInternalSettings.vm_pause_monitor_enabled, (Object)false).setDefault(GraphDatabaseSettings.check_point_iops_limit, (Object)-1);
        return builder.build();
    }

    public Path getHomeDirectory() {
        return this.homeDirectory;
    }

    @Override
    public TestDatabaseManagementServiceBuilder setFileSystem(FileSystemAbstraction fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public TestDatabaseManagementServiceBuilder setDatabaseRootDirectory(Path storeDir) {
        this.homeDirectory = storeDir;
        return this;
    }

    public TestDatabaseManagementServiceBuilder setInternalLogProvider(InternalLogProvider internalLogProvider) {
        this.internalLogProvider = internalLogProvider;
        return this;
    }

    public TestDatabaseManagementServiceBuilder setClock(SystemNanoClock clock) {
        this.clock = clock;
        return this;
    }

    private TestDatabaseManagementServiceBuilder addExtensions(Iterable<ExtensionFactory<?>> extensions) {
        for (ExtensionFactory<?> extension : extensions) {
            this.extensions.add(extension);
        }
        return this;
    }

    public TestDatabaseManagementServiceBuilder addExtension(ExtensionFactory<?> extension) {
        return this.addExtensions(Collections.singletonList(extension));
    }

    public TestDatabaseManagementServiceBuilder setExtensions(Iterable<ExtensionFactory<?>> newExtensions) {
        this.extensions.clear();
        this.addExtensions(newExtensions);
        return this;
    }

    public TestDatabaseManagementServiceBuilder removeExtensions(Predicate<ExtensionFactory<?>> toRemove) {
        this.extensions.removeIf(toRemove);
        return this;
    }

    public TestDatabaseManagementServiceBuilder impermanent() {
        Preconditions.checkState((this.fileSystem == null ? 1 : 0) != 0, (String)"Filesystem is already assigned, can't update it.");
        this.fileSystem = new EphemeralFileSystemAbstraction();
        return this;
    }

    public TestDatabaseManagementServiceBuilder setConfig(Config fromConfig) {
        if (this.fromConfig != null) {
            throw new IllegalStateException("You can only set config once.");
        }
        this.fromConfig = fromConfig;
        return this;
    }

    public TestDatabaseManagementServiceBuilder setConfigRaw(Map<String, String> raw) {
        this.config.setRaw(raw);
        return this;
    }

    public TestDatabaseManagementServiceBuilder useLazyProcedures(boolean useLazyProcedures) {
        this.lazyProcedures = useLazyProcedures;
        return this;
    }

    public TestDatabaseManagementServiceBuilder noOpSystemGraphInitializer() {
        this.noOpSystemGraphInitializer = true;
        return this;
    }

    public TestDatabaseManagementServiceBuilder setExternalDependencies(DependencyResolver dependencies) {
        return (TestDatabaseManagementServiceBuilder)super.setExternalDependencies(dependencies);
    }

    public TestDatabaseManagementServiceBuilder setMonitors(Monitors monitors) {
        return (TestDatabaseManagementServiceBuilder)super.setMonitors(monitors);
    }

    public TestDatabaseManagementServiceBuilder setUserLogProvider(LogProvider logProvider) {
        return (TestDatabaseManagementServiceBuilder)super.setUserLogProvider(logProvider);
    }

    public TestDatabaseManagementServiceBuilder addURLAccessRule(String protocol, URLAccessRule rule) {
        return (TestDatabaseManagementServiceBuilder)super.addURLAccessRule(protocol, rule);
    }

    public <T> TestDatabaseManagementServiceBuilder setConfig(Setting<T> setting, T value) {
        return (TestDatabaseManagementServiceBuilder)super.setConfig(setting, value);
    }

    public TestDatabaseManagementServiceBuilder setConfig(Map<Setting<?>, Object> config) {
        return (TestDatabaseManagementServiceBuilder)super.setConfig(config);
    }

    public <T> TestDatabaseManagementServiceBuilder overrideDefaultSetting(Setting<T> setting, T value) {
        this.config.setDefault(setting, value);
        return this;
    }
}

