/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class TestDatabaseManagementServiceBuilderTest {
    @Inject
    private TestDirectory testDirectory;

    TestDatabaseManagementServiceBuilderTest() {
    }

    @Test
    void databaseStartsWithSystemAndDefaultDatabase() {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            TestDatabaseManagementServiceBuilderTest.checkAvailableDatabases(database);
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void impermanentDatabaseStartsWithSystemAndDefaultDatabase() {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).impermanent().build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            TestDatabaseManagementServiceBuilderTest.checkAvailableDatabases(database);
        }
        finally {
            managementService.shutdown();
        }
    }

    private static void checkAvailableDatabases(GraphDatabaseAPI database) {
        DependencyResolver resolver = database.getDependencyResolver();
        DatabaseContextProvider databaseContextProvider = (DatabaseContextProvider)resolver.resolveDependency(DatabaseContextProvider.class);
        Assertions.assertTrue((boolean)databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).isPresent());
        Assertions.assertTrue((boolean)databaseContextProvider.getDatabaseContext("neo4j").isPresent());
    }
}

