/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.dbapi.CustomBookmarkFormatParser;
import org.neo4j.bolt.dbapi.impl.BoltKernelDatabaseManagementServiceProvider;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.authentication.AuthenticationFlag;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.v40.BoltProtocolV40;
import org.neo4j.bolt.protocol.v40.bookmark.BookmarkParserV40;
import org.neo4j.bolt.protocol.v41.BoltProtocolV41;
import org.neo4j.bolt.protocol.v43.BoltProtocolV43;
import org.neo4j.bolt.protocol.v44.BoltProtocolV44;
import org.neo4j.bolt.security.Authentication;
import org.neo4j.bolt.security.AuthenticationResult;
import org.neo4j.bolt.security.basic.BasicAuthentication;
import org.neo4j.bolt.security.error.AuthenticationException;
import org.neo4j.bolt.transaction.StatementProcessorTxManager;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.kernel.impl.query.clientconnection.BoltConnectionInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.server.security.systemgraph.CommunityDefaultDatabaseResolver;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public class SessionExtension
implements BeforeEachCallback,
AfterEachCallback {
    private final Supplier<TestDatabaseManagementServiceBuilder> builderFactory;
    private GraphDatabaseAPI gdb;
    private BoltProtocolRegistry protocolRegistry;
    private DatabaseManagementService managementService;
    private Authentication authentication;
    private final List<StateMachine> runningMachines = new ArrayList<StateMachine>();
    private boolean authEnabled;

    public SessionExtension() {
        this(TestDatabaseManagementServiceBuilder::new);
    }

    public SessionExtension(Supplier<TestDatabaseManagementServiceBuilder> builderFactory) {
        this.builderFactory = builderFactory;
    }

    public StateMachine newMachine(ProtocolVersion version) {
        this.assertTestStarted();
        BoltProtocol protocol = (BoltProtocol)this.protocolRegistry.get(version).orElseThrow(() -> new IllegalArgumentException("Unsupported protocol version: " + version));
        Connection connection = this.createConnection();
        StateMachine stateMachine = protocol.createStateMachine(connection);
        this.runningMachines.add(stateMachine);
        return stateMachine;
    }

    private Connection createConnection() {
        Connection connection = (Connection)Mockito.mock(Connection.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)connection.id()).thenReturn((Object)"bolt-test");
        Mockito.when((Object)connection.selectedDefaultDatabase()).thenAnswer(invocation -> this.defaultDatabaseName());
        AtomicInteger interruptCounter = new AtomicInteger();
        ((Connection)Mockito.doAnswer(invocation -> {
            interruptCounter.incrementAndGet();
            return null;
        }).when((Object)connection)).interrupt();
        ((Connection)Mockito.doAnswer(invocation -> {
            int counter;
            do {
                if ((counter = interruptCounter.get()) != 0) continue;
                return true;
            } while (interruptCounter.compareAndSet(counter, counter - 1));
            return counter <= 1;
        }).when((Object)connection)).reset();
        Mockito.when((Object)connection.isInterrupted()).thenAnswer(invocation -> interruptCounter.get() != 0);
        AtomicReference loginContext = new AtomicReference();
        Mockito.when((Object)connection.loginContext()).thenAnswer(invocation -> loginContext.get());
        try {
            Mockito.when((Object)connection.authenticate((Map)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenAnswer(invocation -> {
                AuthenticationResult result = this.authentication.authenticate((Map)invocation.getArgument(0), (ClientConnectionInfo)new BoltConnectionInfo("bolt-test", "bolt-test", (SocketAddress)Mockito.mock(SocketAddress.class), (SocketAddress)Mockito.mock(SocketAddress.class)));
                loginContext.set(result.getLoginContext());
                if (result.credentialsExpired()) {
                    return AuthenticationFlag.CREDENTIALS_EXPIRED;
                }
                return null;
            });
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
        return connection;
    }

    public DatabaseManagementService managementService() {
        this.assertTestStarted();
        return this.managementService;
    }

    public String defaultDatabaseName() {
        this.assertTestStarted();
        DependencyResolver resolver = this.gdb.getDependencyResolver();
        Config config = (Config)resolver.resolveDependency(Config.class);
        return (String)config.get(GraphDatabaseSettings.initial_default_database);
    }

    public DatabaseIdRepository databaseIdRepository() {
        this.assertTestStarted();
        DependencyResolver resolver = this.gdb.getDependencyResolver();
        DatabaseContextProvider databaseManager = (DatabaseContextProvider)resolver.resolveDependency(DatabaseContextProvider.class);
        return databaseManager.databaseIdRepository();
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.managementService = this.builderFactory.get().impermanent().setConfig(GraphDatabaseSettings.auth_enabled, (Object)this.authEnabled).build();
        this.gdb = (GraphDatabaseAPI)this.managementService.database("neo4j");
        DependencyResolver resolver = this.gdb.getDependencyResolver();
        Config config = (Config)resolver.resolveDependency(Config.class);
        LogService logService = (LogService)resolver.resolveDependency(LogService.class);
        DatabaseContextProvider databaseContextProvider = (DatabaseContextProvider)resolver.resolveDependency(DatabaseContextProvider.class);
        SystemNanoClock clock = Clocks.nanoClock();
        StatementProcessorTxManager txManager = new StatementProcessorTxManager();
        CommunityDefaultDatabaseResolver defaultDatabaseResolver = new CommunityDefaultDatabaseResolver(config, () -> this.managementService.database("system"));
        BoltKernelDatabaseManagementServiceProvider databaseManagementService = new BoltKernelDatabaseManagementServiceProvider(this.managementService, new Monitors(), clock, Duration.ofSeconds(30L));
        BookmarkParserV40 bookmarksParser = new BookmarkParserV40(databaseContextProvider.databaseIdRepository(), CustomBookmarkFormatParser.DEFAULT);
        this.protocolRegistry = BoltProtocolRegistry.builder().register((BoltProtocol)new BoltProtocolV40(logService, (BoltGraphDatabaseManagementServiceSPI)databaseManagementService, (DefaultDatabaseResolver)defaultDatabaseResolver, (TransactionManager)txManager, clock)).register((BoltProtocol)new BoltProtocolV41(logService, (BoltGraphDatabaseManagementServiceSPI)databaseManagementService, (DefaultDatabaseResolver)defaultDatabaseResolver, (TransactionManager)txManager, clock)).register((BoltProtocol)new BoltProtocolV43(logService, (BoltGraphDatabaseManagementServiceSPI)databaseManagementService, (DefaultDatabaseResolver)defaultDatabaseResolver, (TransactionManager)txManager, clock)).register((BoltProtocol)new BoltProtocolV44(logService, (BoltGraphDatabaseManagementServiceSPI)databaseManagementService, (DefaultDatabaseResolver)defaultDatabaseResolver, (TransactionManager)txManager, clock)).build();
        AuthManager authManager = (AuthManager)resolver.resolveDependency(AuthManager.class);
        this.authentication = new BasicAuthentication(authManager);
    }

    public void afterEach(ExtensionContext extensionContext) {
        try {
            IOUtils.closeAll(this.runningMachines);
            this.runningMachines.clear();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.managementService.shutdown();
    }

    private void assertTestStarted() {
        if (this.protocolRegistry == null || this.gdb == null) {
            throw new IllegalStateException("Cannot access test environment before test is running.");
        }
    }

    private static Authentication authentication(AuthManager authManager) {
        return new BasicAuthentication(authManager);
    }

    public long lastClosedTxId() {
        return ((TransactionIdStore)this.gdb.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
    }

    public static URL putTmpFile(String prefix, String suffix, String contents) throws IOException {
        Path tempFile = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        try (PrintWriter out = new PrintWriter(Files.newOutputStream(tempFile, new OpenOption[0]), false, StandardCharsets.UTF_8);){
            out.println(contents);
        }
        return tempFile.toUri().toURL();
    }

    public SessionExtension withAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
        return this;
    }
}

