/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;

public final class RecoveryHelpers {
    private RecoveryHelpers() {
    }

    public static void removeLastCheckpointRecordFromLastLogFile(DatabaseLayout dbLayout, FileSystemAbstraction fs, Config config) throws IOException {
        LogFiles logFiles = RecoveryHelpers.buildLogFiles(dbLayout, fs, config);
        CheckpointFile checkpointFile = logFiles.getCheckpointFile();
        Optional latestCheckpoint = checkpointFile.findLatestCheckpoint();
        latestCheckpoint.ifPresent(checkpointInfo -> {
            LogPosition entryPosition = checkpointInfo.checkpointEntryPosition();
            try (StoreChannel storeChannel = fs.write(checkpointFile.getCurrentFile());){
                storeChannel.truncate(entryPosition.getByteOffset());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static void removeLastCheckpointRecordFromLastLogFile(DatabaseLayout dbLayout, FileSystemAbstraction fs) throws IOException {
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile(dbLayout, fs, null);
    }

    public static boolean logsContainCheckpoint(DatabaseLayout dbLayout, FileSystemAbstraction fs) throws IOException {
        Optional<CheckpointInfo> latestCheckpoint = RecoveryHelpers.getLatestCheckpointInfo(dbLayout, fs, null);
        return latestCheckpoint.isPresent();
    }

    public static CheckpointInfo getLatestCheckpoint(DatabaseLayout dbLayout, FileSystemAbstraction fs) throws IOException {
        return RecoveryHelpers.getLatestCheckpoint(dbLayout, fs, null);
    }

    public static CheckpointInfo getLatestCheckpoint(DatabaseLayout dbLayout, FileSystemAbstraction fs, Config config) throws IOException {
        Optional<CheckpointInfo> latestCheckpoint = RecoveryHelpers.getLatestCheckpointInfo(dbLayout, fs, config);
        return latestCheckpoint.orElseThrow();
    }

    private static Optional<CheckpointInfo> getLatestCheckpointInfo(DatabaseLayout dbLayout, FileSystemAbstraction fs, Config config) throws IOException {
        LogFiles logFiles = RecoveryHelpers.buildLogFiles(dbLayout, fs, config);
        CheckpointFile checkpointFile = logFiles.getCheckpointFile();
        return checkpointFile.findLatestCheckpoint();
    }

    private static LogFiles buildLogFiles(DatabaseLayout dbLayout, FileSystemAbstraction fs, Config config) throws IOException {
        return LogFilesBuilder.logFilesBasedOnlyBuilder((Path)dbLayout.getTransactionLogsDirectory(), (FileSystemAbstraction)fs).withConfig(config).build();
    }
}

