/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure;

import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.neo4j.collection.RawIterator;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregationReducer;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.values.AnyValue;

public class LazyProcedures
implements GlobalProcedures,
Consumer<Supplier<GlobalProcedures>> {
    private Supplier<GlobalProcedures> initializer;
    private volatile GlobalProcedures globalProcedures;
    private final LazyProcedureView lazyProcedureView = new LazyProcedureView();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.globalProcedures != null) {
            return;
        }
        LazyProcedures lazyProcedures = this;
        synchronized (lazyProcedures) {
            if (this.globalProcedures == null) {
                Objects.requireNonNull(this.initializer);
                this.globalProcedures = this.initializer.get();
            }
        }
    }

    public void register(CallableProcedure proc) throws ProcedureException {
        this.init();
        this.globalProcedures.register(proc);
    }

    public void register(CallableUserFunction function) throws ProcedureException {
        this.init();
        this.globalProcedures.register(function);
    }

    public void register(CallableUserAggregationFunction function) throws ProcedureException {
        this.init();
        this.globalProcedures.register(function);
    }

    public void register(CallableUserFunction function, boolean overrideCurrentImplementation) throws ProcedureException {
        this.init();
        this.globalProcedures.register(function, overrideCurrentImplementation);
    }

    public void registerBuiltIn(CallableUserFunction function) throws ProcedureException {
        this.init();
        this.globalProcedures.registerBuiltIn(function);
    }

    public void register(CallableUserAggregationFunction function, boolean overrideCurrentImplementation) throws ProcedureException {
        this.init();
        this.globalProcedures.register(function, overrideCurrentImplementation);
    }

    public void register(CallableProcedure proc, boolean overrideCurrentImplementation) throws ProcedureException {
        this.init();
        this.globalProcedures.register(proc, overrideCurrentImplementation);
    }

    public void registerProcedure(Class<?> proc) throws ProcedureException {
        this.init();
        this.globalProcedures.registerProcedure(proc);
    }

    public void registerProcedure(Class<?> proc, boolean overrideCurrentImplementation) throws ProcedureException {
        this.init();
        this.globalProcedures.registerProcedure(proc, overrideCurrentImplementation);
    }

    public void registerBuiltInFunctions(Class<?> func) throws ProcedureException {
        this.init();
        this.globalProcedures.registerBuiltInFunctions(func);
    }

    public void registerFunction(Class<?> func) throws ProcedureException {
        this.init();
        this.globalProcedures.registerFunction(func);
    }

    public void registerAggregationFunction(Class<?> func, boolean overrideCurrentImplementation) throws ProcedureException {
        this.init();
        this.globalProcedures.registerAggregationFunction(func, overrideCurrentImplementation);
    }

    public void registerAggregationFunction(Class<?> func) throws ProcedureException {
        this.init();
        this.globalProcedures.registerAggregationFunction(func);
    }

    public void registerFunction(Class<?> func, boolean overrideCurrentImplementation) throws ProcedureException {
        this.init();
        this.globalProcedures.registerFunction(func, overrideCurrentImplementation);
    }

    public void registerType(Class<?> javaClass, Neo4jTypes.AnyType type) {
        this.init();
        this.globalProcedures.registerType(javaClass, type);
    }

    public <T> void registerComponent(Class<T> cls, ThrowingFunction<Context, T, ProcedureException> provider, boolean safe) {
        this.init();
        this.globalProcedures.registerComponent(cls, provider, safe);
    }

    public ProcedureHandle procedure(QualifiedName name) throws ProcedureException {
        return this.lazyProcedureView.procedure(name);
    }

    public UserFunctionHandle function(QualifiedName name) {
        return this.lazyProcedureView.function(name);
    }

    public UserFunctionHandle aggregationFunction(QualifiedName name) {
        return this.lazyProcedureView.aggregationFunction(name);
    }

    public int[] getIdsOfFunctionsMatching(Predicate<CallableUserFunction> predicate) {
        return this.lazyProcedureView.getIdsOfFunctionsMatching(predicate);
    }

    public int[] getIdsOfAggregatingFunctionsMatching(Predicate<CallableUserAggregationFunction> predicate) {
        return this.lazyProcedureView.getIdsOfAggregatingFunctionsMatching(predicate);
    }

    public Set<ProcedureSignature> getAllProcedures() {
        return this.lazyProcedureView.getAllProcedures();
    }

    public int[] getIdsOfProceduresMatching(Predicate<CallableProcedure> predicate) {
        return this.lazyProcedureView.getIdsOfProceduresMatching(predicate);
    }

    public Stream<UserFunctionSignature> getAllNonAggregatingFunctions() {
        return this.lazyProcedureView.getAllNonAggregatingFunctions();
    }

    public Stream<UserFunctionSignature> getAllAggregatingFunctions() {
        return this.lazyProcedureView.getAllAggregatingFunctions();
    }

    public RawIterator<AnyValue[], ProcedureException> callProcedure(Context ctx, int id, AnyValue[] input, ResourceMonitor resourceMonitor) throws ProcedureException {
        return this.lazyProcedureView.callProcedure(ctx, id, input, resourceMonitor);
    }

    public AnyValue callFunction(Context ctx, int id, AnyValue[] input) throws ProcedureException {
        return this.lazyProcedureView.callFunction(ctx, id, input);
    }

    public UserAggregationReducer createAggregationFunction(Context ctx, int id) throws ProcedureException {
        return this.lazyProcedureView.createAggregationFunction(ctx, id);
    }

    public <T> ThrowingFunction<Context, T, ProcedureException> lookupComponentProvider(Class<T> cls, boolean safe) {
        return this.lazyProcedureView.lookupComponentProvider(cls, safe);
    }

    public void unregister(QualifiedName name) {
        GlobalProcedures procedures = this.globalProcedures;
        if (procedures != null) {
            procedures.unregister(name);
        }
    }

    @Override
    public void accept(Supplier<GlobalProcedures> procedureSupplier) {
        Objects.requireNonNull(procedureSupplier);
        if (this.initializer != null) {
            throw new IllegalStateException("Lazy procedures already have initializer: " + this.initializer);
        }
        this.initializer = procedureSupplier;
    }

    public ProcedureView getCurrentView() {
        if (this.globalProcedures == null) {
            return this.lazyProcedureView;
        }
        return this.globalProcedures.getCurrentView();
    }

    private class LazyProcedureView
    implements ProcedureView {
        private volatile ProcedureView view;

        private LazyProcedureView() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initView() {
            if (this.view != null) {
                return;
            }
            LazyProcedureView lazyProcedureView = this;
            synchronized (lazyProcedureView) {
                if (this.view == null) {
                    LazyProcedures.this.init();
                    this.view = LazyProcedures.this.globalProcedures.getCurrentView();
                }
            }
        }

        public ProcedureHandle procedure(QualifiedName name) throws ProcedureException {
            this.initView();
            return this.view.procedure(name);
        }

        public UserFunctionHandle function(QualifiedName name) {
            this.initView();
            return this.view.function(name);
        }

        public UserFunctionHandle aggregationFunction(QualifiedName name) {
            this.initView();
            return this.view.aggregationFunction(name);
        }

        public int[] getIdsOfFunctionsMatching(Predicate<CallableUserFunction> predicate) {
            this.initView();
            return this.view.getIdsOfFunctionsMatching(predicate);
        }

        public int[] getIdsOfAggregatingFunctionsMatching(Predicate<CallableUserAggregationFunction> predicate) {
            this.initView();
            return this.view.getIdsOfAggregatingFunctionsMatching(predicate);
        }

        public Set<ProcedureSignature> getAllProcedures() {
            this.initView();
            return this.view.getAllProcedures();
        }

        public int[] getIdsOfProceduresMatching(Predicate<CallableProcedure> predicate) {
            this.initView();
            return this.view.getIdsOfProceduresMatching(predicate);
        }

        public Stream<UserFunctionSignature> getAllNonAggregatingFunctions() {
            this.initView();
            return this.view.getAllNonAggregatingFunctions();
        }

        public Stream<UserFunctionSignature> getAllAggregatingFunctions() {
            this.initView();
            return this.view.getAllAggregatingFunctions();
        }

        public RawIterator<AnyValue[], ProcedureException> callProcedure(Context ctx, int id, AnyValue[] input, ResourceMonitor resourceMonitor) throws ProcedureException {
            this.initView();
            return this.view.callProcedure(ctx, id, input, resourceMonitor);
        }

        public AnyValue callFunction(Context ctx, int id, AnyValue[] input) throws ProcedureException {
            this.initView();
            return this.view.callFunction(ctx, id, input);
        }

        public UserAggregationReducer createAggregationFunction(Context ctx, int id) throws ProcedureException {
            this.initView();
            return this.view.createAggregationFunction(ctx, id);
        }

        public <T> ThrowingFunction<Context, T, ProcedureException> lookupComponentProvider(Class<T> cls, boolean safe) {
            this.initView();
            return this.view.lookupComponentProvider(cls, safe);
        }
    }
}

