/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.time.Duration;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.util.concurrent.BinaryLatch;

@TestDirectoryExtension
class IdRollbackOnShutdownIT {
    @Inject
    TestDirectory directory;

    IdRollbackOnShutdownIT() {
    }

    @Test
    void shouldNotWriteToIdGeneratorOnRollbackAfterShutdown() throws Exception {
        DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).setConfig(GraphDatabaseSettings.shutdown_transaction_end_timeout, (Object)Duration.ofMillis(1L)).setConfig(GraphDatabaseInternalSettings.shutdown_terminated_transaction_wait_timeout, (Object)Duration.ofMillis(1L)).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)dbms.database("neo4j");
        BinaryLatch waitTx = new BinaryLatch();
        BinaryLatch waitShutdown = new BinaryLatch();
        BinaryLatch continueShutdown = new BinaryLatch();
        DatabaseLayout layout = db.databaseLayout();
        LifeSupport life = ((Database)db.getDependencyResolver().resolveDependency(Database.class)).getLife();
        life.add(LifecycleAdapter.onShutdown(() -> {
            waitShutdown.release();
            continueShutdown.await();
        }));
        try (OtherThreadExecutor executor = new OtherThreadExecutor("test");){
            Future future = executor.executeDontWait(() -> {
                try (Transaction tx = db.beginTx();){
                    tx.createNode();
                    waitTx.release();
                    waitShutdown.await();
                    tx.rollback();
                }
                finally {
                    continueShutdown.release();
                }
                return null;
            });
            waitTx.await();
            dbms.shutdown();
            ConsistencyCheckService.Result result = new ConsistencyCheckService(layout).with(Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (Object)ByteUnit.mebiBytes((long)8L))).with(this.directory.getFileSystem()).with(this.directory.homePath()).runFullConsistencyCheck();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.isSuccessful()).as(result.summary().toString(), new Object[0])).isFalse();
            future.get();
        }
    }
}

