/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableObject;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.SetIterable;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.kernel.api.schema.vector.VectorTestUtils;
import org.neo4j.kernel.api.vector.VectorSimilarityFunction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.Tokens;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class VectorIndexCreationTest {
    private static final VectorIndexVersion LATEST = VectorIndexVersion.latestSupportedVersion((KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
    private static final Map<IndexSetting, Object> DEFAULT_SETTINGS_FOR_TESTING = IndexSettingUtil.defaultSettingsForTesting((org.neo4j.graphdb.schema.IndexType)IndexType.VECTOR.toPublicApi());

    static VectorTestUtils.VectorIndexSettings defaultSettings() {
        return VectorTestUtils.VectorIndexSettings.from(DEFAULT_SETTINGS_FOR_TESTING);
    }

    private static class RelIndexFactory
    extends Factory {
        private static final RelIndexFactory INSTANCE = new RelIndexFactory();
        private static final RelationshipType REL_TYPE = Tokens.Factories.RELATIONSHIP_TYPE.fromName("VECTOR");

        private RelIndexFactory() {
        }

        @Override
        int tokenId(KernelTransaction ktx) throws KernelException {
            return Tokens.Factories.RELATIONSHIP_TYPE.getId(ktx, REL_TYPE);
        }

        @Override
        protected SchemaDescriptor schemaDescriptor(int relTypeId, int ... propKeyIds) {
            return SchemaDescriptors.forRelType((int)relTypeId, (int[])propKeyIds);
        }

        @Override
        protected IndexCreator indexCreator(Transaction tx) {
            return tx.schema().indexFor(REL_TYPE);
        }
    }

    private static class NodeIndexFactory
    extends Factory {
        private static final NodeIndexFactory INSTANCE = new NodeIndexFactory();
        private static final Label LABEL = Tokens.Factories.LABEL.fromName("Vector");

        private NodeIndexFactory() {
        }

        @Override
        int tokenId(KernelTransaction ktx) throws KernelException {
            return Tokens.Factories.LABEL.getId(ktx, LABEL);
        }

        @Override
        protected SchemaDescriptor schemaDescriptor(int labelId, int ... propKeyIds) {
            return SchemaDescriptors.forLabel((int)labelId, (int[])propKeyIds);
        }

        @Override
        protected IndexCreator indexCreator(Transaction tx) {
            return tx.schema().indexFor(LABEL);
        }
    }

    static abstract class Factory {
        Factory() {
        }

        abstract int tokenId(KernelTransaction var1) throws KernelException;

        abstract SchemaDescriptor schemaDescriptor(int var1, int ... var2);

        abstract IndexCreator indexCreator(Transaction var1);
    }

    @ImpermanentDbmsExtension(configurationCallback="configure")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    static abstract class TestBase {
        protected static final List<String> PROP_KEYS = new Tokens.Suppliers.PropertyKey("vector", Tokens.Suppliers.Suffixes.incrementing()).get(2);
        protected final Factory factory;
        private final SetIterable<VectorIndexVersion> validVersions;
        @Inject
        private GraphDatabaseAPI db;
        protected int tokenId;
        protected int[] propKeyIds;

        TestBase(Factory factory, SetIterable<VectorIndexVersion> validVersions) {
            this.factory = factory;
            this.validVersions = validVersions;
        }

        @ExtensionCallback
        void configure(TestDatabaseManagementServiceBuilder builder) {
            builder.setConfig(GraphDatabaseInternalSettings.always_use_latest_index_provider, (Object)false);
        }

        @BeforeAll
        void setup() throws Exception {
            try (Transaction tx = this.db.beginTx();){
                KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
                this.tokenId = this.factory.tokenId(ktx);
                this.propKeyIds = Tokens.Factories.PROPERTY_KEY.getIds(ktx, PROP_KEYS);
                tx.commit();
            }
        }

        @BeforeEach
        void dropAllIndexes() {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().getIndexes().forEach(IndexDefinition::drop);
                tx.commit();
            }
        }

        protected SetIterable<VectorIndexVersion> validVersions() {
            return this.validVersions;
        }

        protected boolean hasValidVersions() {
            return this.validVersions.notEmpty();
        }

        protected boolean latestIsValid() {
            return this.validVersions.contains((Object)LATEST);
        }

        protected static VectorIndexVersion max(VectorIndexVersion ... versions) {
            return (VectorIndexVersion)Sets.mutable.of((Object[])versions).max();
        }

        protected static SetIterable<VectorIndexVersion> inclusiveVersionRangeFrom(VectorIndexVersion from) {
            return TestBase.inclusiveVersionRange(from, LATEST);
        }

        protected static SetIterable<VectorIndexVersion> inclusiveVersionRange(VectorIndexVersion from, VectorIndexVersion to) {
            return VectorIndexVersion.KNOWN_VERSIONS.asLazy().select((Predicate & Serializable)version -> from.compareTo((Enum)version) <= 0 && version.compareTo((Enum)to) <= 0).toSet();
        }

        protected IndexDescriptor createVectorIndex(VectorIndexVersion version, VectorTestUtils.VectorIndexSettings settings, int ... propKeyIds) throws KernelException {
            IndexDescriptor indexDescriptor;
            try (Transaction tx = this.db.beginTx();){
                KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
                IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)this.factory.schemaDescriptor(this.tokenId, propKeyIds)).withIndexType(IndexType.VECTOR).withIndexProvider(version.descriptor()).withIndexConfig(settings.toIndexConfig());
                indexDescriptor = ktx.schemaWrite().indexCreate(prototype);
                tx.commit();
            }
            return indexDescriptor;
        }

        protected IndexDescriptor createVectorIndex(VectorTestUtils.VectorIndexSettings settings, String propKey) {
            return this.createVectorIndex(settings, List.of(propKey));
        }

        protected IndexDescriptor createVectorIndex(VectorTestUtils.VectorIndexSettings settings, List<String> propKeys) {
            IndexDescriptor indexDescriptor;
            try (Transaction tx = this.db.beginTx();){
                IndexDefinition index = this.createVectorIndex(this.factory.indexCreator(tx), settings, propKeys);
                indexDescriptor = ((IndexDefinitionImpl)index).getIndexReference();
                tx.commit();
            }
            return indexDescriptor;
        }

        protected IndexDefinition createVectorIndex(IndexCreator creator, VectorTestUtils.VectorIndexSettings settings, List<String> propKeys) {
            creator = creator.withIndexType(IndexType.VECTOR.toPublicApi()).withIndexConfiguration(settings.toMap());
            for (String propKey : propKeys) {
                creator = creator.on(propKey);
            }
            return creator.create();
        }

        protected IndexDescriptor findIndex(String name) {
            try (Transaction tx = this.db.beginTx();){
                IndexDefinition index = tx.schema().getIndexByName(name);
                IndexDescriptor indexDescriptor = ((IndexDefinitionImpl)index).getIndexReference();
                return indexDescriptor;
            }
        }
    }

    @Nested
    class Relationship
    extends Entity {
        Relationship(VectorIndexCreationTest this$0) {
            super(RelIndexFactory.INSTANCE, VectorIndexVersion.V2_0);
        }
    }

    @Nested
    class Node
    extends Entity {
        Node(VectorIndexCreationTest this$0) {
            super(NodeIndexFactory.INSTANCE, VectorIndexVersion.V1_0);
        }
    }

    static abstract class Entity {
        private final Factory factory;
        private final VectorIndexVersion minimumVersionForEntity;

        Entity(Factory factory, VectorIndexVersion minimumVersion) {
            this.factory = factory;
            this.minimumVersionForEntity = minimumVersion;
        }

        private static void assertDoesNotThrow(ThrowableAssert.ThrowingCallable callable) {
            Assertions.assertThatCode((ThrowableAssert.ThrowingCallable)callable).doesNotThrowAnyException();
        }

        private static void assertSettingHasValue(IndexSetting setting, IndexConfig indexConfig, Value value) {
            Assertions.assertThat((Object)indexConfig.get(setting.getSettingName())).isEqualTo((Object)value);
        }

        private static void assertMissingSetting(IndexSetting setting, IndexConfig indexConfig) {
            Assertions.assertThat((Map)indexConfig.asMap()).doesNotContainKey((Object)setting.getSettingName());
        }

        private static void assertMissingExpectedSetting(IndexSetting setting, ThrowableAssert.ThrowingCallable callable) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(IllegalArgumentException.class)).hasMessageContainingAll(new CharSequence[]{setting.getSettingName(), "is expected to have been set"});
        }

        @Nested
        class HnswEfConstruction
        extends TestBase {
            private static final IndexSetting SETTING = IndexSetting.vector_Hnsw_Ef_Construction();
            private static final Value DEFAULT_VALUE = Values.intValue((int)100);

            HnswEfConstruction(Entity this$0) {
                super(this$0.factory, HnswEfConstruction.inclusiveVersionRangeFrom(HnswEfConstruction.max(this$0.minimumVersionForEntity, VectorIndexVersion.V2_0)));
            }

            @ParameterizedTest
            @MethodSource
            void shouldAcceptSupported(VectorIndexVersion version, int efConstruction) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withHnswEfConstruction(efConstruction);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(version, settings, this.propKeyIds[0])));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), (Value)Values.intValue((int)efConstruction));
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), (Value)Values.intValue((int)efConstruction));
            }

            Iterable<Arguments> shouldAcceptSupported() {
                return this.validVersions().asLazy().flatCollect((Function & Serializable)version -> HnswEfConstruction.supported(1, version.maxHnswEfConstruction()).asLazy().collect((Function & Serializable)efConstruction -> Arguments.of((Object[])new Object[]{version, efConstruction})));
            }

            @ParameterizedTest
            @MethodSource
            @EnabledIf(value="latestIsValid")
            void shouldAcceptSupportedCoreAPI(int efConstruction) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withHnswEfConstruction(efConstruction);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(settings, (String)PROP_KEYS.get(1))));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), (Value)Values.intValue((int)efConstruction));
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), (Value)Values.intValue((int)efConstruction));
            }

            static Iterable<Integer> shouldAcceptSupportedCoreAPI() {
                return HnswEfConstruction.supported(1, LATEST.maxHnswEfConstruction());
            }

            static RichIterable<Integer> supported(int min, int max) {
                return Lists.immutable.of((Object)min, (Object)Math.ceilDiv(max - min, 2), (Object)max);
            }

            @ParameterizedTest
            @MethodSource(value={"validVersions"})
            @EnabledIf(value="hasValidVersions")
            void shouldAcceptMissingSetting(VectorIndexVersion version) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().unset(SETTING);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(version, settings, this.propKeyIds[0])));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), DEFAULT_VALUE);
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), DEFAULT_VALUE);
            }

            @Test
            @EnabledIf(value="latestIsValid")
            void shouldAcceptMissingSettingCoreAPI() {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().unset(SETTING);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(settings, (String)PROP_KEYS.get(1))));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), DEFAULT_VALUE);
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), DEFAULT_VALUE);
            }

            @ParameterizedTest
            @MethodSource
            void shouldRejectUnsupported(VectorIndexVersion version, int efConstruction) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withHnswEfConstruction(efConstruction);
                HnswEfConstruction.assertUnsupported(version, () -> this.createVectorIndex(version, settings, this.propKeyIds[0]));
            }

            Iterable<Arguments> shouldRejectUnsupported() {
                return this.validVersions().asLazy().flatCollect((Function & Serializable)version -> HnswEfConstruction.unsupportedEfConstruction(version).asLazy().collect((Function & Serializable)M -> Arguments.of((Object[])new Object[]{version, M})));
            }

            @ParameterizedTest
            @MethodSource
            @EnabledIf(value="latestIsValid")
            void shouldRejectUnsupportedCoreAPI(int efConstruction) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withHnswEfConstruction(efConstruction);
                HnswEfConstruction.assertUnsupported(LATEST, () -> this.createVectorIndex(settings, (String)PROP_KEYS.get(1)));
            }

            Iterable<Integer> shouldRejectUnsupportedCoreAPI() {
                return HnswEfConstruction.unsupportedEfConstruction(LATEST);
            }

            static RichIterable<Integer> unsupportedEfConstruction(VectorIndexVersion version) {
                return Lists.immutable.of((Object)-1, (Object)0, (Object)(version.maxHnswEfConstruction() + 1));
            }

            private static void assertUnsupported(VectorIndexVersion version, ThrowableAssert.ThrowingCallable callable) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(IllegalArgumentException.class)).hasMessageContainingAll(new CharSequence[]{IndexSetting.vector_Hnsw_Ef_Construction().getSettingName(), "must be between 1 and", String.valueOf(version.maxHnswEfConstruction()), "inclusively"});
            }
        }

        @Nested
        class HnswM
        extends TestBase {
            private static final IndexSetting SETTING = IndexSetting.vector_Hnsw_M();
            private static final Value DEFAULT_VALUE = Values.intValue((int)16);

            HnswM(Entity this$0) {
                super(this$0.factory, HnswM.inclusiveVersionRangeFrom(HnswM.max(this$0.minimumVersionForEntity, VectorIndexVersion.V2_0)));
            }

            @ParameterizedTest
            @MethodSource
            void shouldAcceptSupported(VectorIndexVersion version, int M) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withHnswM(M);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(version, settings, this.propKeyIds[0])));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), (Value)Values.intValue((int)M));
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), (Value)Values.intValue((int)M));
            }

            Iterable<Arguments> shouldAcceptSupported() {
                return this.validVersions().asLazy().flatCollect((Function & Serializable)version -> HnswM.supported(1, version.maxHnswM()).asLazy().collect((Function & Serializable)M -> Arguments.of((Object[])new Object[]{version, M})));
            }

            @ParameterizedTest
            @MethodSource
            @EnabledIf(value="latestIsValid")
            void shouldAcceptSupportedCoreAPI(int M) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withHnswM(M);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(settings, (String)PROP_KEYS.get(1))));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), (Value)Values.intValue((int)M));
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), (Value)Values.intValue((int)M));
            }

            static Iterable<Integer> shouldAcceptSupportedCoreAPI() {
                return HnswM.supported(1, LATEST.maxHnswM());
            }

            static RichIterable<Integer> supported(int min, int max) {
                return Lists.immutable.of((Object)min, (Object)Math.ceilDiv(max - min, 2), (Object)max);
            }

            @ParameterizedTest
            @MethodSource(value={"validVersions"})
            @EnabledIf(value="hasValidVersions")
            void shouldAcceptMissingSetting(VectorIndexVersion version) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().unset(SETTING);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(version, settings, this.propKeyIds[0])));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), DEFAULT_VALUE);
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), DEFAULT_VALUE);
            }

            @Test
            @EnabledIf(value="latestIsValid")
            void shouldAcceptMissingSettingCoreAPI() {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().unset(SETTING);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(settings, (String)PROP_KEYS.get(1))));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), DEFAULT_VALUE);
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), DEFAULT_VALUE);
            }

            @ParameterizedTest
            @MethodSource
            void shouldRejectUnsupported(VectorIndexVersion version, int M) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withHnswM(M);
                HnswM.assertUnsupported(version, () -> this.createVectorIndex(version, settings, this.propKeyIds[0]));
            }

            Iterable<Arguments> shouldRejectUnsupported() {
                return this.validVersions().asLazy().flatCollect((Function & Serializable)version -> HnswM.unsupportedM(version).asLazy().collect((Function & Serializable)M -> Arguments.of((Object[])new Object[]{version, M})));
            }

            @ParameterizedTest
            @MethodSource
            @EnabledIf(value="latestIsValid")
            void shouldRejectUnsupportedCoreAPI(int M) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withHnswM(M);
                HnswM.assertUnsupported(LATEST, () -> this.createVectorIndex(settings, (String)PROP_KEYS.get(1)));
            }

            Iterable<Integer> shouldRejectUnsupportedCoreAPI() {
                return HnswM.unsupportedM(LATEST);
            }

            static RichIterable<Integer> unsupportedM(VectorIndexVersion version) {
                return Lists.immutable.of((Object)-1, (Object)0, (Object)(version.maxHnswM() + 1));
            }

            private static void assertUnsupported(VectorIndexVersion version, ThrowableAssert.ThrowingCallable callable) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(IllegalArgumentException.class)).hasMessageContainingAll(new CharSequence[]{IndexSetting.vector_Hnsw_M().getSettingName(), "must be between 1 and", String.valueOf(version.maxHnswM()), "inclusively"});
            }
        }

        @Nested
        class Quantization
        extends TestBase {
            private static final IndexSetting SETTING = IndexSetting.vector_Quantization_Enabled();
            private static final Value DEFAULT_VALUE = BooleanValue.TRUE;

            Quantization(Entity this$0) {
                super(this$0.factory, Quantization.inclusiveVersionRangeFrom(Quantization.max(this$0.minimumVersionForEntity, VectorIndexVersion.V2_0)));
            }

            @ParameterizedTest
            @MethodSource
            void shouldAcceptSupported(VectorIndexVersion version, boolean quantizationEnabled) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withQuantizationEnabled(quantizationEnabled);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(version, settings, this.propKeyIds[0])));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), (Value)Values.booleanValue((boolean)quantizationEnabled));
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), (Value)Values.booleanValue((boolean)quantizationEnabled));
            }

            Iterable<Arguments> shouldAcceptSupported() {
                return this.validVersions().asLazy().flatCollect((Function & Serializable)version -> this.supported((VectorIndexVersion)version).asLazy().collect((Function & Serializable)similarityFunction -> Arguments.of((Object[])new Object[]{version, similarityFunction})));
            }

            @ParameterizedTest
            @MethodSource
            @EnabledIf(value="latestIsValid")
            void shouldAcceptSupportedCoreAPI(boolean quantizationEnabled) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withQuantizationEnabled(quantizationEnabled);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(settings, (String)PROP_KEYS.get(1))));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), (Value)Values.booleanValue((boolean)quantizationEnabled));
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), (Value)Values.booleanValue((boolean)quantizationEnabled));
            }

            Iterable<Boolean> shouldAcceptSupportedCoreAPI() {
                return this.supported(LATEST);
            }

            RichIterable<Boolean> supported(VectorIndexVersion version) {
                return version.supportedQuantizationBooleans().asLazy().collect((BooleanToObjectFunction & Serializable)b -> b);
            }

            @ParameterizedTest
            @MethodSource(value={"validVersions"})
            @EnabledIf(value="hasValidVersions")
            void shouldAcceptMissingSetting(VectorIndexVersion version) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().unset(SETTING);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(version, settings, this.propKeyIds[0])));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), DEFAULT_VALUE);
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), DEFAULT_VALUE);
            }

            @Test
            @EnabledIf(value="latestIsValid")
            void shouldAcceptMissingSettingCoreAPI() {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().unset(SETTING);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(settings, (String)PROP_KEYS.get(1))));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), DEFAULT_VALUE);
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), DEFAULT_VALUE);
            }
        }

        @Nested
        class DefaultedSimilarityFunction
        extends TestBase {
            private static final IndexSetting SETTING = IndexSetting.vector_Similarity_Function();
            private static final Value DEFAULT_VALUE = Values.stringValue((String)"COSINE");

            DefaultedSimilarityFunction(Entity this$0) {
                super(this$0.factory, DefaultedSimilarityFunction.inclusiveVersionRangeFrom(DefaultedSimilarityFunction.max(this$0.minimumVersionForEntity, VectorIndexVersion.V2_0)));
            }

            @ParameterizedTest
            @MethodSource(value={"validVersions"})
            @EnabledIf(value="hasValidVersions")
            void shouldAcceptMissingSetting(VectorIndexVersion version) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().unset(SETTING);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(version, settings, this.propKeyIds[0])));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), DEFAULT_VALUE);
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), DEFAULT_VALUE);
            }

            @Test
            @EnabledIf(value="latestIsValid")
            void shouldAcceptMissingSettingCoreAPI() {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().unset(SETTING);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(settings, (String)PROP_KEYS.get(1))));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), DEFAULT_VALUE);
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), DEFAULT_VALUE);
            }
        }

        @Nested
        class RequiredSimilarityFunction
        extends TestBase {
            private static final IndexSetting SETTING = IndexSetting.vector_Similarity_Function();

            RequiredSimilarityFunction(Entity this$0) {
                super(this$0.factory, RequiredSimilarityFunction.inclusiveVersionRange(RequiredSimilarityFunction.max(this$0.minimumVersionForEntity, VectorIndexVersion.V1_0), VectorIndexVersion.V1_0));
            }

            @ParameterizedTest
            @MethodSource(value={"validVersions"})
            @EnabledIf(value="hasValidVersions")
            void shouldRequireSetting(VectorIndexVersion version) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().unset(SETTING);
                Entity.assertMissingExpectedSetting(SETTING, () -> this.createVectorIndex(version, settings, this.propKeyIds[0]));
            }

            @Test
            @EnabledIf(value="latestIsValid")
            void shouldRequireSettingCoreAPI() {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().unset(SETTING);
                Entity.assertMissingExpectedSetting(SETTING, () -> this.createVectorIndex(settings, (String)PROP_KEYS.get(1)));
            }
        }

        @Nested
        class SimilarityFunctions
        extends TestBase {
            private static final IndexSetting SETTING = IndexSetting.vector_Similarity_Function();

            SimilarityFunctions(Entity this$0) {
                super(this$0.factory, SimilarityFunctions.inclusiveVersionRangeFrom(SimilarityFunctions.max(this$0.minimumVersionForEntity, VectorIndexVersion.V1_0)));
            }

            @ParameterizedTest
            @MethodSource
            void shouldAcceptSupported(VectorIndexVersion version, VectorSimilarityFunction similarityFunction) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withSimilarityFunction(similarityFunction);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(version, settings, this.propKeyIds[0])));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), (Value)Values.stringValue((String)similarityFunction.name()));
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), (Value)Values.stringValue((String)similarityFunction.name()));
            }

            Iterable<Arguments> shouldAcceptSupported() {
                return this.validVersions().asLazy().flatCollect((Function & Serializable)version -> SimilarityFunctions.supported(version).asLazy().collect((Function & Serializable)similarityFunction -> Arguments.of((Object[])new Object[]{version, similarityFunction})));
            }

            @ParameterizedTest
            @MethodSource
            @EnabledIf(value="latestIsValid")
            void shouldAcceptSupportedCoreAPI(VectorSimilarityFunction similarityFunction) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withSimilarityFunction(similarityFunction);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(settings, (String)PROP_KEYS.get(1))));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), (Value)Values.stringValue((String)similarityFunction.name()));
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), (Value)Values.stringValue((String)similarityFunction.name()));
            }

            static Iterable<VectorSimilarityFunction> shouldAcceptSupportedCoreAPI() {
                return SimilarityFunctions.supported(LATEST);
            }

            static RichIterable<VectorSimilarityFunction> supported(VectorIndexVersion version) {
                return version.supportedSimilarityFunctions();
            }

            @ParameterizedTest
            @MethodSource(value={"validVersions"})
            @EnabledIf(value="hasValidVersions")
            void shouldRejectUnsupported(VectorIndexVersion version) {
                String similarityFunctionName = "ClearlyThisIsNotASimilarityFunction";
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withSimilarityFunction("ClearlyThisIsNotASimilarityFunction");
                SimilarityFunctions.assertUnsupported(version, () -> this.createVectorIndex(version, settings, this.propKeyIds[0]));
            }

            @Test
            @EnabledIf(value="latestIsValid")
            void shouldRejectUnsupportedCoreAPI() {
                String similarityFunctionName = "ClearlyThisIsNotASimilarityFunction";
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withSimilarityFunction("ClearlyThisIsNotASimilarityFunction");
                SimilarityFunctions.assertUnsupported(LATEST, () -> this.createVectorIndex(settings, (String)PROP_KEYS.get(1)));
            }

            private static void assertUnsupported(VectorIndexVersion version, ThrowableAssert.ThrowingCallable callable) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(IllegalArgumentException.class)).hasMessageContainingAll(new CharSequence[]{"is an unsupported", SETTING.getSettingName(), "Supported", version.supportedSimilarityFunctions().asLazy().collect(VectorSimilarityFunction::name).toString()});
            }
        }

        @Nested
        class OptionalDimensions
        extends TestBase {
            private static final IndexSetting SETTING = IndexSetting.vector_Dimensions();

            OptionalDimensions(Entity this$0) {
                super(this$0.factory, OptionalDimensions.inclusiveVersionRangeFrom(OptionalDimensions.max(this$0.minimumVersionForEntity, VectorIndexVersion.V2_0)));
            }

            @ParameterizedTest
            @MethodSource(value={"validVersions"})
            @EnabledIf(value="hasValidVersions")
            void shouldAcceptMissingSetting(VectorIndexVersion version) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().unset(SETTING);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(version, settings, this.propKeyIds[0])));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertMissingSetting(SETTING, index.getIndexConfig());
                Entity.assertMissingSetting(SETTING, this.findIndex(index.getName()).getIndexConfig());
            }

            @Test
            @EnabledIf(value="latestIsValid")
            void shouldAcceptMissingSettingCoreAPI() {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().unset(SETTING);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(settings, (String)PROP_KEYS.get(1))));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertMissingSetting(SETTING, index.getIndexConfig());
                Entity.assertMissingSetting(SETTING, this.findIndex(index.getName()).getIndexConfig());
            }
        }

        @Nested
        class RequiredDimensions
        extends TestBase {
            private static final IndexSetting SETTING = IndexSetting.vector_Dimensions();

            RequiredDimensions(Entity this$0) {
                super(this$0.factory, RequiredDimensions.inclusiveVersionRange(RequiredDimensions.max(this$0.minimumVersionForEntity, VectorIndexVersion.V1_0), VectorIndexVersion.V1_0));
            }

            @ParameterizedTest
            @MethodSource(value={"validVersions"})
            @EnabledIf(value="hasValidVersions")
            void shouldRequireSetting(VectorIndexVersion version) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().unset(SETTING);
                Entity.assertMissingExpectedSetting(SETTING, () -> this.createVectorIndex(version, settings, this.propKeyIds[0]));
            }

            @Test
            @EnabledIf(value="latestIsValid")
            void shouldRequireSettingCoreAPI() {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().unset(SETTING);
                Entity.assertMissingExpectedSetting(SETTING, () -> this.createVectorIndex(settings, (String)PROP_KEYS.get(1)));
            }
        }

        @Nested
        class Dimensions
        extends TestBase {
            private static final IndexSetting SETTING = IndexSetting.vector_Dimensions();

            Dimensions(Entity this$0) {
                super(this$0.factory, Dimensions.inclusiveVersionRangeFrom(Dimensions.max(this$0.minimumVersionForEntity, VectorIndexVersion.V1_0)));
            }

            @ParameterizedTest
            @MethodSource
            void shouldAcceptSupported(VectorIndexVersion version, int dimensions) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withDimensions(dimensions);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(version, settings, this.propKeyIds[0])));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), (Value)Values.intValue((int)dimensions));
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), (Value)Values.intValue((int)dimensions));
            }

            Iterable<Arguments> shouldAcceptSupported() {
                return this.validVersions().asLazy().flatCollect((Function & Serializable)version -> Dimensions.supported(1, version.maxDimensions()).asLazy().collect((Function & Serializable)dimension -> Arguments.of((Object[])new Object[]{version, dimension})));
            }

            @ParameterizedTest
            @MethodSource
            @EnabledIf(value="latestIsValid")
            void shouldAcceptSupportedCoreAPI(int dimensions) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withDimensions(dimensions);
                MutableObject ref = new MutableObject();
                Entity.assertDoesNotThrow(() -> ref.setValue((Object)this.createVectorIndex(settings, (String)PROP_KEYS.get(1))));
                IndexDescriptor index = (IndexDescriptor)ref.getValue();
                Entity.assertSettingHasValue(SETTING, index.getIndexConfig(), (Value)Values.intValue((int)dimensions));
                Entity.assertSettingHasValue(SETTING, this.findIndex(index.getName()).getIndexConfig(), (Value)Values.intValue((int)dimensions));
            }

            static Iterable<Integer> shouldAcceptSupportedCoreAPI() {
                return Dimensions.supported(1, LATEST.maxDimensions());
            }

            static RichIterable<Integer> supported(int min, int max) {
                return Lists.immutable.of((Object)min, (Object)Math.ceilDiv(max - min, 2), (Object)max);
            }

            @ParameterizedTest
            @MethodSource
            void shouldRejectUnsupported(VectorIndexVersion version, int dimensions) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withDimensions(dimensions);
                Dimensions.assertUnsupported(version, () -> this.createVectorIndex(version, settings, this.propKeyIds[0]));
            }

            Iterable<Arguments> shouldRejectUnsupported() {
                return this.validVersions().asLazy().flatCollect((Function & Serializable)version -> Dimensions.unsupportedDimensions(version).asLazy().collect((Function & Serializable)dimension -> Arguments.of((Object[])new Object[]{version, dimension})));
            }

            @ParameterizedTest
            @MethodSource
            @EnabledIf(value="latestIsValid")
            void shouldRejectUnsupportedCoreAPI(int dimensions) {
                VectorTestUtils.VectorIndexSettings settings = VectorIndexCreationTest.defaultSettings().withDimensions(dimensions);
                Dimensions.assertUnsupported(LATEST, () -> this.createVectorIndex(settings, (String)PROP_KEYS.get(1)));
            }

            Iterable<Integer> shouldRejectUnsupportedCoreAPI() {
                return Dimensions.unsupportedDimensions(LATEST);
            }

            static RichIterable<Integer> unsupportedDimensions(VectorIndexVersion version) {
                return Lists.immutable.of((Object)-1, (Object)0, (Object)(version.maxDimensions() + 1));
            }

            private static void assertUnsupported(VectorIndexVersion version, ThrowableAssert.ThrowingCallable callable) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(IllegalArgumentException.class)).hasMessageContainingAll(new CharSequence[]{SETTING.getSettingName(), "must be between 1 and", String.valueOf(version.maxDimensions()), "inclusively"});
            }
        }

        @Nested
        class Schema
        extends TestBase {
            Schema(Entity this$0) {
                super(this$0.factory, Schema.inclusiveVersionRangeFrom(this$0.minimumVersionForEntity));
            }

            @ParameterizedTest
            @MethodSource(value={"validVersions"})
            void shouldRejectCompositeKeys(VectorIndexVersion version) {
                Schema.assertUnsupportedComposite(() -> this.createVectorIndex(version, VectorIndexCreationTest.defaultSettings(), this.propKeyIds));
            }

            @Test
            @EnabledIf(value="latestIsValid")
            void shouldRejectCompositeKeysCoreAPI() {
                Schema.assertUnsupportedComposite(() -> this.createVectorIndex(VectorIndexCreationTest.defaultSettings(), PROP_KEYS));
            }

            private static void assertUnsupportedComposite(ThrowableAssert.ThrowingCallable callable) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(UnsupportedOperationException.class)).hasMessageContainingAll(new CharSequence[]{"Composite indexes are not supported for", IndexType.VECTOR.name(), "index type"});
            }
        }

        @Nested
        class IndexProvider
        extends TestBase {
            private final SetIterable<VectorIndexVersion> invalidVersions = VectorIndexVersion.KNOWN_VERSIONS.toSet().difference(this.validVersions());

            IndexProvider(Entity this$0) {
                super(this$0.factory, IndexProvider.inclusiveVersionRangeFrom(this$0.minimumVersionForEntity));
            }

            @ParameterizedTest
            @MethodSource(value={"invalidVersions"})
            @EnabledIf(value="hasInvalidVersions")
            void shouldRejectVectorIndexOnUnsupportedVersions(VectorIndexVersion version) {
                IndexProvider.assertUnsupportedIndex(() -> this.createVectorIndex(version, VectorIndexCreationTest.defaultSettings(), this.propKeyIds[0]));
            }

            SetIterable<VectorIndexVersion> invalidVersions() {
                return this.invalidVersions;
            }

            boolean hasInvalidVersions() {
                return this.invalidVersions.notEmpty();
            }

            private static void assertUnsupportedIndex(ThrowableAssert.ThrowingCallable callable) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(UnsupportedOperationException.class)).hasMessageContainingAll(new CharSequence[]{"vector indexes with provider", "are not supported"});
            }
        }
    }
}

