/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.ZoneOffset;
import java.util.TimeZone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.log4j.LogUtils;
import org.neo4j.logging.log4j.LoggerTarget;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class SystemTimeZoneLoggingIT {
    @Inject
    private TestDirectory testDirectory;

    SystemTimeZoneLoggingIT() {
    }

    @Test
    void databaseLogsUseSystemTimeZoneIfConfigure() throws IOException {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        try {
            this.checkStartLogLine(5, "+0500");
            this.checkStartLogLine(-7, "-0700");
        }
        finally {
            TimeZone.setDefault(defaultTimeZone);
        }
    }

    private void checkStartLogLine(int hoursShift, String timeZoneSuffix) throws IOException {
        TimeZone.setDefault(TimeZone.getTimeZone(ZoneOffset.ofHours(hoursShift)));
        Path storeDir = this.testDirectory.homePath(String.valueOf(hoursShift));
        Path debugLog = storeDir.resolve("logs").resolve("debug.log");
        Path logXmlConfig = storeDir.resolve("log.xml");
        LogUtils.newXmlConfigBuilder((FileSystemAbstraction)this.testDirectory.getFileSystem(), (Path)logXmlConfig).withLogger(LogUtils.newLoggerBuilder((LoggerTarget)LoggerTarget.ROOT_LOGGER, (Path)debugLog).withTimezone(LogTimeZone.SYSTEM).build()).create();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).setConfig(GraphDatabaseSettings.db_timezone, (Object)LogTimeZone.SYSTEM).setConfig(GraphDatabaseSettings.server_logging_config_path, (Object)logXmlConfig).build();
        managementService.database("neo4j");
        managementService.shutdown();
        String debugLogLine = Files.readAllLines(debugLog).get(0);
        Assertions.assertTrue((boolean)debugLogLine.contains(timeZoneSuffix), (String)debugLogLine);
    }
}

