/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableLong;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.DbmsRuntimeVersionProvider;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.ZippedStore;
import org.neo4j.kernel.ZippedStoreCommunity;
import org.neo4j.kernel.impl.locking.forseti.ForsetiClient;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.event.InternalTransactionEventListener;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.Race;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.UpgradeTestUtil;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.util.concurrent.BinaryLatch;

@TestDirectoryExtension
public class DatabaseUpgradeTransactionIT {
    private static final ZippedStore ZIPPED_STORE = ZippedStoreCommunity.REC_AF11_V50_EMPTY;
    private static final KernelVersion OLD_KERNEL_VERSION = ZIPPED_STORE.statistics().kernelVersion();
    private static final DbmsRuntimeVersion OLD_DBMS_RUNTIME_VERSION = DbmsRuntimeVersion.VERSIONS.stream().filter(dbmsRuntimeVersion -> dbmsRuntimeVersion.kernelVersion() == OLD_KERNEL_VERSION).findFirst().orElseThrow();
    @Inject
    protected TestDirectory testDirectory;
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    protected DatabaseManagementService dbms;
    protected GraphDatabaseAPI db;
    private GraphDatabaseAPI systemDb;
    protected KernelVersion oldKernelVersion;
    protected DbmsRuntimeVersion oldDbmsRuntimeVersion;

    @BeforeEach
    void setUp() throws IOException {
        this.createDbFiles();
        this.startDbms();
    }

    @AfterEach
    void tearDown() {
        if (this.dbms != null) {
            this.dbms.shutdown();
        }
    }

    protected void createDbFiles() throws IOException {
        this.oldKernelVersion = OLD_KERNEL_VERSION;
        this.oldDbmsRuntimeVersion = OLD_DBMS_RUNTIME_VERSION;
        ZIPPED_STORE.unzip(this.testDirectory.homePath());
    }

    protected TestDatabaseManagementServiceBuilder configure(TestDatabaseManagementServiceBuilder builder) {
        return builder.setDatabaseRootDirectory(this.testDirectory.homePath()).setInternalLogProvider((InternalLogProvider)this.logProvider).setConfig(GraphDatabaseInternalSettings.automatic_upgrade_enabled, (Object)false);
    }

    @Test
    void shouldUpgradeDatabaseToLatestVersionOnFirstWriteTransaction() throws Exception {
        long startTransaction = this.lastCommittedTransactionId();
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)this.oldKernelVersion);
        this.createWriteTransaction();
        this.set(LatestVersions.LATEST_RUNTIME_VERSION);
        this.createReadTransaction();
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)this.oldKernelVersion);
        this.createWriteTransaction();
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)LatestVersions.LATEST_KERNEL_VERSION);
        UpgradeTestUtil.assertUpgradeTransactionInOrder((KernelVersion)this.oldKernelVersion, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (long)startTransaction, (GraphDatabaseAPI)this.db);
    }

    @ParameterizedTest
    @EnumSource(mode=EnumSource.Mode.MATCH_ALL, names={"V5_[0-9]+"})
    void shouldUpgradeDatabaseToMaxKernelVersionForDbmsRuntimeVersionOnFirstWriteTransaction(DbmsRuntimeVersion dbmsRuntimeVersion) throws Exception {
        ((AbstractComparableAssert)Assumptions.assumeThat((Comparable)dbmsRuntimeVersion).as("needs to be newer to upgrade", new Object[0])).isGreaterThan((Comparable)this.oldDbmsRuntimeVersion);
        long startTransaction = this.lastCommittedTransactionId();
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)this.oldKernelVersion);
        Assertions.assertThat((Comparable)this.dbmsRuntimeVersion()).isEqualTo((Object)this.oldDbmsRuntimeVersion);
        this.createWriteTransaction();
        this.set(dbmsRuntimeVersion);
        this.createReadTransaction();
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)this.oldKernelVersion);
        this.createWriteTransaction();
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)dbmsRuntimeVersion.kernelVersion());
        UpgradeTestUtil.assertUpgradeTransactionInOrder((KernelVersion)this.oldKernelVersion, (KernelVersion)dbmsRuntimeVersion.kernelVersion(), (long)startTransaction, (GraphDatabaseAPI)this.db);
    }

    @Test
    void shouldUpgradeDatabaseToLatestVersionOnFirstWriteTransactionStressTest() throws Throwable {
        long startTransaction = this.lastCommittedTransactionId();
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)this.oldKernelVersion);
        Assertions.assertThat((Comparable)this.dbmsRuntimeVersion()).isEqualTo((Object)this.oldDbmsRuntimeVersion);
        this.createWriteTransaction();
        Race race = new Race().withRandomStartDelays().withEndCondition(new BooleanSupplier[]{() -> LatestVersions.LATEST_KERNEL_VERSION.equals((Object)this.kernelVersion())});
        race.addContestant(() -> UpgradeTestUtil.upgradeDbms((DatabaseManagementService)this.dbms), 1);
        race.addContestants(Integer.max(Runtime.getRuntime().availableProcessors() - 1, 2), Race.throwing(() -> {
            this.createWriteTransaction();
            Thread.sleep(ThreadLocalRandom.current().nextInt(0, 2));
        }));
        race.go(1L, TimeUnit.MINUTES);
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)LatestVersions.LATEST_KERNEL_VERSION);
        Assertions.assertThat((Comparable)this.dbmsRuntimeVersion()).isEqualTo((Object)LatestVersions.LATEST_RUNTIME_VERSION);
        UpgradeTestUtil.assertUpgradeTransactionInOrder((KernelVersion)this.oldKernelVersion, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (long)startTransaction, (GraphDatabaseAPI)this.db);
    }

    @Test
    void shouldUpgradeDatabaseToLatestVersionOnDenseNodeTransactionStressTest() throws Throwable {
        long startTransaction = this.lastCommittedTransactionId();
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)this.oldKernelVersion);
        Assertions.assertThat((Comparable)this.dbmsRuntimeVersion()).isEqualTo((Object)this.oldDbmsRuntimeVersion);
        String nodeId = this.createDenseNode();
        Race race = new Race().withRandomStartDelays().withEndCondition(new BooleanSupplier[]{new BooleanSupplier(){
            private final AtomicLong timeOfUpgrade = new AtomicLong();

            @Override
            public boolean getAsBoolean() {
                if (LatestVersions.LATEST_KERNEL_VERSION.equals((Object)DatabaseUpgradeTransactionIT.this.kernelVersion())) {
                    this.timeOfUpgrade.compareAndSet(0L, System.currentTimeMillis());
                }
                return this.timeOfUpgrade.get() != 0L && System.currentTimeMillis() - this.timeOfUpgrade.get() > 1000L;
            }
        }});
        race.addContestant(Race.throwing(() -> {
            while (true) {
                try {
                    Thread.sleep(ThreadLocalRandom.current().nextInt(0, 1000));
                    UpgradeTestUtil.upgradeDbms((DatabaseManagementService)this.dbms);
                    return;
                }
                catch (DeadlockDetectedException deadlockDetectedException) {
                    continue;
                }
                break;
            }
        }), 1);
        race.addContestants(Integer.max(Runtime.getRuntime().availableProcessors() - 1, 2), Race.throwing(() -> {
            while (true) {
                try (Transaction tx = this.db.beginTx();){
                    tx.getNodeByElementId(nodeId).createRelationshipTo(tx.createNode(), RelationshipType.withName((String)("TYPE_" + ThreadLocalRandom.current().nextInt(3))));
                    tx.commit();
                    Thread.sleep(ThreadLocalRandom.current().nextInt(0, 2));
                    return;
                }
                catch (DeadlockDetectedException deadlockDetectedException) {
                    continue;
                }
                break;
            }
        }));
        race.go(10L, TimeUnit.MINUTES);
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)LatestVersions.LATEST_KERNEL_VERSION);
        Assertions.assertThat((Comparable)this.dbmsRuntimeVersion()).isEqualTo((Object)LatestVersions.LATEST_RUNTIME_VERSION);
        UpgradeTestUtil.assertUpgradeTransactionInOrder((KernelVersion)this.oldKernelVersion, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (long)startTransaction, (GraphDatabaseAPI)this.db);
        this.assertDegrees(nodeId);
    }

    @Test
    void shouldNotUpgradePastDbmsRuntime() {
        this.createWriteTransaction();
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)this.oldKernelVersion);
    }

    @Test
    void shouldHandleDeadlocksOnUpgradeTransaction() throws Exception {
        final String lockNode1 = this.createWriteTransaction();
        final String lockNode2 = this.createWriteTransaction();
        final BinaryLatch l1 = new BinaryLatch();
        final BinaryLatch l2 = new BinaryLatch();
        long numNodesBefore = this.getNodeCount();
        this.dbms.registerTransactionEventListener(this.db.databaseName(), (TransactionEventListener)new InternalTransactionEventListener.Adapter<Object>(){

            public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
                DatabaseUpgradeTransactionIT.this.dbms.unregisterTransactionEventListener(DatabaseUpgradeTransactionIT.this.db.databaseName(), (TransactionEventListener)this);
                l2.release();
                l1.await();
                transaction.acquireWriteLock((Entity)transaction.getNodeByElementId(lockNode2));
                transaction.acquireWriteLock((Entity)transaction.getNodeByElementId(lockNode1));
                return null;
            }
        });
        try (OtherThreadExecutor executor = new OtherThreadExecutor("Executor");){
            Future f1 = executor.executeDontWait(this::createWriteTransaction);
            l2.await();
            this.set(LatestVersions.LATEST_RUNTIME_VERSION);
            try (Transaction tx = this.db.beginTx();){
                tx.acquireWriteLock((Entity)tx.getNodeByElementId(lockNode1));
                tx.createNode();
                l1.release();
                executor.waitUntilWaiting(details -> details.isAt(ForsetiClient.class, "acquireExclusive"));
                tx.commit();
            }
            executor.awaitFuture(f1);
        }
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithArguments("Upgrade transaction from %s to %s not possible right now due to conflicting transaction, will retry on next write", new Object[]{this.oldKernelVersion, LatestVersions.LATEST_KERNEL_VERSION}).doesNotContainMessageWithArguments("Upgrade transaction from %s to %s started", new Object[]{this.oldKernelVersion, LatestVersions.LATEST_KERNEL_VERSION});
        ((AbstractLongAssert)Assertions.assertThat((long)this.getNodeCount()).as("Both transactions succeeded", new Object[0])).isEqualTo(numNodesBefore + 2L);
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)this.oldKernelVersion);
        this.createWriteTransaction();
        Assertions.assertThat((Comparable)this.kernelVersion()).isEqualTo((Object)LatestVersions.LATEST_KERNEL_VERSION);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessageWithArguments("Upgrade transaction from %s to %s started", new Object[]{this.oldKernelVersion, LatestVersions.LATEST_KERNEL_VERSION}).containsMessageWithArguments("Upgrade transaction from %s to %s completed", new Object[]{this.oldKernelVersion, LatestVersions.LATEST_KERNEL_VERSION});
    }

    private long getNodeCount() {
        try (Transaction tx = this.db.beginTx();){
            long l = Iterables.count((Iterable)tx.getAllNodes());
            return l;
        }
    }

    private void createReadTransaction() {
        try (Transaction tx = this.db.beginTx();
             ResourceIterable allNodes = tx.getAllNodes();){
            allNodes.forEach(Entity::getAllProperties);
            tx.commit();
        }
    }

    protected String createWriteTransaction() {
        DeadlockDetectedException deadlockDetectedException = null;
        int i = 0;
        while (i < 10) {
            String string;
            block11: {
                Transaction tx = this.db.beginTx();
                try {
                    String nodeId = tx.createNode().getElementId();
                    tx.commit();
                    string = nodeId;
                    if (tx == null) break block11;
                }
                catch (Throwable nodeId) {
                    try {
                        if (tx != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                nodeId.addSuppressed(throwable);
                            }
                        }
                        throw nodeId;
                    }
                    catch (DeadlockDetectedException e) {
                        deadlockDetectedException = e;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException(ex);
                        }
                        ++i;
                    }
                }
                tx.close();
            }
            return string;
        }
        throw deadlockDetectedException;
    }

    protected void startDbms() {
        this.dbms = this.configure(this.getBuilder()).build();
        this.db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        this.systemDb = (GraphDatabaseAPI)this.dbms.database("system");
    }

    protected TestDatabaseManagementServiceBuilder getBuilder() {
        return new TestDatabaseManagementServiceBuilder();
    }

    private long lastCommittedTransactionId() {
        return this.get(this.db, TransactionIdStore.class).getLastCommittedTransactionId();
    }

    private KernelVersion kernelVersion() {
        return this.get(this.db, KernelVersionProvider.class).kernelVersion();
    }

    private DbmsRuntimeVersion dbmsRuntimeVersion() {
        return this.get(this.systemDb, DbmsRuntimeVersionProvider.class).getVersion();
    }

    protected <T> T get(GraphDatabaseAPI db, Class<T> cls) {
        return (T)db.getDependencyResolver().resolveDependency(cls);
    }

    protected void set(DbmsRuntimeVersion runtimeVersion) {
        try (Transaction tx = this.systemDb.beginTx();
             Stream nodes = tx.findNodes(SystemGraphComponent.VERSION_LABEL).stream();){
            nodes.forEach(dbmsRuntimeNode -> dbmsRuntimeNode.setProperty(ComponentVersion.DBMS_RUNTIME_COMPONENT.name(), (Object)runtimeVersion.getVersion()));
            tx.commit();
        }
    }

    private String createDenseNode() {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            String nodeId = node.getElementId();
            for (int i = 0; i < 100; ++i) {
                node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)("TYPE_" + i % 3)));
            }
            tx.commit();
            String string = nodeId;
            return string;
        }
    }

    private void assertDegrees(String nodeId) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.getNodeByElementId(nodeId);
            HashMap<RelationshipType, Map> actualDegrees = new HashMap<RelationshipType, Map>();
            Iterables.forEach((Iterable)node.getRelationships(), r -> actualDegrees.computeIfAbsent(r.getType(), t -> new HashMap()).computeIfAbsent(DatabaseUpgradeTransactionIT.directionOf(node, r), d -> new MutableLong()).increment());
            MutableLong actualTotalDegree = new MutableLong();
            actualDegrees.forEach((type, directions) -> {
                long actualTotalDirectionDegree = 0L;
                for (Map.Entry actualDirectionDegree : directions.entrySet()) {
                    Assertions.assertThat((int)node.getDegree(type, (Direction)actualDirectionDegree.getKey())).isEqualTo(((MutableLong)actualDirectionDegree.getValue()).longValue());
                    actualTotalDirectionDegree += ((MutableLong)actualDirectionDegree.getValue()).longValue();
                }
                Assertions.assertThat((int)node.getDegree(type)).isEqualTo(actualTotalDirectionDegree);
                actualTotalDegree.add(actualTotalDirectionDegree);
            });
            Assertions.assertThat((int)node.getDegree()).isEqualTo(actualTotalDegree.longValue());
        }
    }

    private static Direction directionOf(Node node, Relationship relationship) {
        return relationship.getStartNode().equals((Object)node) ? (relationship.getEndNode().equals((Object)node) ? Direction.BOTH : Direction.OUTGOING) : Direction.INCOMING;
    }
}

