/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class LabelRecoveryTest {
    @Inject
    private EphemeralFileSystemAbstraction filesystem;
    private GraphDatabaseService database;
    private DatabaseManagementService managementService;

    LabelRecoveryTest() {
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void shouldRecoverNodeWithDynamicLabelRecords() {
        Node node;
        this.managementService = new TestDatabaseManagementServiceBuilder().setFileSystem((FileSystemAbstraction)this.filesystem).build();
        this.database = this.managementService.database("neo4j");
        Label[] labels = new Label[]{Label.label((String)"a"), Label.label((String)"b"), Label.label((String)"c"), Label.label((String)"d"), Label.label((String)"e"), Label.label((String)"f"), Label.label((String)"g"), Label.label((String)"h"), Label.label((String)"i"), Label.label((String)"j"), Label.label((String)"k")};
        try (Transaction tx = this.database.beginTx();){
            node = tx.createNode(labels);
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            node = tx.getNodeById(node.getId());
            node.setProperty("prop", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        EphemeralFileSystemAbstraction snapshot = this.filesystem.snapshot();
        this.managementService.shutdown();
        this.managementService = new TestDatabaseManagementServiceBuilder().setFileSystem((FileSystemAbstraction)snapshot).build();
        this.database = this.managementService.database("neo4j");
        try (Transaction tx = this.database.beginTx();){
            node = tx.getNodeById(node.getId());
            for (Label label : labels) {
                Assertions.assertTrue((boolean)node.hasLabel(label));
            }
        }
    }
}

