/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.collections.api.set.ImmutableSet;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.BaseTestingIndexProvider;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.Barrier;
import org.neo4j.test.DoubleLatch;
import org.neo4j.values.ElementIdMapper;

public class ControlledPopulationIndexProvider
extends BaseTestingIndexProvider {
    private IndexPopulator mockedPopulator = new IndexPopulator.Adapter();
    private final IndexAccessor mockedWriter = (IndexAccessor)Mockito.mock(IndexAccessor.class);
    private final CountDownLatch writerLatch = new CountDownLatch(1);
    private InternalIndexState initialIndexState = InternalIndexState.POPULATING;
    final AtomicInteger populatorCallCount = new AtomicInteger();
    final AtomicInteger writerCallCount = new AtomicInteger();
    public static final IndexProviderDescriptor PROVIDER_DESCRIPTOR = new IndexProviderDescriptor("controlled-population", "1.0");

    public ControlledPopulationIndexProvider() {
        super(PROVIDER_DESCRIPTOR, IndexDirectoryStructure.NONE);
        this.setInitialIndexState(this.initialIndexState);
        Mockito.when((Object)this.mockedWriter.newValueReader((IndexUsageTracking)ArgumentMatchers.any())).thenReturn((Object)ValueIndexReader.EMPTY);
    }

    public Barrier.Control installPopulationLatch(final PopulationLatchMethod method) {
        final Barrier.Control barrier = new Barrier.Control();
        this.mockedPopulator = new IndexPopulator.Adapter(this){

            public void create() {
                if (method == PopulationLatchMethod.CREATE) {
                    barrier.reached();
                }
                super.create();
            }

            public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) {
                if (method == PopulationLatchMethod.ADD_BATCH) {
                    barrier.reached();
                }
                super.add(updates, cursorContext);
            }
        };
        return barrier;
    }

    public void awaitFullyPopulated() {
        DoubleLatch.awaitLatch((CountDownLatch)this.writerLatch);
    }

    public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup, ElementIdMapper elementIdMapper, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour) {
        this.populatorCallCount.incrementAndGet();
        return this.mockedPopulator;
    }

    public IndexAccessor getOnlineAccessor(IndexDescriptor indexConfig, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup, ElementIdMapper elementIdMapper, ImmutableSet<OpenOption> openOptions, boolean readOnly, StorageEngineIndexingBehaviour indexingBehaviour) {
        this.writerCallCount.incrementAndGet();
        this.writerLatch.countDown();
        return this.mockedWriter;
    }

    public MinimalIndexAccessor getMinimalIndexAccessor(IndexDescriptor descriptor, boolean forRebuildDuringRecovery) {
        return this.mockedWriter;
    }

    public InternalIndexState getInitialState(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) {
        return this.initialIndexState;
    }

    public void setInitialIndexState(InternalIndexState initialIndexState) {
        this.initialIndexState = initialIndexState;
    }

    public static enum PopulationLatchMethod {
        ADD_BATCH,
        CREATE;

    }
}

