/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.internal.helpers.NamedThreadFactory;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.core.EntityTest;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
public class NodeEntityTest
extends EntityTest {
    @Inject
    RandomSupport random;

    @Override
    protected long createEntity(Transaction tx) {
        return tx.createNode().getId();
    }

    @Override
    protected Entity lookupEntity(Transaction transaction, long id) {
        return transaction.getNodeById(id);
    }

    @Test
    void createDropNodeLongStringProperty(TestInfo testInfo) {
        Node node;
        Label markerLabel = Label.label((String)("marker_" + String.valueOf(testInfo.getTestMethod())));
        String testPropertyKey = "testProperty";
        String propertyValue = RandomStringUtils.randomAscii((int)255);
        try (Transaction tx = db.beginTx();){
            node = tx.createNode(new Label[]{markerLabel});
            node.setProperty(testPropertyKey, (Object)propertyValue);
            tx.commit();
        }
        tx = db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            org.junit.jupiter.api.Assertions.assertEquals((Object)propertyValue, (Object)node.getProperty(testPropertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            node.removeProperty(testPropertyKey);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)node.hasProperty(testPropertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void createDropNodeLongArrayProperty(TestInfo testInfo) {
        Node node;
        Label markerLabel = Label.label((String)("marker_" + String.valueOf(testInfo.getTestMethod())));
        String testPropertyKey = "testProperty";
        byte[] propertyValue = this.random.nextBytes(1024);
        try (Transaction tx = db.beginTx();){
            node = tx.createNode(new Label[]{markerLabel});
            node.setProperty(testPropertyKey, (Object)propertyValue);
            tx.commit();
        }
        tx = db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])propertyValue, (byte[])((byte[])node.getProperty(testPropertyKey)));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            node.removeProperty(testPropertyKey);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)node.hasProperty(testPropertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void deletionOfSameNodeTwiceInOneTransactionShouldNotRollbackIt() {
        Node node;
        try (Transaction tx = db.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        Exception exceptionThrownBySecondDelete = null;
        try (Transaction tx = db.beginTx();){
            tx.getNodeById(node.getId()).delete();
            try {
                tx.getNodeById(node.getId()).delete();
            }
            catch (Exception e) {
                exceptionThrownBySecondDelete = e;
            }
            tx.commit();
        }
        Assertions.assertThat((Throwable)exceptionThrownBySecondDelete).isInstanceOf(NotFoundException.class);
        org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> {
            try (Transaction tx = db.beginTx();){
                tx.getNodeById(node.getId());
                tx.commit();
            }
        });
    }

    @Test
    void deletionOfAlreadyDeletedNodeShouldThrow() {
        Node node;
        try (Transaction tx = db.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.getNodeById(node.getId()).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> {
            try (Transaction tx = db.beginTx();){
                tx.getNodeById(node.getId()).delete();
                tx.commit();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void getAllPropertiesShouldWorkFineWithConcurrentPropertyModifications() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(2, (ThreadFactory)NamedThreadFactory.named((String)"Test-executor-thread"));
        try {
            long nodeId;
            int propertiesCount = 100;
            try (Transaction tx = db.beginTx();){
                Node node = tx.createNode();
                nodeId = node.getId();
                for (int i = 0; i < 100; ++i) {
                    node.setProperty("property-" + i, (Object)i);
                }
                tx.commit();
            }
            CountDownLatch start = new CountDownLatch(1);
            AtomicBoolean writerDone = new AtomicBoolean();
            Runnable writer = () -> {
                try {
                    DoubleLatch.awaitLatch((CountDownLatch)start);
                    int propertyKey = 0;
                    while (propertyKey < 100) {
                        Transaction tx = db.beginTx();
                        try {
                            Node node = tx.getNodeById(nodeId);
                            for (int i = 0; i < 10 && propertyKey < 100; ++i, ++propertyKey) {
                                node.setProperty("property-" + propertyKey, (Object)UUID.randomUUID().toString());
                            }
                            tx.commit();
                        }
                        finally {
                            if (tx == null) continue;
                            tx.close();
                        }
                    }
                }
                finally {
                    writerDone.set(true);
                }
            };
            Runnable reader = () -> {
                try (Transaction tx = db.beginTx();){
                    Node node = tx.getNodeById(nodeId);
                    DoubleLatch.awaitLatch((CountDownLatch)start);
                    while (!writerDone.get()) {
                        int size = node.getAllProperties().size();
                        Assertions.assertThat((int)size).isGreaterThan(0);
                    }
                    tx.commit();
                }
            };
            Future<?> readerFuture = executor.submit(reader);
            Future<?> writerFuture = executor.submit(writer);
            start.countDown();
            writerFuture.get();
            readerFuture.get();
            try (Transaction tx = db.beginTx();){
                org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)tx.getNodeById(nodeId).getAllProperties().size());
                tx.commit();
            }
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    void shouldBeAbleToForceTypeChangeOfProperty() {
        Node node;
        try (Transaction tx = db.beginTx();){
            node = tx.createNode();
            node.setProperty("prop", (Object)1337);
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.getNodeById(node.getId()).setProperty("prop", (Object)1337.0);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            Assertions.assertThat((Object)tx.getNodeById(node.getId()).getProperty("prop")).isInstanceOf(Double.class);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowCorrectExceptionOnLabelTokensExceeded() throws KernelException {
        InternalTransaction transaction = NodeEntityTest.mockedTransactionWithDepletedTokens();
        NodeEntity nodeEntity = new NodeEntity(transaction, 5L);
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> nodeEntity.addLabel(Label.label((String)"Label")));
    }

    @Test
    void shouldThrowCorrectExceptionOnPropertyKeyTokensExceeded() throws KernelException {
        NodeEntity nodeEntity = new NodeEntity(NodeEntityTest.mockedTransactionWithDepletedTokens(), 5L);
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> nodeEntity.setProperty("key", (Object)"value"));
    }

    @Test
    void shouldThrowCorrectExceptionOnRelationshipTypeTokensExceeded() throws KernelException {
        InternalTransaction transaction = NodeEntityTest.mockedTransactionWithDepletedTokens();
        NodeEntity nodeEntity = new NodeEntity(transaction, 5L);
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> nodeEntity.createRelationshipTo((Node)new NodeEntity(transaction, 6L), RelationshipType.withName((String)"type")));
    }

    @Test
    void shouldWorkWithNodeElementIds() {
        String nodeId2;
        Node node2;
        String nodeId1;
        Node node1;
        try (Transaction tx = db.beginTx();){
            node1 = tx.createNode();
            node1.setProperty("name", (Object)"Node 1");
            nodeId1 = node1.getElementId();
            node2 = tx.createNode();
            node2.setProperty("name", (Object)"Node 2");
            nodeId2 = node2.getElementId();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            node1 = tx.getNodeByElementId(nodeId1);
            node2 = tx.getNodeByElementId(nodeId2);
            Assertions.assertThat((Object)node1.getProperty("name")).isEqualTo((Object)"Node 1");
            Assertions.assertThat((Object)node2.getProperty("name")).isEqualTo((Object)"Node 2");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void nodeNotFoundByElementId() {
        String elementId;
        try (Transaction transaction = db.beginTx();){
            Node node = transaction.createNode();
            elementId = node.getElementId();
            transaction.rollback();
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (Transaction tx = db.beginTx();){
                tx.getNodeByElementId(elementId);
            }
        }).isInstanceOf(NotFoundException.class)).hasMessageContaining(elementId + " not found").hasRootCauseInstanceOf(EntityNotFoundException.class).rootCause().hasMessageContaining("Unable to load NODE " + elementId);
    }

    @Test
    void shouldWorkWithRelationshipElementIds() {
        String relationshipId2;
        Relationship relationship2;
        String relationshipId1;
        Relationship relationship1;
        try (Transaction tx = db.beginTx();){
            relationship1 = tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"KNOWS"));
            relationship1.setProperty("name", (Object)"Relationship 1");
            relationshipId1 = relationship1.getElementId();
            relationship2 = tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"KNOWS"));
            relationship2.setProperty("name", (Object)"Relationship 2");
            relationshipId2 = relationship2.getElementId();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            relationship1 = tx.getRelationshipByElementId(relationshipId1);
            relationship2 = tx.getRelationshipByElementId(relationshipId2);
            Assertions.assertThat((Object)relationship1.getProperty("name")).isEqualTo((Object)"Relationship 1");
            Assertions.assertThat((Object)relationship2.getProperty("name")).isEqualTo((Object)"Relationship 2");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowCorrectExceptionOnTokensTransientFailureCreateNode() throws KernelException {
        InternalTransaction transaction = NodeEntityTest.transactionWithTransientlyFailingTokenWrite();
        org.junit.jupiter.api.Assertions.assertThrows(TransientTransactionFailureException.class, () -> transaction.createNode(new Label[]{Label.label((String)"label")}));
    }

    @Test
    void shouldThrowCorrectExceptionOnTokensTransientFailureAddLabel() throws KernelException {
        InternalTransaction transaction = NodeEntityTest.transactionWithTransientlyFailingTokenWrite();
        NodeEntity nodeEntity = new NodeEntity(transaction, 5L);
        org.junit.jupiter.api.Assertions.assertThrows(TransientTransactionFailureException.class, () -> nodeEntity.addLabel(Label.label((String)"Label")));
    }

    @Test
    void shouldThrowCorrectExceptionOnTokensTransientFailureSetProperty() throws KernelException {
        NodeEntity nodeEntity = new NodeEntity(NodeEntityTest.transactionWithTransientlyFailingTokenWrite(), 5L);
        org.junit.jupiter.api.Assertions.assertThrows(TransientTransactionFailureException.class, () -> nodeEntity.setProperty("key", (Object)"value"));
    }

    @Test
    void shouldThrowCorrectExceptionOnTokensTransientFailureCreateRelationship() throws KernelException {
        InternalTransaction transaction = NodeEntityTest.transactionWithTransientlyFailingTokenWrite();
        NodeEntity nodeEntity = new NodeEntity(transaction, 5L);
        org.junit.jupiter.api.Assertions.assertThrows(TransientTransactionFailureException.class, () -> nodeEntity.createRelationshipTo((Node)new NodeEntity(transaction, 6L), RelationshipType.withName((String)"type")));
    }
}

