/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.PartitionedScanFactories;
import org.neo4j.kernel.impl.newapi.PartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.TokenIndexScanPartitionedScanTestSuite;
import org.neo4j.test.Tokens;

abstract class NodeLabelIndexScanPartitionedScanTestSuite
extends TokenIndexScanPartitionedScanTestSuite<NodeLabelIndexCursor> {
    NodeLabelIndexScanPartitionedScanTestSuite() {
    }

    public final PartitionedScanFactories.NodeLabelIndexScan getFactory() {
        return PartitionedScanFactories.NodeLabelIndexScan.FACTORY;
    }

    @Nested
    class WithData
    extends TokenIndexScanPartitionedScanTestSuite.WithData<NodeLabelIndexCursor> {
        WithData(NodeLabelIndexScanPartitionedScanTestSuite this$0) {
            super(this$0);
        }

        @Override
        PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> setupDatabase() {
            long numberOfNodes = 262144L;
            SortedMap<Integer, List<PartitionedScanTestSuite.Range>> labelRanges = this.tokenRangesFromTokenId(Tokens.Suppliers.UUID.LABEL, this.createTokenRanges(262144L));
            return this.createData(262144L, labelRanges);
        }

        @Override
        PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> createData(long numberOfNodes, SortedMap<Integer, List<PartitionedScanTestSuite.Range>> labelRanges) {
            KernelTransaction tx;
            PartitionedScanTestSuite.EntityIdsMatchingQuery<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> nodesWithLabelId = new PartitionedScanTestSuite.EntityIdsMatchingQuery<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery>();
            String indexName = this.getTokenIndexName(EntityType.NODE);
            labelRanges.keySet().forEach(labelId -> nodesWithLabelId.getOrCreate(new TokenIndexScanPartitionedScanTestSuite.TokenScanQuery(indexName, new TokenPredicate(labelId.intValue()))));
            try {
                tx = this.beginTx();
                try {
                    Write write = tx.dataWrite();
                    int i = 0;
                    while ((long)i < numberOfNodes) {
                        int labelId2;
                        long nodeId = write.nodeCreate();
                        int nodeCreated = i;
                        int[] potentialLabelIds = labelRanges.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(range -> range.contains(nodeCreated))).mapToInt(Map.Entry::getKey).toArray();
                        if (potentialLabelIds.length > 0 && write.nodeAddLabel(nodeId, labelId2 = this.random.among(potentialLabelIds))) {
                            nodesWithLabelId.getOrCreate(new TokenIndexScanPartitionedScanTestSuite.TokenScanQuery(indexName, new TokenPredicate(labelId2))).add(nodeId);
                        }
                        ++i;
                    }
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            catch (Exception e) {
                throw new AssertionError("failed to create database", e);
            }
            try {
                tx = this.beginTx();
                try {
                    ((AbstractLongAssert)Assertions.assertThat((long)tx.dataRead().nodesGetCount()).as("nodes created", new Object[0])).isEqualTo(numberOfNodes);
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            catch (Exception e) {
                throw new AssertionError("failed to count number of nodes", e);
            }
            return new PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery>(nodesWithLabelId);
        }
    }

    @Nested
    class WithoutData
    extends TokenIndexScanPartitionedScanTestSuite.WithoutData<NodeLabelIndexCursor> {
        WithoutData(NodeLabelIndexScanPartitionedScanTestSuite this$0) {
            super(this$0);
        }

        @Override
        PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> setupDatabase() {
            int numberOfLabels = 3;
            int[] labelIds = this.createTokens(3, Tokens.Suppliers.UUID.LABEL);
            return this.emptyQueries(EntityType.NODE, labelIds);
        }
    }
}

