/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.PartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.PropertyIndexScanPartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.PropertyIndexSeekPartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.TokenIndexScanPartitionedScanTestSuite;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.Tokens;

class PartitionedScanFactories {
    PartitionedScanFactories() {
    }

    @FunctionalInterface
    static interface CursorWithContext<CURSOR extends Cursor> {
        public CURSOR with(CursorContext var1);
    }

    static final class RelationshipPropertyIndexScan
    extends PropertyIndex<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery, RelationshipValueIndexCursor> {
        public static final RelationshipPropertyIndexScan FACTORY = new RelationshipPropertyIndexScan();

        private RelationshipPropertyIndexScan() {
        }

        NodePropertyIndexScan getEntityTypeComplimentFactory() {
            return NodePropertyIndexScan.FACTORY;
        }

        @Override
        PartitionedScan<RelationshipValueIndexCursor> partitionedScan(KernelTransaction tx, IndexReadSession session, int desiredNumberOfPartitions, PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery propertyKeyScanQuery) throws KernelException {
            return tx.dataRead().relationshipIndexScan(session, desiredNumberOfPartitions, QueryContext.NULL_CONTEXT);
        }

        @Override
        CursorWithContext<RelationshipValueIndexCursor> getCursor(CursorFactory cursors) {
            return context -> cursors.allocateRelationshipValueIndexCursor(context, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }

        @Override
        long getEntityReference(RelationshipValueIndexCursor cursor) {
            return cursor.relationshipReference();
        }

        Tokens.Suppliers.RelationshipType getTokenSupplier() {
            return Tokens.Suppliers.UUID.RELATIONSHIP_TYPE;
        }

        @Override
        SchemaDescriptor getSchemaDescriptor(int relTypeId, int ... propKeyIds) {
            return SchemaDescriptors.forRelType((int)relTypeId, (int[])propKeyIds);
        }
    }

    static final class RelationshipPropertyIndexSeek
    extends PropertyIndex<PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery, RelationshipValueIndexCursor> {
        public static final RelationshipPropertyIndexSeek FACTORY = new RelationshipPropertyIndexSeek();

        private RelationshipPropertyIndexSeek() {
        }

        NodePropertyIndexSeek getEntityTypeComplimentFactory() {
            return NodePropertyIndexSeek.FACTORY;
        }

        @Override
        PartitionedScan<RelationshipValueIndexCursor> partitionedScan(KernelTransaction tx, IndexReadSession session, int desiredNumberOfPartitions, PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery propertyKeySeekQuery) throws KernelException {
            return tx.dataRead().relationshipIndexSeek(session, desiredNumberOfPartitions, QueryContext.NULL_CONTEXT, propertyKeySeekQuery.get());
        }

        @Override
        CursorWithContext<RelationshipValueIndexCursor> getCursor(CursorFactory cursors) {
            return context -> cursors.allocateRelationshipValueIndexCursor(context, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }

        @Override
        long getEntityReference(RelationshipValueIndexCursor cursor) {
            return cursor.relationshipReference();
        }

        Tokens.Suppliers.RelationshipType getTokenSupplier() {
            return Tokens.Suppliers.UUID.RELATIONSHIP_TYPE;
        }

        @Override
        SchemaDescriptor getSchemaDescriptor(int relTypeId, int ... propKeyIds) {
            return SchemaDescriptors.forRelType((int)relTypeId, (int[])propKeyIds);
        }
    }

    static final class NodePropertyIndexScan
    extends PropertyIndex<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery, NodeValueIndexCursor> {
        public static final NodePropertyIndexScan FACTORY = new NodePropertyIndexScan();

        private NodePropertyIndexScan() {
        }

        RelationshipPropertyIndexScan getEntityTypeComplimentFactory() {
            return RelationshipPropertyIndexScan.FACTORY;
        }

        @Override
        PartitionedScan<NodeValueIndexCursor> partitionedScan(KernelTransaction tx, IndexReadSession session, int desiredNumberOfPartitions, PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery propertyKeyScanQuery) throws KernelException {
            return tx.dataRead().nodeIndexScan(session, desiredNumberOfPartitions, QueryContext.NULL_CONTEXT);
        }

        @Override
        CursorWithContext<NodeValueIndexCursor> getCursor(CursorFactory cursors) {
            return context -> cursors.allocateNodeValueIndexCursor(context, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }

        @Override
        long getEntityReference(NodeValueIndexCursor cursor) {
            return cursor.nodeReference();
        }

        Tokens.Suppliers.Label getTokenSupplier() {
            return Tokens.Suppliers.UUID.LABEL;
        }

        @Override
        SchemaDescriptor getSchemaDescriptor(int labelId, int ... propKeyIds) {
            return SchemaDescriptors.forLabel((int)labelId, (int[])propKeyIds);
        }
    }

    static final class NodePropertyIndexSeek
    extends PropertyIndex<PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery, NodeValueIndexCursor> {
        public static final NodePropertyIndexSeek FACTORY = new NodePropertyIndexSeek();

        private NodePropertyIndexSeek() {
        }

        RelationshipPropertyIndexSeek getEntityTypeComplimentFactory() {
            return RelationshipPropertyIndexSeek.FACTORY;
        }

        @Override
        PartitionedScan<NodeValueIndexCursor> partitionedScan(KernelTransaction tx, IndexReadSession session, int desiredNumberOfPartitions, PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery propertyKeySeekQuery) throws KernelException {
            return tx.dataRead().nodeIndexSeek(session, desiredNumberOfPartitions, QueryContext.NULL_CONTEXT, propertyKeySeekQuery.get());
        }

        @Override
        CursorWithContext<NodeValueIndexCursor> getCursor(CursorFactory cursors) {
            return context -> cursors.allocateNodeValueIndexCursor(context, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }

        @Override
        long getEntityReference(NodeValueIndexCursor cursor) {
            return cursor.nodeReference();
        }

        Tokens.Suppliers.Label getTokenSupplier() {
            return Tokens.Suppliers.UUID.LABEL;
        }

        @Override
        SchemaDescriptor getSchemaDescriptor(int labelId, int ... propKeyIds) {
            return SchemaDescriptors.forLabel((int)labelId, (int[])propKeyIds);
        }
    }

    static abstract class PropertyIndex<QUERY extends PartitionedScanTestSuite.Query<?>, CURSOR extends Cursor>
    extends PartitionedScanFactory<QUERY, IndexReadSession, CURSOR> {
        PropertyIndex() {
        }

        abstract SchemaDescriptor getSchemaDescriptor(int var1, int ... var2);

        abstract Tokens.Suppliers.Supplier<?> getTokenSupplier();

        final Tokens.Suppliers.PropertyKey getPropKeySupplier() {
            return Tokens.Suppliers.UUID.PROPERTY_KEY;
        }

        final String getIndexName(int tokenId, int ... propKeyIds) {
            return String.format("%s[%s[%d] {%s}]", this.name(), this.getTokenSupplier().name(), tokenId, Arrays.stream(propKeyIds).mapToObj(String::valueOf).collect(Collectors.joining(",")));
        }

        @Override
        protected final IndexReadSession getSession(KernelTransaction tx, String indexName) throws KernelException {
            IndexDescriptor index = tx.schemaRead().indexGetForName(indexName);
            return tx.dataRead().indexReadSession(index);
        }

        protected final IndexDescriptor getIndex(KernelTransaction tx, String name) {
            return tx.schemaRead().indexGetForName(name);
        }

        protected final IndexDescriptor getIndex(KernelTransaction tx, int tokenId, int ... propKeyIds) {
            return this.getIndex(tx, this.getIndexName(tokenId, propKeyIds));
        }
    }

    static final class RelationshipTypeIndexScan
    extends TokenIndex<RelationshipTypeIndexCursor> {
        public static final RelationshipTypeIndexScan FACTORY = new RelationshipTypeIndexScan();

        private RelationshipTypeIndexScan() {
        }

        NodeLabelIndexScan getEntityTypeComplimentFactory() {
            return NodeLabelIndexScan.FACTORY;
        }

        @Override
        PartitionedScan<RelationshipTypeIndexCursor> partitionedScan(KernelTransaction tx, TokenReadSession session, int desiredNumberOfPartitions, TokenIndexScanPartitionedScanTestSuite.TokenScanQuery tokenScanQuery) throws KernelException {
            return tx.dataRead().relationshipTypeScan(session, desiredNumberOfPartitions, CursorContext.NULL_CONTEXT, tokenScanQuery.get());
        }

        @Override
        CursorWithContext<RelationshipTypeIndexCursor> getCursor(CursorFactory cursors) {
            return arg_0 -> ((CursorFactory)cursors).allocateRelationshipTypeIndexCursor(arg_0);
        }

        @Override
        long getEntityReference(RelationshipTypeIndexCursor cursor) {
            return cursor.relationshipReference();
        }

        @Override
        PartitionedScan<RelationshipTypeIndexCursor> partitionedScan(KernelTransaction tx, TokenReadSession session, PartitionedScan<RelationshipTypeIndexCursor> leadingPartitionScan, TokenIndexScanPartitionedScanTestSuite.TokenScanQuery query) throws KernelException {
            return tx.dataRead().relationshipTypeScan(session, leadingPartitionScan, query.get());
        }

        @Override
        List<PartitionedScan<RelationshipTypeIndexCursor>> partitionedScans(KernelTransaction tx, TokenReadSession session, int desiredNumberOfPartitions, List<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> queries) throws KernelException {
            return tx.dataRead().relationshipTypeScans(session, desiredNumberOfPartitions, CursorContext.NULL_CONTEXT, (TokenPredicate[])queries.stream().map(TokenIndexScanPartitionedScanTestSuite.TokenScanQuery::get).toArray(TokenPredicate[]::new));
        }
    }

    static final class NodeLabelIndexScan
    extends TokenIndex<NodeLabelIndexCursor> {
        public static final NodeLabelIndexScan FACTORY = new NodeLabelIndexScan();

        private NodeLabelIndexScan() {
        }

        RelationshipTypeIndexScan getEntityTypeComplimentFactory() {
            return RelationshipTypeIndexScan.FACTORY;
        }

        @Override
        PartitionedScan<NodeLabelIndexCursor> partitionedScan(KernelTransaction tx, TokenReadSession session, int desiredNumberOfPartitions, TokenIndexScanPartitionedScanTestSuite.TokenScanQuery tokenScanQuery) throws KernelException {
            return tx.dataRead().nodeLabelScan(session, desiredNumberOfPartitions, CursorContext.NULL_CONTEXT, tokenScanQuery.get());
        }

        @Override
        CursorWithContext<NodeLabelIndexCursor> getCursor(CursorFactory cursors) {
            return arg_0 -> ((CursorFactory)cursors).allocateNodeLabelIndexCursor(arg_0);
        }

        @Override
        long getEntityReference(NodeLabelIndexCursor cursor) {
            return cursor.nodeReference();
        }

        @Override
        PartitionedScan<NodeLabelIndexCursor> partitionedScan(KernelTransaction tx, TokenReadSession session, PartitionedScan<NodeLabelIndexCursor> leadingPartitionScan, TokenIndexScanPartitionedScanTestSuite.TokenScanQuery query) throws KernelException {
            return tx.dataRead().nodeLabelScan(session, leadingPartitionScan, query.get());
        }

        @Override
        List<PartitionedScan<NodeLabelIndexCursor>> partitionedScans(KernelTransaction tx, TokenReadSession session, int desiredNumberOfPartitions, List<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> queries) throws KernelException {
            return tx.dataRead().nodeLabelScans(session, desiredNumberOfPartitions, CursorContext.NULL_CONTEXT, (TokenPredicate[])queries.stream().map(TokenIndexScanPartitionedScanTestSuite.TokenScanQuery::get).toArray(TokenPredicate[]::new));
        }
    }

    static abstract class TokenIndex<CURSOR extends Cursor>
    extends PartitionedScanFactory<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery, TokenReadSession, CURSOR> {
        TokenIndex() {
        }

        abstract PartitionedScan<CURSOR> partitionedScan(KernelTransaction var1, TokenReadSession var2, PartitionedScan<CURSOR> var3, TokenIndexScanPartitionedScanTestSuite.TokenScanQuery var4) throws KernelException;

        abstract List<PartitionedScan<CURSOR>> partitionedScans(KernelTransaction var1, TokenReadSession var2, int var3, List<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> var4) throws KernelException;

        protected final PartitionedScan<CURSOR> partitionedScan(KernelTransaction tx, PartitionedScan<CURSOR> leadingPartitionScan, TokenIndexScanPartitionedScanTestSuite.TokenScanQuery query) throws KernelException {
            return this.partitionedScan(tx, this.getSession(tx, query.indexName()), leadingPartitionScan, query);
        }

        protected final List<PartitionedScan<CURSOR>> partitionedScans(KernelTransaction tx, int desiredNumberOfPartitions, List<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> queries) throws KernelException {
            assert (queries.stream().map(TokenIndexScanPartitionedScanTestSuite.TokenScanQuery::indexName).distinct().count() == 1L);
            return this.partitionedScans(tx, this.getSession(tx, queries.get(0).indexName()), desiredNumberOfPartitions, queries);
        }

        @Override
        protected final TokenReadSession getSession(KernelTransaction tx, String indexName) throws KernelException {
            IndexDescriptor index = tx.schemaRead().indexGetForName(indexName);
            return tx.dataRead().tokenReadSession(index);
        }
    }

    static abstract class PartitionedScanFactory<QUERY extends PartitionedScanTestSuite.Query<?>, SESSION, CURSOR extends Cursor> {
        PartitionedScanFactory() {
        }

        abstract PartitionedScanFactory<QUERY, SESSION, ? extends Cursor> getEntityTypeComplimentFactory();

        abstract SESSION getSession(KernelTransaction var1, String var2) throws KernelException;

        abstract CursorWithContext<CURSOR> getCursor(CursorFactory var1);

        abstract long getEntityReference(CURSOR var1);

        abstract PartitionedScan<CURSOR> partitionedScan(KernelTransaction var1, SESSION var2, int var3, QUERY var4) throws KernelException;

        final PartitionedScan<CURSOR> partitionedScan(KernelTransaction tx, int desiredNumberOfPartitions, QUERY query) throws KernelException {
            return this.partitionedScan(tx, this.getSession(tx, query.indexName()), desiredNumberOfPartitions, query);
        }

        final String name() {
            return this.getClass().getSimpleName();
        }
    }
}

