/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.internal.config.MEMORY_TRACKING;
import org.neo4j.cypher.internal.config.MemoryTracking;
import org.neo4j.cypher.internal.runtime.memory.MemoryTrackerForOperatorProvider;
import org.neo4j.cypher.internal.runtime.memory.QueryMemoryTracker;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.QueryRegistry;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QueryObfuscator;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.FacadeKernelTransactionFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.KernelTransactionFactory;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.statistic.StatisticProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.HeapHighWaterMarkTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.builtin.TransactionId;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.util.concurrent.BinaryLatch;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

@ImpermanentDbmsExtension
class Neo4jTransactionalContextIT {
    @Inject
    private DatabaseManagementService dbms;
    @Inject
    private GraphDatabaseAPI databaseAPI;
    @Inject
    private GraphDatabaseQueryService graph;
    private KernelTransactionFactory transactionFactory;

    Neo4jTransactionalContextIT() {
    }

    private long getPageCacheHits(TransactionalContext ctx) {
        return ctx.transaction().kernelTransaction().executionStatistics().pageHits();
    }

    private long getPageCacheFaults(TransactionalContext ctx) {
        return ctx.transaction().kernelTransaction().executionStatistics().pageFaults();
    }

    private void generatePageCacheHits(TransactionalContext ctx) {
        long previousCacheHits = this.getPageCacheHits(ctx);
        Iterables.count((Iterable)ctx.transaction().getAllNodes());
        long laterCacheHits = this.getPageCacheHits(ctx);
        ((AbstractLongAssert)Assertions.assertThat((long)laterCacheHits).as("Assuming generatePageCacheHits to generate some page cache hits", new Object[0])).isGreaterThan(previousCacheHits);
    }

    private void generatePageCacheHitsOnCommit(TransactionalContext ctx) {
        ctx.transaction().createNode();
    }

    private long createNodeAndRecordNumberOfPageHits() {
        InternalTransaction tx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(tx);
        ExecutingQuery executingQuery = ctx.executingQuery();
        ctx.transaction().createNode();
        ctx.commit();
        long pageHits = executingQuery.snapshot().pageHits();
        Assertions.assertThat((long)pageHits).isGreaterThan(0L);
        return pageHits;
    }

    private void getLocks(TransactionalContext ctx, String label) {
        try (ResourceIterator nodes = ctx.transaction().findNodes(Label.label((String)label));){
            nodes.stream().forEach(Node::delete);
        }
    }

    private long getActiveLockCount(TransactionalContext ctx) {
        return ((KernelStatement)ctx.statement()).locks().activeLockCount();
    }

    private boolean isMarkedForTermination(TransactionalContext ctx) {
        return ctx.transaction().terminationReason().isPresent();
    }

    private TransactionalContext createTransactionContext(InternalTransaction transaction) {
        return Neo4jTransactionalContextFactory.create(() -> this.graph, (KernelTransactionFactory)this.transactionFactory, (TransactionalContext.DatabaseMode)TransactionalContext.DatabaseMode.SINGLE).newContext(transaction, "no query", VirtualValues.EMPTY_MAP, QueryExecutionConfiguration.DEFAULT_CONFIG);
    }

    @BeforeEach
    void setup() {
        this.transactionFactory = new FacadeKernelTransactionFactory(Config.newBuilder().build(), (GraphDatabaseFacade)this.databaseAPI);
    }

    @Test
    void nestedQueriesWithExceptionsShouldCleanUpProperly() throws KernelException {
        ((GlobalProcedures)this.databaseAPI.getDependencyResolver().resolveDependency(GlobalProcedures.class)).registerProcedure(Procedures.class);
        InternalTransaction tx = this.graph.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        QueryExecutionException exception = (QueryExecutionException)org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> tx.execute("CREATE (c) WITH c CALL test.failingProc()"));
        this.assertNoSuppressedExceptions((Throwable)exception);
        this.assertAllCauses((Throwable)exception, e -> e.getMessage().contains("/ by zero"));
    }

    private void assertAllCauses(Throwable t, Predicate<Throwable> predicate) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)predicate.test(t), (String)("Predicate failed on " + String.valueOf(t)));
        if (t.getCause() != null) {
            this.assertAllCauses(t.getCause(), predicate);
        }
    }

    private void assertNoSuppressedExceptions(Throwable t) {
        if (t.getSuppressed().length > 0) {
            org.junit.jupiter.api.Assertions.fail((String)("Expected no suppressed exceptions. Got: " + Arrays.toString(t.getSuppressed())));
        }
        if (t.getCause() != null) {
            this.assertNoSuppressedExceptions(t.getCause());
        }
    }

    @Test
    void contextWithNewTransactionExecutingQueryShouldUseOuterTransactionIdAndQueryText() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        String queryText = "<query text>";
        TransactionalContext outerCtx = Neo4jTransactionalContextFactory.create(() -> this.graph, (KernelTransactionFactory)this.transactionFactory, (TransactionalContext.DatabaseMode)TransactionalContext.DatabaseMode.SINGLE).newContext(outerTx, queryText, MapValue.EMPTY, QueryExecutionConfiguration.DEFAULT_CONFIG);
        ExecutingQuery executingQuery = outerCtx.executingQuery();
        TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
        Assertions.assertThat((Object)executingQuery).isSameAs((Object)innerCtx.executingQuery());
        Assertions.assertThat((String)executingQuery.rawQueryText()).isEqualTo(queryText);
        QuerySnapshot snapshot = executingQuery.snapshot();
        Assertions.assertThat((long)snapshot.transactionSequenceNumber()).isEqualTo(outerTx.kernelTransaction().getTransactionSequenceNumber());
    }

    @Test
    void contextWithNewTransactionExecutingQueryShouldSumUpPageHitsFaultsFromInnerAndOuterTransaction() {
        this.databaseAPI.executeTransactionally("CREATE (n)");
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        ExecutingQuery executingQuery = outerCtx.executingQuery();
        this.generatePageCacheHits(outerCtx);
        long outerHits = this.getPageCacheHits(outerCtx);
        long outerFaults = this.getPageCacheFaults(outerCtx);
        TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
        this.generatePageCacheHits(innerCtx);
        long innerHits = this.getPageCacheHits(innerCtx);
        long innerFaults = this.getPageCacheFaults(innerCtx);
        QuerySnapshot snapshot = executingQuery.snapshot();
        Assertions.assertThat((long)snapshot.pageHits()).isEqualTo(outerHits + innerHits);
        Assertions.assertThat((long)snapshot.pageFaults()).isEqualTo(outerFaults + innerFaults);
    }

    @Test
    void contextWithNewTransactionExecutingQueryShouldSumUpPageHitsFaultsFromInnerAndOuterTransactionsAlsoWhenCommitted() {
        long numHitsForCreateNode = this.createNodeAndRecordNumberOfPageHits();
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        ExecutingQuery executingQuery = outerCtx.executingQuery();
        this.generatePageCacheHits(outerCtx);
        long outerHits = this.getPageCacheHits(outerCtx);
        long outerFaults = this.getPageCacheFaults(outerCtx);
        long closedInnerHits = 0L;
        long closedInnerFaults = 0L;
        long expectedInnerCommitHits = 0L;
        int numInnerContexts = 10;
        for (int i = 0; i < numInnerContexts; ++i) {
            TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
            if (i % 2 == 0) {
                this.generatePageCacheHits(innerCtx);
                this.generatePageCacheHitsOnCommit(innerCtx);
                expectedInnerCommitHits += numHitsForCreateNode;
            }
            closedInnerHits += this.getPageCacheHits(innerCtx);
            closedInnerFaults += this.getPageCacheFaults(innerCtx);
            innerCtx.commit();
        }
        TransactionalContext openInnerCtx = outerCtx.contextWithNewTransaction();
        this.generatePageCacheHits(openInnerCtx);
        long openInnerHits = this.getPageCacheHits(openInnerCtx);
        long openInnerFaults = this.getPageCacheFaults(openInnerCtx);
        QuerySnapshot snapshot = executingQuery.snapshot();
        long pageHits = snapshot.pageHits();
        Assertions.assertThat((long)pageHits).isEqualTo(outerHits + closedInnerHits + openInnerHits + expectedInnerCommitHits);
        Assertions.assertThat((long)snapshot.pageFaults()).isEqualTo(outerFaults + closedInnerFaults + openInnerFaults);
        Assertions.assertThat((long)pageHits).isGreaterThanOrEqualTo((long)(numInnerContexts / 2));
    }

    @Test
    void contextWithNewTransactionKernelStatisticsProviderShouldOnlySeePageHitsFaultsFromCurrentTransactionsAndInnerTransactionCommitsInPROFILE() {
        long numHitsForCreateNode = this.createNodeAndRecordNumberOfPageHits();
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        this.generatePageCacheHits(outerCtx);
        long outerHits = this.getPageCacheHits(outerCtx);
        long outerFaults = this.getPageCacheFaults(outerCtx);
        long expectedInnerCommitHits = 0L;
        int numInnerContexts = 10;
        for (int i = 0; i < numInnerContexts; ++i) {
            TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
            if (i % 2 == 0) {
                this.generatePageCacheHits(innerCtx);
                this.generatePageCacheHitsOnCommit(innerCtx);
                expectedInnerCommitHits += numHitsForCreateNode;
            }
            innerCtx.commit();
        }
        TransactionalContext openInnerCtx = outerCtx.contextWithNewTransaction();
        this.generatePageCacheHits(openInnerCtx);
        long openInnerHits = this.getPageCacheHits(openInnerCtx);
        long openInnerFaults = this.getPageCacheFaults(openInnerCtx);
        StatisticProvider outerProfileStatisticsProvider = outerCtx.kernelStatisticProvider();
        StatisticProvider innerProfileStatisticsProvider = openInnerCtx.kernelStatisticProvider();
        Assertions.assertThat((long)outerProfileStatisticsProvider.getPageCacheHits()).isEqualTo(outerHits + expectedInnerCommitHits);
        Assertions.assertThat((long)outerProfileStatisticsProvider.getPageCacheMisses()).isEqualTo(outerFaults);
        long pageHits = innerProfileStatisticsProvider.getPageCacheHits();
        Assertions.assertThat((long)pageHits).isEqualTo(openInnerHits + expectedInnerCommitHits);
        Assertions.assertThat((long)innerProfileStatisticsProvider.getPageCacheMisses()).isEqualTo(openInnerFaults);
        Assertions.assertThat((long)pageHits).isGreaterThanOrEqualTo((long)(numInnerContexts / 2));
    }

    @Test
    void contextWithNewTransactionExecutingQueryShouldSumUpPageHitsFaultsFromInnerAndOuterTransactionsAlsoWhenRolledBack() {
        this.databaseAPI.executeTransactionally("CREATE (n)");
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        ExecutingQuery executingQuery = outerCtx.executingQuery();
        this.generatePageCacheHits(outerCtx);
        long outerHits = this.getPageCacheHits(outerCtx);
        long outerFaults = this.getPageCacheFaults(outerCtx);
        long closedInnerHits = 0L;
        long closedInnerFaults = 0L;
        for (int i = 0; i < 10; ++i) {
            TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
            if (i % 2 == 0) {
                this.generatePageCacheHits(innerCtx);
            }
            closedInnerHits += this.getPageCacheHits(innerCtx);
            closedInnerFaults += this.getPageCacheFaults(innerCtx);
            innerCtx.rollback();
        }
        TransactionalContext openInnerCtx = outerCtx.contextWithNewTransaction();
        this.generatePageCacheHits(openInnerCtx);
        long openInnerHits = this.getPageCacheHits(openInnerCtx);
        long openInnerFaults = this.getPageCacheFaults(openInnerCtx);
        QuerySnapshot snapshot = executingQuery.snapshot();
        Assertions.assertThat((long)snapshot.pageHits()).isEqualTo(outerHits + closedInnerHits + openInnerHits);
        Assertions.assertThat((long)snapshot.pageFaults()).isEqualTo(outerFaults + closedInnerFaults + openInnerFaults);
    }

    @Test
    void contextWithNewTransactionExecutingQueryShouldSumUpActiveLocksFromOpenInnerAndOuterTransactions() {
        this.databaseAPI.executeTransactionally("CREATE (:A), (:B), (:C)");
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        ExecutingQuery executingQuery = outerCtx.executingQuery();
        this.getLocks(outerCtx, "A");
        long outerActiveLocks = this.getActiveLockCount(outerCtx);
        TransactionalContext openInnerCtx1 = outerCtx.contextWithNewTransaction();
        this.getLocks(openInnerCtx1, "B");
        long innerActiveLocks1 = this.getActiveLockCount(openInnerCtx1);
        TransactionalContext openInnerCtx2 = outerCtx.contextWithNewTransaction();
        this.getLocks(openInnerCtx2, "C");
        long innerActiveLocks2 = this.getActiveLockCount(openInnerCtx2);
        QuerySnapshot snapshot = executingQuery.snapshot();
        Assertions.assertThat((long)outerActiveLocks).isGreaterThan(0L);
        Assertions.assertThat((long)innerActiveLocks1).isGreaterThan(0L);
        Assertions.assertThat((long)innerActiveLocks2).isGreaterThan(0L);
        Assertions.assertThat((long)snapshot.activeLockCount()).isEqualTo(outerActiveLocks + innerActiveLocks1 + innerActiveLocks2);
    }

    @Test
    void contextWithNewTransactionExecutingQueryShouldSumUpActiveLocksFromOpenInnerAndOuterTransactionsButNotFromClosedTransactions() {
        this.databaseAPI.executeTransactionally("CREATE (:A), (:B), (:C), (:D)");
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        ExecutingQuery executingQuery = outerCtx.executingQuery();
        this.getLocks(outerCtx, "A");
        long outerActiveLocks = this.getActiveLockCount(outerCtx);
        TransactionalContext innerCtxAbort = outerCtx.contextWithNewTransaction();
        this.getLocks(innerCtxAbort, "B");
        long closedInnerActiveLocksAbort = this.getActiveLockCount(innerCtxAbort);
        innerCtxAbort.rollback();
        TransactionalContext innerCtxCommit = outerCtx.contextWithNewTransaction();
        this.getLocks(innerCtxCommit, "C");
        long closedInnerActiveLocksCommit = this.getActiveLockCount(innerCtxCommit);
        innerCtxCommit.commit();
        TransactionalContext innerCtxOpen = outerCtx.contextWithNewTransaction();
        this.getLocks(innerCtxOpen, "D");
        long openInnerActiveLocks = this.getActiveLockCount(innerCtxOpen);
        QuerySnapshot snapshot = executingQuery.snapshot();
        Assertions.assertThat((long)outerActiveLocks).isGreaterThan(0L);
        Assertions.assertThat((long)closedInnerActiveLocksAbort).isGreaterThan(0L);
        Assertions.assertThat((long)closedInnerActiveLocksCommit).isGreaterThan(0L);
        Assertions.assertThat((long)openInnerActiveLocks).isGreaterThan(0L);
        Assertions.assertThat((long)snapshot.activeLockCount()).isEqualTo(outerActiveLocks + openInnerActiveLocks);
    }

    @Test
    void contextWithNewTransactionExecutingQueryShouldCalculateHighWaterMarkMemoryUsageAlsoWhenCommittedInQuerySnapshot() {
        long openHighWaterMark = 3L;
        long outerHighWaterMark = 10L;
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        MemoryTracker outerTxMemoryTracker = outerTx.kernelTransaction().memoryTracker();
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        ExecutingQuery executingQuery = outerCtx.executingQuery();
        QueryMemoryTracker queryMemoryTracker = QueryMemoryTracker.apply((MemoryTracking)MEMORY_TRACKING.instance());
        MemoryTrackerForOperatorProvider outerTxMemoryTrackerForOperatorProvider = queryMemoryTracker.newMemoryTrackerForOperatorProvider(outerTxMemoryTracker);
        int operatorId = 0;
        LocalMemoryTracker localMem = new LocalMemoryTracker();
        HeapTrackingArrayList ga = HeapTrackingArrayList.newArrayList((MemoryTracker)localMem);
        ga.add(new Object());
        long growingArraySize = localMem.heapHighWaterMark();
        executingQuery.onObfuscatorReady(QueryObfuscator.PASSTHROUGH, 0);
        executingQuery.onCompilationCompleted(null, null, null, 0);
        executingQuery.onExecutionStarted((HeapHighWaterMarkTracker)queryMemoryTracker);
        outerTxMemoryTrackerForOperatorProvider.memoryTrackerForOperator(operatorId).allocateHeap(outerHighWaterMark);
        long innerHighWaterMark = 0L;
        for (int i = 0; i < 10; ++i) {
            TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
            MemoryTracker innerTxMemoryTracker = innerCtx.kernelTransaction().memoryTracker();
            MemoryTrackerForOperatorProvider innerTxMemoryTrackerForOperatorProvider = queryMemoryTracker.newMemoryTrackerForOperatorProvider(innerTxMemoryTracker);
            MemoryTracker operatorMemoryTracker = innerTxMemoryTrackerForOperatorProvider.memoryTrackerForOperator(operatorId);
            int accHighWaterMark = 0;
            if (i % 2 == 0) {
                operatorMemoryTracker.allocateHeap((long)i);
                operatorMemoryTracker.releaseHeap((long)i);
                accHighWaterMark = i;
            }
            innerCtx.commit();
            innerHighWaterMark = Math.max(innerHighWaterMark, (long)accHighWaterMark);
        }
        TransactionalContext openCtx = outerCtx.contextWithNewTransaction();
        MemoryTracker openTxMemoryTracker = openCtx.kernelTransaction().memoryTracker();
        MemoryTrackerForOperatorProvider innerTxMemoryTrackerForOperatorProvider = queryMemoryTracker.newMemoryTrackerForOperatorProvider(openTxMemoryTracker);
        innerTxMemoryTrackerForOperatorProvider.memoryTrackerForOperator(operatorId).allocateHeap(openHighWaterMark);
        QuerySnapshot snapshot = executingQuery.snapshot();
        long snapshotBytes = snapshot.allocatedBytes();
        long profilingBytes = queryMemoryTracker.heapHighWaterMark();
        Assertions.assertThat((long)snapshotBytes).isEqualTo(growingArraySize + outerHighWaterMark + Math.max(innerHighWaterMark, openHighWaterMark));
        Assertions.assertThat((long)profilingBytes).isEqualTo(snapshotBytes);
    }

    @Test
    void contextWithNewTransactionThrowsAfterTransactionTerminate() {
        InternalTransaction tx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(tx);
        tx.kernelTransaction().markForTermination((Status)Status.Transaction.Terminated);
        org.junit.jupiter.api.Assertions.assertThrows(TransactionTerminatedException.class, () -> ((TransactionalContext)ctx).contextWithNewTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    void contextWithNewTransactionThrowsAfterTransactionTerminateRace() throws ExecutionException, InterruptedException {
        KernelTransactions ktxs = (KernelTransactions)this.graph.getDependencyResolver().resolveDependency(KernelTransactions.class);
        try (OtherThreadExecutor otherThreadExecutor = new OtherThreadExecutor("");){
            for (int i = 0; i < 100; ++i) {
                try (InternalTransaction tx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
                    TransactionalContext ctx = this.createTransactionContext(tx);
                    BinaryLatch latch = new BinaryLatch();
                    Future future = otherThreadExecutor.executeDontWait(() -> {
                        latch.release();
                        tx.kernelTransaction().markForTermination((Status)Status.Transaction.Terminated);
                        return null;
                    });
                    latch.await();
                    try {
                        TransactionalContext newContext = ctx.contextWithNewTransaction();
                        newContext.transaction().close();
                        newContext.close();
                    }
                    catch (TransactionTerminatedException transactionTerminatedException) {
                    }
                    finally {
                        future.get();
                        ctx.close();
                    }
                }
                Assertions.assertThat((int)ktxs.getNumberOfActiveTransactions()).isZero();
            }
            return;
        }
    }

    @Test
    void contextWithNewTransactionTerminateInnerTransactionOnOuterTransactionTerminate() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        ctx.kernelTransaction().markForTermination((Status)Status.Transaction.Terminated);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isMarkedForTermination(innerCtx));
    }

    @Test
    void contextWithNewTransactionDeregisterInnerTransactionOnInnerContextCommit() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        innerCtx.commit();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.hasInnerTransaction(ctx));
    }

    @Test
    void contextWithNewTransactionDeregisterInnerTransactionOnInnerContextRollback() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        innerCtx.rollback();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.hasInnerTransaction(ctx));
    }

    @Test
    void contextWithNewTransactionDeregisterInnerTransactionOnInnerContextClose() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        innerCtx.transaction().close();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.hasInnerTransaction(ctx));
    }

    private boolean hasInnerTransaction(TransactionalContext ctx) {
        KernelTransactions kernelTransactions = (KernelTransactions)this.graph.getDependencyResolver().resolveDependency(KernelTransactions.class);
        KernelTransaction kernelTransaction = ctx.kernelTransaction();
        long transactionCountOnCurrentQuery = kernelTransactions.executingTransactions().stream().flatMap(handle -> handle.executingQuery().stream().map(ExecutingQuery::snapshot).map(QuerySnapshot::transactionSequenceNumber).filter(txnId -> txnId.longValue() == kernelTransaction.getTransactionSequenceNumber())).count();
        return transactionCountOnCurrentQuery > 1L;
    }

    @Test
    void contextWithNewTransactionThrowIfInnerTransactionPresentOnOuterTransactionCommit() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        ctx.close();
        org.junit.jupiter.api.Assertions.assertThrows(TransactionFailureException.class, () -> ((TransactionalContext)ctx).commit());
    }

    @Test
    void contextWithNewTransactionDoesNotThrowIfInnerTransactionDeregisteredOnOuterTransactionCommit() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        InternalTransaction innerTx = innerCtx.transaction();
        innerCtx.commit();
        ctx.close();
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ((TransactionalContext)ctx).commit());
    }

    @Test
    void contextWithNewTransactionThrowOnRollbackOfTransactionWithInnerTransactions() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        org.junit.jupiter.api.Assertions.assertThrows(TransactionFailureException.class, () -> ((InternalTransaction)outerTx).rollback());
    }

    @Test
    void contextWithNewTransactionThrowOnCloseOfTransactionWithInnerTransactions() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        org.junit.jupiter.api.Assertions.assertThrows(TransactionFailureException.class, () -> ((InternalTransaction)outerTx).close());
    }

    @Test
    void contextWithNewTransactionDoNotTerminateOuterTransactionOnInnerTransactionTerminate() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        innerCtx.kernelTransaction().markForTermination((Status)Status.Transaction.Terminated);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isMarkedForTermination(ctx));
    }

    @Test
    void contextWithNewTransactionDoNotCloseOuterContextOnInnerContextRollback() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        innerCtx.rollback();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ctx.isOpen());
    }

    @Test
    void contextWithNewTransactionCloseInnerStatementOnInnerContextCommitClose() throws Exception {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
        AutoCloseable outerCloseable = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        AutoCloseable innerCloseable = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        outerCtx.statement().registerCloseableResource(outerCloseable);
        innerCtx.statement().registerCloseableResource(innerCloseable);
        innerCtx.commit();
        ((AutoCloseable)Mockito.verify((Object)innerCloseable)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{innerCloseable});
        Mockito.verifyNoInteractions((Object[])new Object[]{outerCloseable});
    }

    @Test
    void contextWithNewTransactionCloseInnerStatementOnInnerTransactionCommitClose() throws Exception {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext outerCtx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = outerCtx.contextWithNewTransaction();
        InternalTransaction innerTx = innerCtx.transaction();
        AutoCloseable outerCloseable = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        AutoCloseable innerCloseable = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        outerCtx.statement().registerCloseableResource(outerCloseable);
        innerCtx.statement().registerCloseableResource(innerCloseable);
        org.junit.jupiter.api.Assertions.assertThrows(TransactionFailureException.class, () -> ((InternalTransaction)innerTx).commit());
        ((AutoCloseable)Mockito.verify((Object)innerCloseable)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{innerCloseable});
        Mockito.verifyNoInteractions((Object[])new Object[]{outerCloseable});
    }

    @Test
    void contextWithNewTransactionProcedureCalledFromInnerContextShouldUseInnerTransaction() throws ProcedureException {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(outerTx);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        GlobalProcedures procsRegistry = (GlobalProcedures)this.databaseAPI.getDependencyResolver().resolveDependency(GlobalProcedures.class);
        ProcedureHandle txSetMetaData = procsRegistry.getCurrentView().procedure(new QualifiedName("tx", "setMetaData"), QueryLanguage.CYPHER_5);
        int id = txSetMetaData.id();
        ProcedureCallContext procContext = new ProcedureCallContext(id, ArrayUtils.EMPTY_STRING_ARRAY, false, "", false, "runtimeUsed", (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        AnyValue[] arguments = new AnyValue[]{VirtualValues.map((String[])new String[]{"foo"}, (AnyValue[])new AnyValue[]{Values.stringValue((String)"bar")})};
        innerCtx.kernelTransaction().procedures().procedureCallDbms(id, arguments, procContext);
        Assertions.assertThat((Map)innerCtx.kernelTransaction().getMetaData()).isEqualTo(Collections.singletonMap("foo", "bar"));
        Assertions.assertThat((Map)ctx.kernelTransaction().getMetaData()).isEqualTo(Collections.emptyMap());
    }

    @Test
    void contextWithNewTransactionListTransactions() throws InvalidArgumentsException {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        String queryText = "<query text>";
        TransactionalContext ctx = Neo4jTransactionalContextFactory.create(() -> this.graph, (KernelTransactionFactory)this.transactionFactory, (TransactionalContext.DatabaseMode)TransactionalContext.DatabaseMode.SINGLE).newContext(outerTx, queryText, MapValue.EMPTY, QueryExecutionConfiguration.DEFAULT_CONFIG);
        ctx.executingQuery().onObfuscatorReady(QueryObfuscator.PASSTHROUGH, 0);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        InternalTransaction innerTx = innerCtx.transaction();
        List transactions = innerTx.execute("SHOW TRANSACTIONS WHERE NOT currentQuery STARTS WITH 'SHOW TRANSACTIONS'").stream().toList();
        Assertions.assertThat((int)transactions.size()).isEqualTo(1);
        Object transactionId = ((Map)transactions.get(0)).get("transactionId");
        Object currentQuery = ((Map)transactions.get(0)).get("currentQuery");
        Object currentQueryId = ((Map)transactions.get(0)).get("currentQueryId");
        String expectedTransactionId = TransactionId.formatTransactionId((String)outerTx.getDatabaseName(), (long)outerTx.kernelTransaction().getTransactionSequenceNumber());
        String expectedQueryId = String.format("query-%s", ctx.executingQuery().id());
        Assertions.assertThat(transactionId).isEqualTo((Object)expectedTransactionId);
        Assertions.assertThat(currentQuery).isEqualTo((Object)queryText);
        Assertions.assertThat(currentQueryId).isEqualTo((Object)expectedQueryId);
    }

    @Test
    void contextWithNewTransactionKillQuery() {
        InternalTransaction outerTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        String queryText = "<query text>";
        TransactionalContext ctx = Neo4jTransactionalContextFactory.create(() -> this.graph, (KernelTransactionFactory)this.transactionFactory, (TransactionalContext.DatabaseMode)TransactionalContext.DatabaseMode.SINGLE).newContext(outerTx, queryText, MapValue.EMPTY, QueryExecutionConfiguration.DEFAULT_CONFIG);
        ctx.executingQuery().onObfuscatorReady(QueryObfuscator.PASSTHROUGH, 0);
        TransactionalContext innerCtx = ctx.contextWithNewTransaction();
        InternalTransaction innerTx = innerCtx.transaction();
        long userTransactionId = ctx.kernelTransaction().getTransactionSequenceNumber();
        innerTx.execute("TERMINATE TRANSACTION 'neo4j-transaction-" + userTransactionId + "'").stream().toList();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)innerTx.terminationReason().isPresent());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)outerTx.terminationReason().isPresent());
    }

    @Test
    void contextWithRestartedTransactionShouldSumUpPageHitsFaultsFromFirstAndSecondTransactionInQuerySnapshot() {
        this.databaseAPI.executeTransactionally("CREATE (n)");
        InternalTransaction transaction = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(transaction);
        ExecutingQuery executingQuery = ctx.executingQuery();
        long closedTxHits = 0L;
        long closedTxFaults = 0L;
        for (int i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                this.generatePageCacheHits(ctx);
            }
            closedTxHits += this.getPageCacheHits(ctx);
            closedTxFaults += this.getPageCacheFaults(ctx);
            ctx.commitAndRestartTx();
        }
        this.generatePageCacheHits(ctx);
        long lastHits = this.getPageCacheHits(ctx);
        long lastFaults = this.getPageCacheFaults(ctx);
        InternalTransaction lastTx = ctx.transaction();
        QuerySnapshot snapshot = executingQuery.snapshot();
        Assertions.assertThat((long)snapshot.transactionSequenceNumber()).isEqualTo(lastTx.kernelTransaction().getTransactionSequenceNumber());
        Assertions.assertThat((long)snapshot.pageHits()).isEqualTo(closedTxHits + lastHits);
        Assertions.assertThat((long)snapshot.pageFaults()).isEqualTo(closedTxFaults + lastFaults);
    }

    @Test
    void contextWithRestartedTransactionShouldSumUpPageHitsFaultsFromFirstAndSecondTransactionInPROFILE() {
        this.databaseAPI.executeTransactionally("CREATE (n)");
        InternalTransaction transaction = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext ctx = this.createTransactionContext(transaction);
        long closedTxHits = 0L;
        long closedTxFaults = 0L;
        for (int i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                this.generatePageCacheHits(ctx);
            }
            closedTxHits += this.getPageCacheHits(ctx);
            closedTxFaults += this.getPageCacheFaults(ctx);
            ctx.commitAndRestartTx();
        }
        this.generatePageCacheHits(ctx);
        long lastHits = this.getPageCacheHits(ctx);
        long lastFaults = this.getPageCacheFaults(ctx);
        StatisticProvider profileStatisticsProvider = ctx.kernelStatisticProvider();
        Assertions.assertThat((long)profileStatisticsProvider.getPageCacheHits()).isEqualTo(closedTxHits + lastHits);
        Assertions.assertThat((long)profileStatisticsProvider.getPageCacheMisses()).isEqualTo(closedTxFaults + lastFaults);
    }

    @Test
    void restartingContextDoesNotLeakKernelTransaction() {
        InternalTransaction transaction = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        TransactionalContext transactionContext = this.createTransactionContext(transaction);
        KernelTransactions kernelTransactions = (KernelTransactions)this.graph.getDependencyResolver().resolveDependency(KernelTransactions.class);
        int initialActiveCount = kernelTransactions.getNumberOfActiveTransactions();
        for (int i = 0; i < 1024; ++i) {
            transactionContext.commitAndRestartTx();
            Assertions.assertThat((int)kernelTransactions.getNumberOfActiveTransactions()).isCloseTo(initialActiveCount, Offset.offset((Number)5));
        }
    }

    @Test
    void contextWithRestartedTransactionShouldReuseExecutingQuery() {
        InternalTransaction internalTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        KernelTransaction firstKernelTx = internalTx.kernelTransaction();
        TransactionalContext ctx = this.createTransactionContext(internalTx);
        Statement firstStatement = ctx.statement();
        ExecutingQuery firstExecutingQuery = (ExecutingQuery)((KernelStatement)firstStatement).queryRegistry().executingQuery().get();
        ctx.commitAndRestartTx();
        KernelTransaction secondKernelTx = internalTx.kernelTransaction();
        Statement secondStatement = ctx.statement();
        ExecutingQuery secondExecutingQuery = (ExecutingQuery)((KernelStatement)secondStatement).queryRegistry().executingQuery().get();
        Assertions.assertThat((Object)secondKernelTx).isNotSameAs((Object)firstKernelTx);
        Assertions.assertThat((Object)secondStatement).isNotSameAs((Object)firstStatement);
        Assertions.assertThat((Object)secondExecutingQuery).isSameAs((Object)firstExecutingQuery);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)firstKernelTx.isOpen());
    }

    @Test
    void contextWithNewTransactionsQueryTransactionShouldReuseExecutingQuery() {
        InternalTransaction firstInternalTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        KernelTransaction firstKernelTx = firstInternalTx.kernelTransaction();
        TransactionalContext ctx = this.createTransactionContext(firstInternalTx);
        Statement firstStatement = ctx.statement();
        ExecutingQuery firstExecutingQuery = (ExecutingQuery)((KernelStatement)firstStatement).queryRegistry().executingQuery().get();
        ctx = ctx.contextWithNewTransaction();
        InternalTransaction secondInternalTx = ctx.transaction();
        KernelTransaction secondKernelTx = secondInternalTx.kernelTransaction();
        Statement secondStatement = ctx.statement();
        ExecutingQuery secondExecutingQuery = (ExecutingQuery)((KernelStatement)secondStatement).queryRegistry().executingQuery().get();
        Assertions.assertThat((Object)secondInternalTx).isNotSameAs((Object)firstInternalTx);
        Assertions.assertThat((Object)secondKernelTx).isNotSameAs((Object)firstKernelTx);
        Assertions.assertThat((Object)secondStatement).isNotSameAs((Object)firstStatement);
        Assertions.assertThat((Object)secondExecutingQuery).isSameAs((Object)firstExecutingQuery);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstKernelTx.isOpen());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldBeAbleToAccessExecutingQueryWhileCommitting() {
        KernelTransactions kernelTransactions = (KernelTransactions)this.graph.getDependencyResolver().resolveDependency(KernelTransactions.class);
        final BinaryLatch inCommitLatch = new BinaryLatch();
        final BinaryLatch releaseCommitLatch = new BinaryLatch();
        this.dbms.registerTransactionEventListener(this.databaseAPI.databaseName(), (TransactionEventListener)new TransactionEventListenerAdapter<Object>(this){

            public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
                inCommitLatch.release();
                releaseCommitLatch.await();
                return super.beforeCommit(data, transaction, databaseService);
            }
        });
        try (OtherThreadExecutor executor = new OtherThreadExecutor("test");){
            AtomicReference reg = new AtomicReference();
            executor.executeDontWait(() -> {
                InternalTransaction internalTx = this.graph.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
                TransactionalContext ctx = this.createTransactionContext(internalTx);
                internalTx.execute("CREATE (n)");
                reg.set(((KernelStatement)ctx.statement()).queryRegistry());
                ctx.commit();
                return null;
            });
            try {
                inCommitLatch.await();
                Set txs = kernelTransactions.executingTransactions();
                Assertions.assertThat((Collection)txs).hasSize(1);
                Assertions.assertThat((Optional)((KernelTransactionHandle)txs.iterator().next()).executingQuery()).isPresent();
                Assertions.assertThat((Optional)((QueryRegistry)reg.get()).executingQuery()).isPresent();
            }
            finally {
                releaseCommitLatch.release();
            }
        }
    }

    public static class Procedures {
        @Context
        public Transaction transaction;

        @Procedure(name="test.failingProc", mode=Mode.WRITE)
        public void stupidProcedure() {
            this.transaction.execute("CREATE (c {prop: 1 / 0})");
        }
    }
}

