/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.event.InternalTransactionEventListener;
import org.neo4j.kernel.recovery.RecoveryHelpers;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.UpgradeTestUtil;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class RecoveryToFutureOverUpgradedVersionsIT {
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private Neo4jLayout neo4jLayout;
    private DatabaseManagementService managementService;
    private GraphDatabaseAPI systemDb;

    RecoveryToFutureOverUpgradedVersionsIT() {
    }

    @BeforeEach
    void setUp() {
        this.startDbms(builder -> builder, false);
    }

    @AfterEach
    void tearDown() {
        this.shutdownDbms();
    }

    private TestDatabaseManagementServiceBuilder configureGloriousFutureAsLatest(TestDatabaseManagementServiceBuilder builder) {
        return builder.setConfig(GraphDatabaseInternalSettings.latest_runtime_version, (Object)DbmsRuntimeVersion.GLORIOUS_FUTURE.getVersion()).setConfig(GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version());
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "system"})
    void recoverDatabaseOnOldVersionNoCheckpoints(String dbName) throws Throwable {
        GraphDatabaseAPI testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        DatabaseLayout dbLayout = testDb.databaseLayout();
        this.createWriteTransaction(testDb);
        this.shutdownDbms();
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem);
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)RecoveryHelpers.logsContainCheckpoint((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem));
        this.startDbms(this::configureGloriousFutureAsLatest, true);
        testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)testDb, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "system"})
    void recoverDatabaseOnOldVersionNoCheckpointsAndContainsUpgradeTransaction(String dbName) throws Throwable {
        this.shutdownDbms();
        this.startDbms(this::configureGloriousFutureAsLatest, false);
        GraphDatabaseAPI testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        DatabaseLayout dbLayout = testDb.databaseLayout();
        this.createWriteTransaction(testDb);
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.managementService, (GraphDatabaseAPI)testDb, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        this.shutdownDbms();
        Config config = Config.newBuilder().set(GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version()).build();
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem, (Config)config);
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem, (Config)config);
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem, (Config)config);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)RecoveryHelpers.logsContainCheckpoint((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem));
        this.startDbms(this::configureGloriousFutureAsLatest, true);
        testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)testDb, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "system"})
    void recoverDatabaseOnOldVersionOneCheckpoint(String dbName) throws Throwable {
        GraphDatabaseAPI testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        DatabaseLayout dbLayout = testDb.databaseLayout();
        this.createWriteTransaction(testDb);
        CheckPointer checkPointer = (CheckPointer)testDb.getDependencyResolver().resolveDependency(CheckPointer.class);
        checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("extra checkpoint"));
        this.createWriteTransaction(testDb);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)testDb, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
        this.shutdownDbms();
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem);
        Assertions.assertThat((Comparable)RecoveryHelpers.getLatestCheckpoint((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem).kernelVersion()).isEqualTo((Object)LatestVersions.LATEST_KERNEL_VERSION);
        this.startDbms(this::configureGloriousFutureAsLatest, true);
        testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)testDb, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "system"})
    void recoverDatabaseOnOldVersionOneCheckpointAndContainsUpgradeTransaction(String dbName) throws Throwable {
        this.shutdownDbms();
        this.startDbms(this::configureGloriousFutureAsLatest, false);
        GraphDatabaseAPI testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        DatabaseLayout dbLayout = testDb.databaseLayout();
        this.createWriteTransaction(testDb);
        CheckPointer checkPointer = (CheckPointer)testDb.getDependencyResolver().resolveDependency(CheckPointer.class);
        checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("extra checkpoint"));
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.managementService, (GraphDatabaseAPI)testDb, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        this.shutdownDbms();
        Config config = Config.newBuilder().set(GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version()).build();
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem, (Config)config);
        Assertions.assertThat((Comparable)RecoveryHelpers.getLatestCheckpoint((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem, (Config)config).kernelVersion()).isEqualTo((Object)LatestVersions.LATEST_KERNEL_VERSION);
        this.startDbms(this::configureGloriousFutureAsLatest, true);
        testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)testDb, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
    }

    @Test
    void recoverOldSystemDatabaseNoTransactionLogs() throws Throwable {
        String dbName = "system";
        GraphDatabaseAPI testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        DatabaseLayout dbLayout = testDb.databaseLayout();
        this.createWriteTransaction(testDb);
        this.shutdownDbms();
        this.removeTransactionLogs(dbLayout);
        this.startDbms(builder -> this.configureGloriousFutureAsLatest(builder).setConfig(GraphDatabaseSettings.fail_on_missing_files, (Object)false), false);
        testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)testDb, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
    }

    @Test
    void recoverOldDatabaseNoTransactionLogs() throws Throwable {
        String dbName = "neo4j";
        GraphDatabaseAPI testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        DatabaseLayout dbLayout = testDb.databaseLayout();
        this.createWriteTransaction(testDb);
        this.shutdownDbms();
        this.removeTransactionLogs(dbLayout);
        this.startDbms(builder -> this.configureGloriousFutureAsLatest(builder).setConfig(GraphDatabaseSettings.fail_on_missing_files, (Object)false), false);
        testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)testDb, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
    }

    @Test
    void shouldHandleLastTransactionToRecoverIsUpgrade() throws Exception {
        this.shutdownDbms();
        this.startDbms(this::configureGloriousFutureAsLatest, false);
        String dbName = "neo4j";
        GraphDatabaseAPI testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        DatabaseLayout dbLayout = testDb.databaseLayout();
        long numNodesBefore = this.getNodeCount(testDb);
        this.managementService.registerTransactionEventListener(dbName, (TransactionEventListener)new InternalTransactionEventListener.Adapter<Object>(this){

            public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
                if (data.metaData().containsKey("triggerTx")) {
                    throw new TransactionFailureException("Failed because you asked for it", (Status)Status.Transaction.TransactionHookFailed);
                }
                return null;
            }
        });
        UpgradeTestUtil.manuallyUpgrade((GraphDatabaseService)this.systemDb);
        Assertions.assertThatThrownBy(() -> {
            try (TransactionImpl tx = (TransactionImpl)testDb.beginTx();){
                tx.setMetaData(Map.of("triggerTx", "something"));
                tx.createNode();
                tx.commit();
            }
        }).isInstanceOf(TransactionFailureException.class);
        ((AbstractLongAssert)Assertions.assertThat((long)this.getNodeCount(testDb)).as("Triggering transaction succeeded when it should fail", new Object[0])).isEqualTo(numNodesBefore);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)testDb, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        this.shutdownDbms();
        Config config = Config.newBuilder().set(GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version()).build();
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem, (Config)config);
        Assertions.assertThat((Comparable)RecoveryHelpers.getLatestCheckpoint((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem, (Config)config).kernelVersion()).isEqualTo((Object)LatestVersions.LATEST_KERNEL_VERSION);
        this.startDbms(this::configureGloriousFutureAsLatest, true);
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)db, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
    }

    @Test
    void checkpointWithUpgradeAsLastTxShouldBeOnUpgradedVersion() throws Exception {
        this.shutdownDbms();
        this.startDbms(this::configureGloriousFutureAsLatest, false);
        String dbName = "neo4j";
        GraphDatabaseAPI testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        DatabaseLayout dbLayout = testDb.databaseLayout();
        long numNodesBefore = this.getNodeCount(testDb);
        this.managementService.registerTransactionEventListener(dbName, (TransactionEventListener)new InternalTransactionEventListener.Adapter<Object>(this){

            public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
                if (data.metaData().containsKey("triggerTx")) {
                    throw new TransactionFailureException("Failed because you asked for it", (Status)Status.Transaction.TransactionHookFailed);
                }
                return null;
            }
        });
        UpgradeTestUtil.manuallyUpgrade((GraphDatabaseService)this.systemDb);
        Assertions.assertThatThrownBy(() -> {
            try (TransactionImpl tx = (TransactionImpl)testDb.beginTx();){
                tx.setMetaData(Map.of("triggerTx", "something"));
                tx.createNode();
                tx.commit();
            }
        }).isInstanceOf(TransactionFailureException.class);
        ((AbstractLongAssert)Assertions.assertThat((long)this.getNodeCount(testDb)).as("Triggering transaction succeeded when it should fail", new Object[0])).isEqualTo(numNodesBefore);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)testDb, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        this.shutdownDbms();
        Config config = Config.newBuilder().set(GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version()).build();
        Assertions.assertThat((Comparable)RecoveryHelpers.getLatestCheckpoint((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem, (Config)config).kernelVersion()).isEqualTo((Object)KernelVersion.GLORIOUS_FUTURE);
        this.startDbms(this::configureGloriousFutureAsLatest, true);
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)db, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
    }

    private long getNodeCount(GraphDatabaseAPI db) {
        try (Transaction tx = db.beginTx();){
            long l = Iterables.count((Iterable)tx.getAllNodes());
            return l;
        }
    }

    private void removeTransactionLogs(DatabaseLayout dbLayout) throws IOException {
        LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((Path)dbLayout.getTransactionLogsDirectory(), (FileSystemAbstraction)this.fileSystem).withCommandReaderFactory(StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)dbLayout, null).commandReaderFactory()).build();
        for (Path logFile : this.fileSystem.listFiles(logFiles.logFilesDirectory())) {
            this.fileSystem.deleteFile(logFile);
        }
    }

    private void startDbms(Configuration configuration, boolean allowAutomaticUpgrade) {
        this.managementService = configuration.configure(new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)"keep_all").setConfig(GraphDatabaseInternalSettings.automatic_upgrade_enabled, (Object)allowAutomaticUpgrade)).build();
        this.systemDb = (GraphDatabaseAPI)this.managementService.database("system");
    }

    private void shutdownDbms() {
        if (this.managementService != null) {
            this.managementService.shutdown();
            this.managementService = null;
        }
    }

    private void createWriteTransaction(GraphDatabaseAPI db) {
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
    }

    @FunctionalInterface
    static interface Configuration {
        public TestDatabaseManagementServiceBuilder configure(TestDatabaseManagementServiceBuilder var1);
    }
}

