/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.admin.commands;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.ContextInjectingFactory;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.admin.security.SetDefaultAdminCommand;
import org.neo4j.commandline.admin.security.SetInitialPasswordCommand;
import org.neo4j.commandline.dbms.DiagnosticsReportCommand;
import org.neo4j.commandline.dbms.DumpCommand;
import org.neo4j.commandline.dbms.LoadCommand;
import org.neo4j.commandline.dbms.MemoryRecommendationsCommand;
import org.neo4j.commandline.dbms.StoreInfoCommand;
import org.neo4j.commandline.dbms.UnbindCommand;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.consistency.CheckCommand;
import org.neo4j.importer.ImportCommand;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import picocli.CommandLine;

@TestDirectoryExtension
@DisabledOnOs(value={OS.WINDOWS})
class AdminCommandsIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fs;
    private ExecutionContext context;
    private Path dumpFolder;
    private OutputStream err;

    AdminCommandsIT() {
    }

    @BeforeEach
    void setup() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.err = new ByteArrayOutputStream();
        Path confDir = this.testDirectory.directory("test.conf");
        Path home = this.testDirectory.homePath("home");
        this.dumpFolder = this.testDirectory.directory("dumpFolder");
        this.context = new ExecutionContext(home, confDir, new PrintStream(out), new PrintStream(this.err), this.testDirectory.getFileSystem());
        Path configFile = confDir.resolve("neo4j.conf");
        try (OutputStream outputStream = this.fs.openAsOutputStream(configFile, false);
             PrintStream printOut = new PrintStream(outputStream);){
            printOut.printf("%s=%s%n", BootloaderSettings.initial_heap_size.name(), "$(expr 500)");
        }
        Assertions.assertThat((Object)this.fs).isInstanceOf(DefaultFileSystemAbstraction.class);
        Files.setPosixFilePermissions(configFile, Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
    }

    @Test
    void shouldExpandCommands() throws IOException {
        String testDb = "test";
        this.assertExpansionSuccess((AbstractCommand)new SetInitialPasswordCommand(this.context), "--expand-commands", "password");
        this.assertExpansionSuccess((AbstractCommand)new SetDefaultAdminCommand(this.context), "--expand-commands", "admin");
        this.assertExpansionSuccess((AbstractCommand)new StoreInfoCommand(this.context), "--expand-commands", "path");
        this.assertExpansionSuccess((AbstractCommand)new CheckCommand(this.context), "--expand-commands", "neo4j");
        this.assertExpansionSuccess((AbstractCommand)new DiagnosticsReportCommand(this.context), "--expand-commands");
        Path dump = this.testDirectory.directory("dump");
        this.testDirectory.getFileSystem().mkdirs(dump);
        Files.writeString(dump.resolve("test.dump"), (CharSequence)"ignored", StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        this.assertExpansionSuccess((AbstractCommand)new LoadCommand(this.context), "--expand-commands", "--from-path=" + String.valueOf(this.testDirectory.directory("dump").toAbsolutePath()), "test");
        this.assertExpansionSuccess((AbstractCommand)new MemoryRecommendationsCommand(this.context), "--expand-commands");
        this.assertExpansionSuccess((AbstractCommand)new DumpCommand(this.context), "--expand-commands", "test", "--to-path", this.dumpFolder.toString());
        this.fs.mkdirs(Neo4jLayout.of((Path)this.testDirectory.homePath()).databasesDirectory());
        this.assertExpansionSuccess((AbstractCommand)new UnbindCommand(this.context), "--expand-commands");
    }

    @Test
    void shouldNotExpandCommands() {
        this.assertExpansionError((AbstractCommand)new SetInitialPasswordCommand(this.context), "password");
        this.assertExpansionError((AbstractCommand)new SetDefaultAdminCommand(this.context), "user");
        this.assertExpansionError((AbstractCommand)new StoreInfoCommand(this.context), "path");
        this.assertExpansionError((AbstractCommand)new CheckCommand(this.context), "neo4j");
        this.assertExpansionError((AbstractCommand)new DiagnosticsReportCommand(this.context), new String[0]);
        this.assertExpansionError((AbstractCommand)new LoadCommand(this.context), "--from-path=" + String.valueOf(this.testDirectory.directory("dump").toAbsolutePath()), "test");
        this.assertExpansionError((AbstractCommand)new MemoryRecommendationsCommand(this.context), new String[0]);
        this.assertExpansionError((AbstractCommand)new ImportCommand.Full(this.context), "--nodes=" + String.valueOf(this.testDirectory.createFile("foo.csv").toAbsolutePath()));
        this.assertExpansionError((AbstractCommand)new DumpCommand(this.context), "test", "--to-path", this.dumpFolder.toString());
        this.assertExpansionError((AbstractCommand)new UnbindCommand(this.context), new String[0]);
    }

    private void assertExpansionSuccess(AbstractCommand command, String ... args) {
        new CommandLine((Object)command, (CommandLine.IFactory)new ContextInjectingFactory(this.context)).execute(args);
    }

    private void assertExpansionError(AbstractCommand command, String ... args) {
        new CommandLine((Object)command, (CommandLine.IFactory)new ContextInjectingFactory(this.context)).execute(args);
        Assertions.assertThat((String)this.err.toString()).contains(new CharSequence[]{"is a command, but config is not explicitly told to expand it."});
    }
}

