/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.IOException;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.test.Race;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class DatabaseAppendIndexIT {
    @Inject
    private MetadataProvider metadataProvider;
    @Inject
    private CheckPointer checkPointer;
    @Inject
    private LogFiles logFiles;
    @Inject
    private GraphDatabaseAPI databaseAPI;

    @Test
    void appendIndexAndTransactionIdsAreMatching() {
        org.junit.jupiter.api.Assertions.assertEquals((long)this.metadataProvider.getLastAppendIndex(), (long)this.metadataProvider.getLastClosedTransactionId());
        try (Transaction transaction = this.databaseAPI.beginTx();){
            transaction.createNode();
            transaction.commit();
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)this.metadataProvider.getLastAppendIndex(), (long)this.metadataProvider.getLastClosedTransactionId());
    }

    @Test
    void appendIndexMatchingTransactionIdWhenInternalTransactionsExecuted() {
        org.junit.jupiter.api.Assertions.assertEquals((long)this.metadataProvider.getLastAppendIndex(), (long)this.metadataProvider.getLastClosedTransactionId());
        try (Transaction transaction = this.databaseAPI.beginTx();){
            Node node = transaction.createNode(new Label[]{Label.label((String)"marker")});
            node.setProperty("foo", (Object)"bar");
            transaction.commit();
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)this.metadataProvider.getLastAppendIndex(), (long)this.metadataProvider.getLastClosedTransactionId());
    }

    @Test
    void checkpointContainsLastAppendedIndex() throws IOException {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            Node node = transaction.createNode(new Label[]{Label.label((String)"marker")});
            node.setProperty("foo", (Object)"bar");
            transaction.commit();
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)this.metadataProvider.getLastAppendIndex(), (long)this.metadataProvider.getLastClosedTransactionId());
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test trigger"));
        CheckpointInfo checkpointInfo = (CheckpointInfo)this.logFiles.getCheckpointFile().findLatestCheckpoint().orElseThrow();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.metadataProvider.getLastAppendIndex(), (long)checkpointInfo.appendIndex());
        org.junit.jupiter.api.Assertions.assertEquals((long)this.metadataProvider.getLastClosedTransactionId(), (long)checkpointInfo.transactionId().id());
    }

    @RepeatedTest(value=10)
    void lastCommittedBatchCorrectAfterConcurrentTransactions() throws Throwable {
        Race race = new Race();
        race.addContestants(100, () -> {
            try (Transaction tx = this.databaseAPI.beginTx();){
                tx.createNode();
                tx.commit();
            }
        });
        race.go();
        long appendIndexClosed = this.metadataProvider.getLastClosedBatch().appendIndex();
        long appendIndexCommitted = this.metadataProvider.getLastCommittedBatch().appendIndex();
        ((AbstractLongAssert)Assertions.assertThat((long)appendIndexClosed).as("Expecting last closed batch index: %s to be equal to last committed batch append index: %s", new Object[]{appendIndexClosed, appendIndexCommitted})).isEqualTo(appendIndexCommitted);
    }
}

