/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class DefaultIndexesIT {
    @Inject
    private GraphDatabaseService db;
    @Inject
    DbmsController dbmsController;

    @Test
    void defaultIndexesCreatedOnFirstStart() {
        IndexingTestUtil.assertOnlyDefaultTokenIndexesExists(this.db);
    }

    @Test
    void defaultIndexesAreNotRecreatedAfterDropAndRestart() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexes().forEach(IndexDefinition::drop);
            tx.commit();
        }
        this.dbmsController.restartDbms();
        Assertions.assertThat((boolean)this.db.isAvailable(TimeUnit.MINUTES.toMillis(5L))).isTrue();
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((Iterable)tx.schema().getIndexes()).isEmpty();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

