/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
@ImpermanentDbmsExtension
class DeleteNodeWithRelationshipsIT {
    @Inject
    private GraphDatabaseService db;

    DeleteNodeWithRelationshipsIT() {
    }

    @Test
    void shouldGiveHelpfulExceptionWhenDeletingNodeWithRelationships() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"MAYOR_OF"));
            tx.commit();
        }
        tx = this.db.beginTx();
        tx.getNodeById(node.getId()).delete();
        ConstraintViolationException ex = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> ((Transaction)tx).commit());
        Assertions.assertEquals((Object)("Cannot delete node<" + node.getId() + ">, because it still has relationships. To delete this node, you must first delete its relationships."), (Object)ex.getMessage());
    }

    @Test
    void shouldDeleteDenseNodeEvenWithTemporarilyCreatedRelationshipsBeforeDeletion() {
        long nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            nodeId = node.getId();
            for (int i = 0; i < 200; ++i) {
                node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)("TYPE_" + i % 3)));
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"OTHER_TYPE_1"));
            node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"OTHER_TYPE_2"));
            Iterables.forEach((Iterable)node.getRelationships(), Entity::delete);
            node.delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThrows(NotFoundException.class, () -> tx.getNodeById(nodeId));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

