/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.io.IOException;
import java.util.function.ToLongFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.database.DatabaseSizeService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ImpermanentDbmsExtension(configurationCallback="configure")
@ExtendWith(value={RandomExtension.class})
public abstract class DatabaseSizeServiceAvailableReservedSizeITBase {
    protected static final String PROPERTY_KEY_PREFIX = "property";
    protected static final Label NODE_LABEL = Label.label((String)"Label");
    protected static final RelationshipType REL_TYPE = RelationshipType.withName((String)"RELATES_TO");
    @Inject
    GraphDatabaseAPI db;
    @Inject
    RandomSupport random;
    private DependencyResolver dependencyResolver;
    private final String format;

    protected DatabaseSizeServiceAvailableReservedSizeITBase(String format) {
        this.format = format;
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.db_format, (Object)this.format);
    }

    @BeforeEach
    void setDependencyResolver() {
        this.dependencyResolver = this.db.getDependencyResolver();
    }

    protected void assertAvailableReservedSpaceChanged(ToLongFunction<Transaction> operation) throws IOException {
        long expectedDifference;
        DatabaseSizeService sizeService = (DatabaseSizeService)this.db.getDependencyResolver().resolveDependency(DatabaseSizeService.class);
        long before = sizeService.getDatabaseAvailableReservedSize(this.db.databaseId());
        try (Transaction tx = this.db.beginTx();){
            expectedDifference = operation.applyAsLong(tx);
            tx.commit();
        }
        long after = sizeService.getDatabaseAvailableReservedSize(this.db.databaseId());
        Assertions.assertThat((long)(after - before)).isEqualTo(expectedDifference);
    }

    protected <T> T get(Class<T> cls) {
        return (T)this.dependencyResolver.resolveDependency(cls);
    }
}

