/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.io.IOException;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.database.DatabaseSizeService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class DatabaseSizeServiceIT {
    @Inject
    TestDirectory testDirectory;

    DatabaseSizeServiceIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void sizeOfDatabaseWithDifferentDataAndLogFolder() throws IOException {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).build();
        try {
            GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
            DatabaseLayout databaseLayout = database.databaseLayout();
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)databaseLayout.getTransactionLogsDirectory(), (Object)databaseLayout.databaseDirectory());
            DatabaseSizeServiceIT.verifyDatabaseSize(database);
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void sizeOfDatabaseWithSameDataAndLogFolder() throws IOException {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setConfig(GraphDatabaseSettings.transaction_logs_root_path, (Object)this.testDirectory.homePath()).setConfig(GraphDatabaseInternalSettings.databases_root_path, (Object)this.testDirectory.homePath()).build();
        try {
            GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
            DatabaseLayout databaseLayout = database.databaseLayout();
            org.junit.jupiter.api.Assertions.assertEquals((Object)databaseLayout.getTransactionLogsDirectory(), (Object)databaseLayout.databaseDirectory());
            DatabaseSizeServiceIT.verifyDatabaseSize(database);
        }
        finally {
            managementService.shutdown();
        }
    }

    private static void verifyDatabaseSize(GraphDatabaseAPI database) throws IOException {
        long propertySize = ByteUnit.mebiBytes((long)1L);
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("property", (Object)RandomStringUtils.randomAscii((int)((int)propertySize)));
            transaction.commit();
        }
        DatabaseSizeService databaseSizeService = (DatabaseSizeService)database.getDependencyResolver().resolveDependency(DatabaseSizeService.class);
        Assertions.assertThat((long)databaseSizeService.getDatabaseDataSize(database.databaseId())).isGreaterThan(0L);
        Assertions.assertThat((long)databaseSizeService.getDatabaseTotalSize(database.databaseId())).isGreaterThan(propertySize);
    }
}

