/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelAPIParallelStress;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.WorkerContext;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.ElementIdMapper;

@DbmsExtension
@ExtendWith(value={RandomExtension.class})
class KernelAPIParallelTypeScanStressIT {
    private static final int N_THREADS = 10;
    private static final int N_RELS = 10000;
    private static final TokenHolders tokenHolders = (TokenHolders)Mockito.mock(TokenHolders.class);
    private static final QueryExecutionEngine engine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
    private static final TransactionalContextFactory contextFactory = (TransactionalContextFactory)Mockito.mock(TransactionalContextFactory.class);
    private static final DatabaseAvailabilityGuard availabilityGuard = (DatabaseAvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
    private static final ElementIdMapper elementIdMapper = (ElementIdMapper)Mockito.mock(ElementIdMapper.class);
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private RandomSupport random;
    @Inject
    private Kernel kernel;
    private IndexDescriptor rti;

    KernelAPIParallelTypeScanStressIT() {
    }

    @BeforeEach
    void findRelationshipTypeIndexDescriptor() {
        try (Transaction tx = this.db.beginTx();){
            for (IndexDefinition indexDef : tx.schema().getIndexes()) {
                IndexDescriptor index = ((IndexDefinitionImpl)indexDef).getIndexReference();
                if (index.getIndexType() != IndexType.LOOKUP || !index.schema().isAnyTokenSchemaDescriptor() || index.schema().entityType() != EntityType.RELATIONSHIP) continue;
                this.rti = index;
            }
        }
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.rti);
    }

    @Test
    void shouldDoParallelTypeScans() throws Throwable {
        int[] types = new int[3];
        try (KernelTransaction tx2 = this.kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            new TransactionImpl(tokenHolders, contextFactory, availabilityGuard, engine, tx2, elementIdMapper);
            types[0] = KernelAPIParallelTypeScanStressIT.createRelationships(tx2, 10000, "TYPE1");
            types[1] = KernelAPIParallelTypeScanStressIT.createRelationships(tx2, 10000, "TYPE2");
            types[2] = KernelAPIParallelTypeScanStressIT.createRelationships(tx2, 10000, "TYPE3");
            tx2.commit();
        }
        KernelAPIParallelStress.parallelStressInTx(this.kernel, 10, tx -> {
            Statement statement = tx.acquireStatement();
            ExecutionContext executionContext = tx.createExecutionContext();
            RelationshipTypeIndexCursor cursor = this.kernel.cursors().allocateRelationshipTypeIndexCursor(executionContext.cursorContext());
            return new WorkerContext<RelationshipTypeIndexCursor>(cursor, executionContext, (KernelTransaction)tx, statement);
        }, (read, workerContext) -> this.typeScan((Read)read, (WorkerContext<RelationshipTypeIndexCursor>)workerContext, types[this.random.nextInt(types.length)]));
    }

    private static int createRelationships(KernelTransaction tx, int count, String typeName) throws KernelException {
        int type = tx.tokenWrite().relationshipTypeCreateForName(typeName, false);
        for (int i = 0; i < count; ++i) {
            long n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            tx.dataWrite().relationshipCreate(n1, type, n2);
        }
        return type;
    }

    private Runnable typeScan(Read read, WorkerContext<RelationshipTypeIndexCursor> workerContext, int type) {
        return () -> {
            try {
                RelationshipTypeIndexCursor cursor = (RelationshipTypeIndexCursor)workerContext.getCursor();
                CursorContext cursorContext = workerContext.getContext().cursorContext();
                try {
                    TokenReadSession readSession = read.tokenReadSession(this.rti);
                    read.relationshipTypeScan(readSession, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(type), cursorContext);
                }
                catch (KernelException e) {
                    throw new RuntimeException(e);
                }
                int n = 0;
                while (cursor.next()) {
                    ++n;
                }
                ((AbstractIntegerAssert)Assertions.assertThat((int)n).as("correct number of relationships", new Object[0])).isEqualTo(10000);
            }
            finally {
                workerContext.complete();
            }
        };
    }
}

