/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.mutable.MutableLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.index.IndexAccessorCompatibility;
import org.neo4j.kernel.api.index.PropertyIndexProviderCompatibilityTestSuite;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.test.InMemoryTokens;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

abstract class CompositeRandomizedIndexAccessorCompatibility
extends IndexAccessorCompatibility {
    CompositeRandomizedIndexAccessorCompatibility(PropertyIndexProviderCompatibilityTestSuite testSuite, IndexPrototype prototype) {
        super(testSuite, prototype);
    }

    private static class ValueAndId {
        private final ValueTuple value;
        private final long id;

        ValueAndId(ValueTuple value, long id) {
            this.value = value;
            this.id = id;
        }
    }

    static abstract class Range
    extends CompositeRandomizedIndexAccessorCompatibility {
        Range(PropertyIndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1000, (int[])new int[]{100, 101})));
        }

        @Test
        void testRangeMatchOnRandomValues() throws Exception {
            Assumptions.assumeTrue((boolean)this.testSuite.supportsGranularCompositeQueries(), (String)"Assume support for granular composite queries");
            ValueType[] types = this.randomSetOfSupportedAndSortableTypes();
            HashSet<ValueTuple> uniqueValues = new HashSet<ValueTuple>();
            TreeSet<ValueAndId> sortedValues = new TreeSet<ValueAndId>((v1, v2) -> ValueTuple.COMPARATOR.compare(v1.value, v2.value));
            MutableLong nextId = new MutableLong();
            for (int i = 0; i < 5; ++i) {
                List<ValueIndexEntryUpdate> updates = new ArrayList<ValueIndexEntryUpdate>();
                if (i == 0) {
                    updates = this.generateUpdatesFromValues(this.generateValuesFromType(types, uniqueValues, 20000), nextId);
                    sortedValues.addAll(updates.stream().map(u -> new ValueAndId(ValueTuple.of((Value[])u.values()), u.getEntityId())).toList());
                } else {
                    for (int j = 0; j < 1000; ++j) {
                        ValueAndId existing;
                        int type = this.random.intBetween(0, 2);
                        if (type == 0) {
                            ValueTuple value = this.generateUniqueRandomValue(types, uniqueValues);
                            if (value == null) continue;
                            long id = nextId.getAndIncrement();
                            sortedValues.add(new ValueAndId(value, id));
                            updates.add(IndexEntryUpdate.add((long)id, (IndexDescriptor)this.descriptor, (Value[])value.getValues()));
                            continue;
                        }
                        if (type == 1) {
                            existing = (ValueAndId)this.random.among((Object[])sortedValues.toArray(new ValueAndId[0]));
                            sortedValues.remove(existing);
                            ValueTuple newValue = this.generateUniqueRandomValue(types, uniqueValues);
                            if (newValue == null) continue;
                            uniqueValues.remove(existing.value);
                            sortedValues.add(new ValueAndId(newValue, existing.id));
                            updates.add(ValueIndexEntryUpdate.change((long)existing.id, (IndexDescriptor)this.descriptor, (Value[])existing.value.getValues(), (Value[])newValue.getValues()));
                            continue;
                        }
                        existing = (ValueAndId)this.random.among((Object[])sortedValues.toArray(new ValueAndId[0]));
                        sortedValues.remove(existing);
                        uniqueValues.remove(existing.value);
                        updates.add(ValueIndexEntryUpdate.remove((long)existing.id, (IndexDescriptor)this.descriptor, (Value[])existing.value.getValues()));
                    }
                }
                this.updateAndCommit(updates);
                this.verifyRandomRanges(types, sortedValues);
            }
        }

        private void verifyRandomRanges(ValueType[] types, TreeSet<ValueAndId> sortedValues) throws Exception {
            for (int i = 0; i < 100; ++i) {
                Value to;
                BooleanValue booleanValue = this.random.randomValues().nextBooleanValue();
                ValueType type = (ValueType)this.random.among((Object[])types);
                Value from = this.random.randomValues().nextValueOfType(type);
                if (Values.COMPARATOR.compare(from, to = this.random.randomValues().nextValueOfType(type)) > 0) {
                    Value tmp = from;
                    from = to;
                    to = tmp;
                }
                boolean fromInclusive = this.random.nextBoolean();
                boolean toInclusive = this.random.nextBoolean();
                List<Long> expectedIds = Range.expectedIds(sortedValues, (Value)booleanValue, from, to, fromInclusive, toInclusive);
                PropertyIndexQuery[] predicates = new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)100, (Object)booleanValue), PropertyIndexQuery.range((int)101, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive)};
                List<Long> actualIds = this.assertInOrder(IndexOrder.ASCENDING, predicates);
                actualIds.sort(Long::compare);
                Assertions.assertThat(actualIds).isEqualTo(expectedIds);
                actualIds = this.assertInOrder(IndexOrder.DESCENDING, predicates);
                actualIds.sort(Long::compare);
                Assertions.assertThat(actualIds).isEqualTo(expectedIds);
            }
        }

        static List<Long> expectedIds(TreeSet<ValueAndId> sortedValues, Value booleanValue, Value from, Value to, boolean fromInclusive, boolean toInclusive) {
            return sortedValues.subSet(new ValueAndId(ValueTuple.of((Value[])new Value[]{booleanValue, from}), 0L), fromInclusive, new ValueAndId(ValueTuple.of((Value[])new Value[]{booleanValue, to}), 0L), toInclusive).stream().map(v -> v.id).sorted(Long::compare).toList();
        }

        private List<ValueTuple> generateValuesFromType(ValueType[] types, Set<ValueTuple> duplicateChecker, int count) {
            ArrayList<ValueTuple> values = new ArrayList<ValueTuple>();
            for (long i = 0L; i < (long)count; ++i) {
                ValueTuple value = this.generateUniqueRandomValue(types, duplicateChecker);
                if (value == null) continue;
                values.add(value);
            }
            return values;
        }

        private ValueTuple generateUniqueRandomValue(ValueType[] types, Set<ValueTuple> duplicateChecker) {
            ValueTuple value;
            int maxTries = 0;
            do {
                value = ValueTuple.of((Value[])new Value[]{this.random.randomValues().nextBooleanValue(), this.random.randomValues().nextValueOfTypes(types)});
                if (maxTries++ != 1000) continue;
                return null;
            } while (!duplicateChecker.add(value));
            return value;
        }

        private List<ValueIndexEntryUpdate> generateUpdatesFromValues(List<ValueTuple> values, MutableLong nextId) {
            ArrayList<ValueIndexEntryUpdate> updates = new ArrayList<ValueIndexEntryUpdate>();
            for (ValueTuple value : values) {
                updates.add(IndexEntryUpdate.add((long)nextId.getAndIncrement(), (IndexDescriptor)this.descriptor, (Value[])value.getValues()));
            }
            return updates;
        }
    }

    static abstract class Exact
    extends CompositeRandomizedIndexAccessorCompatibility {
        Exact(PropertyIndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1000, (int[])new int[]{100, 101, 102, 103})));
        }

        @Test
        void testExactMatchOnRandomCompositeValues() throws Exception {
            ValueType[] types = this.randomSetOfSupportedTypes();
            ArrayList<ValueIndexEntryUpdate> updates = new ArrayList<ValueIndexEntryUpdate>();
            HashSet<ValueTuple> duplicateChecker = new HashSet<ValueTuple>();
            for (long id = 0L; id < 30000L; ++id) {
                ValueIndexEntryUpdate update;
                while (!duplicateChecker.add(ValueTuple.of((Value[])(update = IndexEntryUpdate.add((long)id, (IndexDescriptor)this.descriptor, (Value[])new Value[]{this.random.randomValues().nextValueOfTypes(types), this.random.randomValues().nextValueOfTypes(types), this.random.randomValues().nextValueOfTypes(types), this.random.randomValues().nextValueOfTypes(types)})).values()))) {
                }
                updates.add(update);
            }
            this.updateAndCommit(updates);
            InMemoryTokens tokens = new InMemoryTokens();
            for (ValueIndexEntryUpdate update : updates) {
                List<Long> hits = this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)100, (Object)update.values()[0]), PropertyIndexQuery.exact((int)101, (Object)update.values()[1]), PropertyIndexQuery.exact((int)102, (Object)update.values()[2]), PropertyIndexQuery.exact((int)103, (Object)update.values()[3])});
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)hits.size(), (String)(update.describe((TokenNameLookup)tokens) + " " + String.valueOf(hits)));
                Assertions.assertThat((Long)((Long)Iterables.single(hits))).isEqualTo(update.getEntityId());
            }
        }
    }
}

