/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import org.mockito.Mockito;
import org.neo4j.annotations.documented.ReporterFactories;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.EmptyDependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.database.readonly.ConfigBasedLookupFactory;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.database.readonly.DefaultReadOnlyDatabases;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.PropertyIndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.RangeIndexProviderFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.monitoring.Monitors;

class RangeIndexProviderCompatibilitySuiteTest
extends PropertyIndexProviderCompatibilityTestSuite {
    RangeIndexProviderCompatibilitySuiteTest() {
    }

    @Override
    IndexProvider createIndexProvider(PageCache pageCache, FileSystemAbstraction fs, Path graphDbDir, Config config) {
        Monitors monitors = new Monitors();
        String monitorTag = "";
        RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = RecoveryCleanupWorkCollector.immediate();
        NamedDatabaseId defaultDatabaseId = DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID());
        DatabaseIdRepository databaseIdRepository = (DatabaseIdRepository)Mockito.mock(DatabaseIdRepository.class);
        Mockito.when((Object)databaseIdRepository.getByName("neo4j")).thenReturn(Optional.of(defaultDatabaseId));
        DefaultReadOnlyDatabases readOnlyDatabases = new DefaultReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{new ConfigBasedLookupFactory(config, databaseIdRepository)});
        DatabaseReadOnlyChecker readOnlyChecker = readOnlyDatabases.forDatabase(defaultDatabaseId);
        return RangeIndexProviderFactory.create((PageCache)pageCache, (Path)graphDbDir, (FileSystemAbstraction)fs, (Monitors)monitors, (String)monitorTag, (Config)config, (DatabaseReadOnlyChecker)readOnlyChecker, (RecoveryCleanupWorkCollector)recoveryCleanupWorkCollector, (LogProvider)NullLogProvider.getInstance(), (CursorContextFactory)CursorContextFactory.NULL_CONTEXT_FACTORY, (PageCacheTracer)PageCacheTracer.NULL, (String)"neo4j", (DependencyResolver)EmptyDependencyResolver.EMPTY_RESOLVER);
    }

    @Override
    IndexType indexType() {
        return IndexType.RANGE;
    }

    @Override
    boolean supportsSpatial() {
        return true;
    }

    @Override
    boolean supportsGranularCompositeQueries() {
        return true;
    }

    @Override
    boolean supportsBooleanRangeQueries() {
        return true;
    }

    @Override
    boolean supportsContainsAndEndsWithQueries() {
        return false;
    }

    @Override
    boolean supportsBoundingBoxQueries() {
        return false;
    }

    @Override
    void consistencyCheck(IndexPopulator populator) {
        ((ConsistencyCheckable)populator).consistencyCheck(ReporterFactories.throwingReporterFactory(), CursorContextFactory.NULL_CONTEXT_FACTORY, Runtime.getRuntime().availableProcessors());
    }
}

