/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionFailureHelper;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.util.ReadAndDeleteTransactionConflictException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class TransactionExceptionMappingIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private DatabaseManagementService managementService;

    TransactionExceptionMappingIT() {
    }

    @Test
    void transactionFailureOnTransactionClose() {
        TransactionFailureException rootCause = TransactionFailureHelper.internalError((String)this.getClass().getSimpleName(), (String)"Test failure", null, (Status)Status.Transaction.TransactionStartFailed);
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
            try (InternalTransaction tx = this.database.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
                tx.registerCloseableResource(() -> {
                    throw rootCause;
                });
                tx.commit();
            }
        });
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(TransactionFailureException.class)).hasRootCause((Throwable)rootCause);
    }

    @Test
    void nonTransientTransientFailureOnTransactionClose() {
        final ReadAndDeleteTransactionConflictException rootCause = ReadAndDeleteTransactionConflictException.conflictingTransactionState((boolean)true);
        this.managementService.registerTransactionEventListener(this.database.databaseName(), (TransactionEventListener)new TransactionEventListenerAdapter<Object>(this){

            public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
                throw rootCause;
            }
        });
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.database.beginTx();){
                tx.createNode();
                tx.commit();
            }
        });
        Assertions.assertThat((Throwable)e).isInstanceOf(TransactionFailureException.class);
    }

    @Test
    void transientTransientFailureOnTransactionClose() {
        final TransientTransactionFailureException rootCause = TransientTransactionFailureException.internalError((String)this.getClass().getSimpleName(), (String)"Deadlock detected.", (Status)Status.Transaction.DeadlockDetected);
        this.managementService.registerTransactionEventListener(this.database.databaseName(), (TransactionEventListener)new TransactionEventListenerAdapter<Object>(this){

            public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
                throw rootCause;
            }
        });
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.database.beginTx();){
                tx.createNode();
                tx.commit();
            }
        });
        Assertions.assertThat((Throwable)e).isInstanceOf(TransientTransactionFailureException.class);
    }

    @Test
    void transientExceptionOnDeadlockDetectedError() {
        final DeadlockDetectedException rootCause = DeadlockDetectedException.deadlockDetected((String)"No panic!");
        this.managementService.registerTransactionEventListener(this.database.databaseName(), (TransactionEventListener)new TransactionEventListenerAdapter<Object>(this){

            public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
                throw rootCause;
            }
        });
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.database.beginTx();){
                tx.createNode();
                tx.commit();
            }
        });
        Assertions.assertThat((Throwable)e).isInstanceOf(TransientTransactionFailureException.class);
    }

    @Test
    void transientExceptionOnAnyTransientException() {
        final ReadAndDeleteTransactionConflictException rootCause = ReadAndDeleteTransactionConflictException.conflictingTransactionState((boolean)false);
        this.managementService.registerTransactionEventListener(this.database.databaseName(), (TransactionEventListener)new TransactionEventListenerAdapter<Object>(this){

            public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
                throw rootCause;
            }
        });
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.database.beginTx();){
                tx.createNode();
                tx.commit();
            }
        });
        Assertions.assertThat((Throwable)e).isInstanceOf(TransientTransactionFailureException.class);
    }
}

